# 论文组图工具 - 自定义布局功能说明

## 新增功能：灵活的自定义布局支持

现在你可以使用两种方式定义布局：

### 1. 规则网格布局

**格式：** `2x2`, `3x3`, `4x2` 等

**说明：** 
- 支持大小写混用：`2x2`, `2X2`, `2×2`
- 格式为 `行数×列数`

**示例：**
- `2x2`：2行2列（4个图）
- `3x3`：3行3列（9个图）
- `3x2`：3行2列（6个图）
- `2x4`：2行4列（8个图）

---

### 2. 不规则布局（新增！）

**格式：** `[3,2]` 或 `3,2`

**说明：**
- 用逗号分隔每行的列数
- 下一行的图片会**自动水平居中对齐**
- 支持多行布局

**如何居中对齐的？**

以 `[3,2]` 为例：
```
上一行有3个图：  [图1] [图2] [图3]
                  ↓     ↓     ↓
下一行有2个图：     [图4] [图5]
               （正好对齐图2和图3之间的间隙）
```

计算逻辑：
- 上一行占满全宽，每个图占 1/3
- 下一行2个图，每个占 1/2
- 左边空出 (1 - 1/2×2) / 2 = 0 (刚好从左边界开始，正好对齐间隙)

---

### 3. 使用方法

在主窗口的 **"自定义布局"** 输入框中输入你的布局格式：

#### 步骤：
1. 在右侧面板中找到 **"布局模板"** 下拉菜单
2. 选择任何一个预定义布局（如 "2×2 网格"）
3. 此时会出现 **"自定义布局"** 输入框
4. 在输入框中输入你的布局格式，如 `[3,2]` 或 `3x3`
5. 按 Enter 或直接修改文本，布局会实时更新

---

### 4. 支持的格式示例

#### 规则网格：
- `2x2` → 2×2 网格（4个图）
- `3x2` → 3×2 网格（6个图）
- `4x3` → 4×3 网格（12个图）

#### 不规则布局：
- `[3,2]` → 上3下2（5个图）
- `[2,3,2]` → 上2中3下2（7个图）
- `[1,2,1]` → 金字塔形（4个图）
- `[4,3,2,1]` → 倒金字塔形（10个图）
- `[2,2,2,2,2]` → 5行各2个（10个图）

---

### 5. 功能特性

✅ **自动居中对齐** - 不规则布局的每一行都会自动水平居中
✅ **实时预览** - 输入时立即显示预览效果
✅ **灵活组合** - 支持任意行数和任意列数的组合
✅ **向后兼容** - 所有旧的预定义布局仍然可用
✅ **简单易用** - 无需复杂的图形界面操作

---

### 6. 技术细节

#### 不规则布局的计算方式

对于布局 `[a, b, c, ...]`（其中 a、b、c 是每行的列数）：

1. **行高** = 1 / 行数
2. **某行的列宽** = 1 / 该行列数
3. **该行的起始位置 X** = (1 - 该行列宽 × 该行列数) / 2

**例子：**

对于 `[3, 2]`：
- 共 2 行，行高 = 0.5
- 第 1 行：3 列，列宽 = 1/3，占用宽度 = 1，起始 X = 0
  - 图1：(0, 0, 0.333, 0.5)
  - 图2：(0.333, 0, 0.333, 0.5)
  - 图3：(0.667, 0, 0.333, 0.5)
- 第 2 行：2 列，列宽 = 0.5，占用宽度 = 1，起始 X = 0
  - 图4：(0, 0.5, 0.5, 0.5)
  - 图5：(0.5, 0.5, 0.5, 0.5)

✨ 注意：第 2 行的起始 X 为 0，所以图4、图5 的位置正好对齐图1-图3 中间的间隙！

---

### 7. 常见问题

**Q: 如果输入的布局数量与图片数量不匹配怎么办？**
A: 超出的图片不会显示，缺少的位置会留空。建议输入的格式能够容纳所有图片。

**Q: 可以修改间距吗？**
A: 可以，使用右侧面板中的 **"子图间距（mm）"** 调节。

**Q: 可以修改每个图的大小吗？**
A: 在 **"自定义模式"** 下可以，通过拖拽和工具栏按钮调节。在模板模式下（包括自定义布局），大小是由模板决定的。

---

祝你使用愉快！🎉
