# 论文组图工具（Figure Paper Tool）- 版本更新说明

## 🎉 v2.0 重大更新

本次更新带来了大量用户期待的功能和重要的BUG修复，大幅提升了使用体验和功能灵活性。

---

## ✨ 新增功能

### 1. 快捷自定义布局功能 ⭐⭐⭐⭐⭐

一个革命性的新功能，让您无需手动输入任何符号即可快速定义布局！

#### 特点
- **完全鼠标操作**：无需输入 `×` 号、`[]` 符号
- **两种布局模式**：
  - **规则网格**：行数×列数（如2行3列）
  - **不规则布局**：每行列数可不同（如上3下2，自动居中）
- **实时预览**：调整后立即看到效果
- **智能默认值**：第1行默认3个，其余行默认2个

#### 使用方法
1. 布局模板选择：**快捷自定义**
2. 选择布局类型：规则网格 / 不规则布局
3. 调整参数：
   - 规则网格：设置行数和列数（1-10）
   - 不规则布局：设置总行数，然后分别设置每行的列数
4. 自动生成布局！

#### 示例
- **4个图，2×2排列**：规则网格 → 2行×2列
- **5个图，上3下2**：不规则布局 → 2行 → 第1行3个，第2行2个
- **9个图，4-3-2金字塔**：不规则布局 → 3行 → 各行分别4、3、2个

#### 帮助系统
- 新增 **❓ 帮助按钮**
- 点击查看详细使用说明和示例表格
- 鼠标悬停有提示

---

### 2. 子图宽高比调整功能 ⭐⭐⭐⭐⭐

统一调整所有子图框的宽高比例，让布局更专业、更美观！

#### 预设比例
- **自动（默认）**：根据布局自动计算
- **1:1（正方形）**：所有子图都是正方形
- **4:3（横向）**：传统横向比例
- **16:9（横向）**：宽屏比例
- **3:4（竖向）**：竖向比例
- **9:16（竖向）**：竖屏比例
- **自定义比例**：输入任意宽高值（0.1-10.0）

#### 智能特性
- **自动调整画布高度**：根据宽高比自动计算理想高度，保持布局紧凑美观
- **所有框统一**：无论哪个布局，所有框的宽高比完全一致
- **实时预览**：改变比例立即看到效果
- **保持布局结构**：只改变框的比例，不改变相对位置

#### 模式兼容性
- ✅ **模板模式**：完全支持（预定义模板 + 快捷自定义）
- 🚫 **自定义模式**：智能禁用（保持完全手动控制的纯粹性）

---

### 3. 右侧参数面板滚动功能 ⭐⭐⭐⭐

解决参数过多时显示不全的问题！

#### 特点
- **垂直滚动条**：需要时自动显示
- **禁用横向滚动**：保持面板宽度
- **内容自适应**：宽度自动适配
- **流畅操作**：鼠标滚轮即可滚动

---

### 4. 不规则布局统一框尺寸 ⭐⭐⭐⭐

优化不规则布局算法，确保所有子图框大小完全一致！

#### 改进前
```
[3,2]布局：
第1行每个框宽 = 1/3
第2行每个框宽 = 1/2  ❌ 不一致
```

#### 改进后
```
[3,2]布局：
所有框宽 = 1/3（基于最大列数）✅ 完全一致
第2行自动居中对齐
```

#### 效果
- 所有框完全一样大
- 视觉更统一、更美观
- 保持居中对齐

---

## 🐛 重大BUG修复

### 1. 导入图片时布局混乱 🔥🔥🔥

**问题**：设置好布局后，导入图片会导致布局完全重建，框数量和位置都乱掉

**修复**：改为智能更新机制
- 只更新图片分配到框内，不重建布局
- 只在图片数量超过框数量时才重建
- 保持布局稳定性

**影响**：所有布局模式

---

### 2. 画布工作区不显示图片 🔥🔥🔥

**问题**：导入图片后，预览区正常显示，但画布工作区只显示空白框架

**修复**：在更新图片路径后，重新加载图片到pixmap

**效果**：画布和预览完全同步显示

---

### 3. 预览不实时更新 🔥🔥

**问题**：修改布局、宽高比等参数后，预览区不更新，必须重新导入图片才能看到变化

**修复**：在所有布局变化后自动触发预览更新

**效果**：任何修改都实时反映在预览中

---

### 4. 初始化顺序错误 🔥

**问题**：启动时显示 `'MainWindow' object has no attribute 'sp_gap'` 错误

**修复**：添加UI初始化检查，避免在未初始化完成时执行布局

**效果**：启动更快、更干净、无错误信息

---

## 🎨 用户体验优化

### 1. 右侧面板默认宽度调大
- 从 `1:2:1` 调整为 `1:2:2`（左:中:右）
- 更方便查看和操作参数

### 2. 子图宽高比布局自动优化
- 设置宽高比后，自动计算理想画布高度
- 避免行间距过大
- 布局始终紧凑美观

### 3. 预览区空间利用优化
- 中间区域内部比例从 `1:1` 调整为 `1:2`
- 预览区占更多空间
- 更容易检查细节

---

## 📋 完整功能列表

### 布局模式

| 模式 | 特点 | 宽高比 | 手动调整 |
|------|------|--------|----------|
| **预定义模板** | 快速标准布局 | ✅ | 🚫 |
| **快捷自定义** | 鼠标点击定义行列 | ✅ | 🚫 |
| **自定义模式** | 完全手动控制 | 🚫 | ✅ |

### 核心功能
- ✅ 拖拽导入图片（文件/文件夹）
- ✅ 拖拽排序图片
- ✅ 多种预定义布局（2×2、3×2、1+2等）
- ✅ 快捷自定义布局（新增）
- ✅ 不规则布局（上3下2等）
- ✅ 子图宽高比调整（新增）
- ✅ 自定义画布尺寸
- ✅ 子图间距调整
- ✅ 外边距调整
- ✅ 图片适配模式（裁剪/缩放/拉伸）
- ✅ 子图标注 (a)(b)(c)
- ✅ 标注位置（左上/左下/自定义）
- ✅ 标注颜色（黑色/白色）
- ✅ 标注样式（无框/有框/半透明）
- ✅ 单个子图独立标注设置
- ✅ 子图边框（显示/隐藏/样式/颜色）
- ✅ 添加标题
- ✅ 实时预览（优化）
- ✅ 画布编辑器（双击编辑图片）
- ✅ 图片取景调整（平移/缩放）
- ✅ 导出格式（PNG/JPEG/TIFF）
- ✅ 多种DPI（300/600/900）
- ✅ 撤销/重做
- ✅ 布局保存/加载

---

## 🚀 使用建议

### 标准论文排图工作流
1. **导入图片**：拖拽5张图到图片列表
2. **选择布局**：快捷自定义 → 不规则布局 → 2行 → [3,2]
3. **设置宽高比**：1:1（正方形）
4. **调整参数**：
   - DPI: 600
   - 子图间距: 2mm
   - 标注: 左上角，黑色
5. **预览确认**：检查右侧预览效果
6. **导出**：PNG格式

### 创意自由布局工作流
1. **选择自定义模式**
2. **导入图片**（或使用现有布局转换）
3. **手动调整**：拖拽、缩放每个框
4. **图片编辑**：双击框进入图片编辑模式
5. **对齐工具**：使用工具栏对齐、分布按钮
6. **导出**

---

## 🔧 技术改进

### 代码优化
- 重构布局应用逻辑，分离"更新图片"和"重建布局"
- 添加UI初始化保护机制
- 优化预览触发机制
- 改进宽高比计算算法

### 性能提升
- 减少不必要的布局重建
- 优化预览更新（120ms防抖）
- 智能禁用功能（自定义模式下禁用宽高比计算）

### 稳定性增强
- 修复多个导致布局混乱的BUG
- 添加边界条件检查
- 改进错误处理

---

## 📦 兼容性

- **Python 3.8+**
- **依赖库**：
  - PySide6
  - Pillow (PIL)
  
---

## 🙏 致谢

感谢所有用户的反馈和建议，本次更新的很多功能都来源于实际使用中的需求！

---

## 📝 更新日志摘要

- ✨ 新增快捷自定义布局功能（完全鼠标操作）
- ✨ 新增子图宽高比调整功能（7种预设+自定义）
- ✨ 新增帮助系统（❓按钮+详细说明）
- ✨ 新增右侧参数面板滚动功能
- 🐛 修复导入图片时布局混乱的重大BUG
- 🐛 修复画布工作区不显示图片的BUG
- 🐛 修复预览不实时更新的BUG
- 🐛 修复初始化顺序错误
- 🎨 优化不规则布局算法（统一框尺寸）
- 🎨 优化UI布局（右侧面板、预览区）
- 🎨 智能禁用功能（自定义模式下禁用宽高比）
- ⚡ 改进布局更新机制（只更新图片，不重建布局）
- ⚡ 自动优化画布高度（根据宽高比）
- 📚 完善提示和说明

---

## 🔜 未来计划

欢迎在GitHub Issues中提出您的建议和需求！

---

**上次更新**: 2026-01-14  
**主要贡献者**: @[您的GitHub用户名]
