## 高校，为何最快拥抱 DeepSeek？

![](https://imgpai.thepaper.cn/pph/newpai/image/20250314/96934c52-8704-483a-949a-110c43a04a64.jpg)

> DeepSeek 推出 R1 后，高校是动作最为迅速的行业之一，也是最早挑战应用场景和落地技术门槛的行业。

DeepSeek 开年扔下的一块巨石，砸起了各行各业的水波荡漾。

政务、金融、医疗、制造等多个领域，动态不断。高校也不例外，多位行业人士透露，在 2025 年初的这波 DeepSeek 掀起的大模型应用热潮中，高校是态度最为积极、动作最为迅速的几大行业之一。

近期，国内多所高校，正在紧锣密鼓官宣引入 DeepSeek 服务的消息。“有几十个学校都宣布引入了。”北京大学计算中心系统管理室主任樊春观察，不仅是高校，甚至一些中学也在引入 DeepSeek。

北京大学计算中心也在 3 月 13 日发布通知，除了为全校师生提供基于公有云的 DeepSeek 对话服务，北大本地化部署的 DeepSeek 满血版 R1 和 V3 也已深度适配教学应用场景，向校内多项人工智能应用北大问学、AIMD(北大人工智能医学博士）、化小北、金融 AI 助教提供服务，成为又一家官宣引入 DeepSeek 服务的高校。

![](https://imgpai.thepaper.cn/pph/newpai/image/20250314/6877ed49-203a-4466-8f59-34cbf19a30bc.jpg)

“DeepSeek 出来后，校内很多业务部门的相关负责人希望能让他们的应用也使用上，一直在催着我们上线 DeepSeek。”樊春说。

DeepSeek 到底给高校市场带来了哪些影响和改变？2025 年，高校大模型落地市场，又有哪些新机遇和新要求？

### 01、国内高校，为何纷纷拥抱 DeepSeek?

2025 年初的这波 DeepSeek 应用热潮中，高校的动作积极且迅速。

“高校和科研院所算是各行各业里响应比较早的。因为 DeepSeek 是最先在学术圈‘爆炸’，然后扩大到技术应用圈和产业圈。”大模型行业应用开发商众数信科创始人兼 CEO 吴炳坤告诉数智前线，他们从大年初二开始，就陆陆续续接到很多客户的咨询，全是问怎么用 DeepSeek 模型结合本地数据，构建自己的专属业务场景的，这其中就包括不少高校客户。

北京大学计算中心系统管理室主任樊春也透露，虽然北大最近才正式上线 DeepSeek 相关服务，但他们其实很早就关注到这个事情，开始了相关准备工作，以便模型上线后能直接敞开给全校使用，且稳定运行。

“去年，有不少学校都经陆陆续续有大模型方面的需求，在去做尝试，但今年初 DeepSeek 的爆火确实进一步加大了需求。”百度智能云教育行业高级解决方案架构师张湘悦说，目前他们在校园管理、科研等方向都已看到不少需求。

为什么 DeepSeek 能在高校领域掀起如此大规模且迅速的跟进潮？

一方面是因为 DeepSeek 在基础模型能力上的大幅提升，填补了此前高校难以得到好用的本地化部署大模型使用体验的需求空白。

业界观察，之前闭源模型在很多场景下，无法做到私有化交付，即便能做到，成本也很高昂。而以前的开源模型，虽然也可以本地化部署，但不像 DeepSeek 开源这么彻底，最高版本都是收费的，成本仍然较高，开放出来的更小参数规模的模型，本地化部署的质量也普遍不高，“学校的老师用了这个模型觉得很笨，就不会再用，宁肯用外面的模型”。但由于学校也对数据不出域有着较多要求，不能本地化部署，也就意味着大模型相关的很多应用无法真正起来。

DeepSeek 的出现改变了这种局面，让更多高校用户愿意去将大模型用起来。

“DeepSeek 是第一个本地化部署后，能达到与 OpenAI 提供的业界最好的模型差不多智能水平的开源模型。”樊春告诉数智前线，很多学校之前做了一些 AI 应用，现在能够本地化部署了，更多老师希望基于本地化 DeepSeek 去做新应用开发。

另一方面，DeepSeek 在成本上实现的更高的性价比，也催动着高校用户们的热情。

樊春透露，虽然满血版的 DeepSeek 参数量要比之前能够本地化部署的一些开源模型大上很多，算力方面所需的成本更高，但效果也更好，投资回报是划算的，大家的使用意愿更高。而上海交大赵海教授去年果断弃用 GPT-4，改用 DeepSeek-V3 生成合成数据，开发垂类大模型，原因正是 DeepSeek-V3 性能与 GPT-4 处于同一量级，而价格只有其十分之一。

而满血版之外，DeepSeek 蒸馏版的成本更低，也能在一些场景实现不错的效果，成为不少高校用户的一大选择。

“比如我们先去做一些 DeepSeek 的模型蒸馏，来降低算力需求，在此基础上，再结合客户独有的数据，去做一些强化学习，保证更好的效果，理论上，能将 AI 课题成本降低到原来的 10%，考虑工程化及与其他大小模型的融合，成本大概能达到是原来的 1/4。”众数信科吴炳坤说。

另外，高校去年曾进行过一波智算基础设施投入的加码。樊春告诉数智前线，一些高校手上已有的智算服务器资源，也能更快满足这波 DeepSeek 本地化部署的算力需求，实现快速上线。

事实上，由于应用热情的激增，带动着算力使用需求的增加，在最近的一波一体机采购潮中，高校也是重要的采购方。神州数码信创业务集团产品中心总经理李川告诉数智前线，他们看到目前对一体机需求较多的 5 大行业分别是政府政务、教育科研、医药医疗、金融和智能制造。

模型效果、私有化部署、成本可控、算力资源等几个条件叠加在一起，国内各高校的场景需求，一下就释放出来了，大模型在高校的落地进程正被大幅加速。

### 02、教研管服应用全线开启，但落地仍有门槛

DeepSeek 带动下，高校领域的大模型应用场景正在快速扩大。

“类比移动互联网时代，2024 年相当于当年 iPhone 早期，很多 App 做尝鲜。DeepSeek 出来后，一夜之间，大家好像直接跨到了 iPhone4、iPhone4s 的阶段。”众数信科吴炳坤告诉数智前线，以前，很多老师对大模型只是抱着试试看的态度，DeepSeek 出来后，则变成了大家都有强烈的信心和动力——“我要把它用起来”。

也因此，最近官宣接入 DeepSeek 的不少高校，实际都已将大模型用到了教学、科研、管理、服务等全线场景中去尝试、探索。

其中，校园信息化管理和服务场景的 AI 是最先落地的。

“去年初，我们跟华北电力大学联合开发了大模型支撑的‘i 华电’AI 助理，校园卡、网费充值、图书馆借阅查询等，都可以一句话，获取相关服务。”百度张湘悦告诉数智前线。

而在最新这波 DeepSeek 应用潮中，绝大部分高校也都将这一类场景的赋能，作为落地第一步，各种门槛相对较低的问答式校园 AI 管理助手，在更多高校中进行大规模复制。

各种教学辅助环节，则是高校较多去探索落地的场景之一。

比如北大近期宣布深度适配了 DeepSeek 满血版 R1 和 V3 的几大主要人工智能应用——北大问学（AI 辅助教学系统）、AIMD（北大人工智能医学博士）、化小北、金融 AI 助教等，就都是其此前已经开发出的一些面向教学场景的 AI 应用。

众数信科则在去年，通过大模型助力一些高校实现了学生学习效果测评系统和教师教学质量测评系统的升级。教育行业存在不可能的三角，即同时实现大规模、高质量和个性化。而 AI 的出现，正在改变这种现状。

在高校学生培养计划中，存在大量评测维度，如果按照传统做法，依靠编程，针对上万乃至数万学生，则只能进行一些通用评测，很难实现个性化定制。但有了大模型后，众数信科针对课堂环节，通过多个智能体协同合作，实现了突破。如有的智能体负责转录授课语音，有的进行授课水平的分析对比；有的生成随堂小测试卷，有的现场批改试卷；还有的针对每个学生的薄弱点，进一步推荐学习材料，在个性化、规模化和高质量教学上实现突破。

![](https://imgpai.thepaper.cn/pph/newpai/image/20250314/6e796ab2-1bf2-4154-a972-bcc65b9ac3d5.jpg)

一些此前难以实现的更为复杂的教学辅助场景也在加速被探索。

比如互动式教学场景，由于一个老师要面对很多学生，很难根据个体特性去设计教学方案，一些高校因此希望能通过智能 AI 助教，给每位学生的学习行为打标签，并设计针对性的教学方案，实现因材施教。

“之前还需要在模型层做大量优化，以及很多的智能体编排，做一门 AI 互动课，定制化成本很高。”百度张湘悦告诉数智前线，今年随着模型能力的提升，技术门槛不断降低，相关成本有望被摊薄。

除此之外，教学实训，也是高校的需求点所在。“从 2023 年大模型火起来后，一些高校就会开一些实践课程，需要学生去做一些实操。”科大讯飞星火军团智算产品负责人罗雷告诉数智前线，这种场景的需求今年进一步增长，并进而增加了对一体机的需求，“一间教室可以配一台一体机”。

吴炳坤也表示，此前这种 AI 实训平台，最差的软硬件加在一起也要两三百万元，DeepSeek 来了后，由于开源加上算力的降低，“可能一下子就拉到几十万的一个数量级”，应用场景也随之打开。

另外，在科研方面，AI for Science 的热潮自去年下半年就已经起来，像上海交通大学，已转变传统科研模式，期望科学与 AI 更紧密的结合。他们与百度智能云合作建成了 AI for Science 科学数据开源开放平台，支撑白玉兰科学大模型的训练。依托 AI for Science 平台，上海交大已在 Nature Computational Science 封面，发表了 AI+城市的科学成果。

不过，业界也看到，虽然高校落地大模型的场景在快速拓宽，但大模型的落地门槛仍然不低。

多位行业人士告诉数智前线，云端调用的方式相对简单，但更多高校出于数据安全需求，还是选择私有化部署。而这个过程中，有着大量的落地技术门槛。

“首先你得有设备，其次还得有人，要么自己有技术团队，要么找有实力的服务商，做相应的开发和优化调整工作，才能支撑 DeepSeek 稳定服务，不至于人一多就垮掉。”北京大学樊春告诉数智前线，大家都希望能用更少的资源和经费，达到一个更好的效果，但这也对高校和服务商们提出了更高的要求。也因此，目前，各个学校引入 DeepSeek 后的效果 ，可能都是不一样的。

现在，高校和服务商们在探索一些新方法。比如，3 月 9 日，北京大学和华为联合发布了一套 DeepSeek 全栈开源推理方案，以此来帮助开发者提升推理性能。

众数信科吴炳坤则介绍，先将开源模型蒸馏，获得更小参数的模型，来降低算力需求，再通过强化学习而不是之前的微调和 RAG，将数据训练到模型上去。而模型经过强化学习以后，可以反向指导它的深度推理质量。通过这种方法，一些用户实测将比 DeepSeek 拿来后直接使用，准确率高出 15%~20%。

### 03、中长尾需求在起来

随着 DeepSeek 卷起应用浪潮，业界观察，高校领域的中长尾需求正在起来。

“以前一些双非院校或职校里的老师，平时能够掌握的经费是比较少的。DeepSeek 出来后，第一，算力大大降低了，第二，模型本身也不需要钱了，这类客户未来可能就都能用得上了。”众数信科吴炳坤说。

神州数码李川也告诉数智前线，现在不光是头部院校，他们在专科、职教都已经看到了需求，而且不只在学校级别，在院系级，甚至教研组级别，也都有大模型本地化部署的一些需求。

北京大学樊春则观察，今年，大模型正在从助力研究，进入更多去助力改善服务，“很多双非院校做研究决策比较困难，因为 AI 的投入都比较大，校长他会想，我投入后，能不能出成果或者有效果，因为研究出成果本来就有随机性，但服务是可以比较容易看到效果的。”

针对这些特点，一些产业链上的服务商已经布局。

一些企业，尤其是云公司，强化全栈优势。如从百度智能云对外的信息看，有国产自主昆仑芯万卡集群、百舸异构算力平台的算力调度中枢、飞桨深度学习框架和千帆大模型平台，以及产学研协同创新的举措。

科大讯飞在 3 月 3 日联合华为，迭代新一代星火一体机，并首次推出针对医疗、高教、政务、警务、法律五大全新应用场景的一体机产品。

高校仍将是众数信科今年的一大重点市场。2 月 13 日，众数信科还联合中国移动，推出了大模型一体机，预装 DeepSeek 等大模型，并通过“以租代购”的方式，将租用价格直接打到了每月千元档位。“现在很多客户对于 AI 智能体有极强的动力，但等不及去立项、走流程。”吴炳坤说，这个模式可以满足客户快速尝鲜的需求。

神州数码李川透露，他们推出了大模型一体机“全家桶”，大到超百万元，小到 10 余万元级别的方案都可以提供，学校的一些教研组或个别研究生，都可以选用轻量级的方案，去实现 DeepSeek 部署。

“去年很多学校已经都打好样了，而且 DeepSeek 一出来，也降低了使用门槛，今年中长尾的学校，再去复制，就能少走很多弯路。而且很多学校去年都建设了算力，今年 DeepSeek 出来，正好把去年的算力都能用上，所以今年肯定是应用井喷的一年。”百度张湘悦说。

樊春则判断，随着对大模型的进一步应用，高校今年的算力基础设施投入也会继续加大，一方面，AI for Science 的风潮还在继续，需要较多算力，另一方面，AI 在教学、管理、服务等更多校园场景的应用，也会带动算力需求进一步增长。

高校大模型落地将如何发展，我们还将继续观察。

> 来源：澎湃新闻
