# 日本如何看待Deepseek

Deepseek风靡中国，轰动世界，成为春节期间中国社会的一股滚滚向前的暖流，成为最提升我们中国人科技自信的一款AI产品。

美国和欧洲一些国家的政府，开始警惕和排斥这一款来自于中国的生成式AI大规模语言模型，把它视为“威胁产品”。那么，日本社会是如何评价和对待Deepseek的呢？

专门研究推广美国ChatGPT的日本フィクスドスター株式会社（恒星公司）发表了一篇对Deepseek的分析文章。

文章说，同样规模的大型模型，开发成本在1亿美元左右的情况并不少见。例如，OpenAI的GPT-4的开发成本据说就高达数亿美元，而DeepSeek仅用两个月时间就能以 550 万美元的价格开发出来，这种降低成本和快速开发让许多的AI公司大吃一惊。尤其是在美国商务部对Nvidia H800 这款 GPU 出口中国实行了限制的背景下，DeepSeek公司是如何在短时间内维持一个大型 GPU 集群并学习大量参数，这非常令人关注。DeepSeek V3 拥有 6710 亿个参数，可为全球人工智能界提供新的选择。

但是文章也指出，随着参数数量和训练数据量的增加，成本、监管和性能方面的障碍也越来越高，DeepSeek能否真正成为OpenAI 和 Meta 的竞争对手，将是真正的考验。同时，最终是否能够被全球采用，将是未来面临的一大重大挑战。

![](https://nimg.ws.126.net/?url=http%3A%2F%2Fdingyue.ws.126.net%2F2025%2F0214%2F09958c15j00srndwz0016d200u000k1g00it00cj.jpg&thumbnail=660x2147483647&quality=80&type=jpg)  

野村综合研究所战略分析师長谷佳明在日本经济新闻上发表文章说，DeepSeek威胁了美国，而且以低成本、高性能，堪称“人工智能的人造卫星”，中国人工智能的创新力颠覆了人们的常识。

不过，他也指出，DeepSeek压倒性的低成本得益于模型的结构和学习方法。尽管有一些令人眼睛一亮的表现，如强化学习的有效应用，但其中许多基本的技术与结构大多是对现有理论的发展和改进。换句话说，这在很大程度上要归功于对世界已有的开源技术与理论的整合，以及实现这些理论的技术，它还不是全新的理论。但是，作为一家小规模的初创企业，能够开发出如此高性能的模型，将会对世界产生巨大影响。

被称为“日本研究AI第一人”的东京大学教授松尾丰先生在接受日本经济新闻采访时说，中国的AI水平相当高，可以与美国比肩。至少从顶尖（学会采纳的）论文数量来看，中国已经超过美国。另外，中国还有阿里巴巴、腾讯、百度等其他很多实力强劲的企业，拥有众多优秀工程师。在这样的生态系统中，AI不断得到开发与应用，出现DeepSeek这样极具实力的企业，并不令人惊讶。

松尾教授指出，DeepSeek的技术很出色，性能与运营“ChatGPT”的美国OpenAI接近。日本也需要努力开发生成式AI模型。像DeepSeek这样并非大型科技企业、也没有雄厚资本的公司，竟然能够实现世界最先进的精度，这对日本的初创企业来说也是一种鼓舞。

对于如何看待使用DeepSeek的安全风险问题，松尾教授认为：“是利用DeepSeek的开源还是使用其服务？根据使用方式的不同，风险也不同。开源可以下载程序并在本地运行。这样的话，数据不可能被发送到某个地方。另一方面，DeepSeek的APP服务在中国的服务器上运行。一旦输入数据，这些数据就会发送到中国的服务器，在中国进行处理并返回。这一点，不管对于中国的DeepSeek还是美国的OpenAI来说都一样。这是一个你对对方投以多大信任的问题。”

![](https://nimg.ws.126.net/?url=http%3A%2F%2Fdingyue.ws.126.net%2F2025%2F0214%2F3cfa5c98j00srndwz0023d200sg00itg00it00cf.jpg&thumbnail=660x2147483647&quality=80&type=jpg)  

那么，日本政府目前是如何看待DeepSeek的呢？

2 月 3 日，日本政府的个人信息保护委员会在其网站上发表声明指出，Deepseek 的隐私政策只有中文和英文版，日本用户很难理解其内容。而且包含个人信息的数据存储在中国的服务器上，并根据中国的法律法规处理这些数据，存在风险。

日本内阁官房长官林芳正在4 日的记者会上表示，目前日本政府无意实施全面禁止使用的措施，各机构可自行决定是否使用这种外部服务。

但在6 日的记者会上，林芳正又发表谈话说：“政府对DeepSeek的性能和风险不予置评。但政府关注人们提出的担忧和媒体的报道，我们正在采取适当的措施”。

DeepSeek是否只是成为“中国的DeepSeek”，还是最终成为“世界的DeepSeek”？对于梁文锋领导的这一支年轻而优秀的团队来说，确实面临考验和挑战。

---

来源：网易新闻

