# DeepSeek的“服务器繁忙”让所有人抓狂，背后究竟是怎么回事

此前不太被大众所知的DeepSeek，因2024年12月26日推出对标GPT 4o的语言模型V3而声名鹊起。在1月20日DeepSeek又发布对标OpenAI o1的语言模型R1，之后因为“深度思考”模式生成的答案优质度高，以及其创新揭示出模型训练前期成本可能骤降的积极信号，令该公司和应用彻底出圈。之后，DeepSeek R1就一直在经历拥堵，它的联网搜索功能间歇性瘫痪，深度思考模式则高频率提示“服务器繁忙”，此类现象让大量用户倍感困扰。

十几日前，DeepSeek开始经历服务器中断，1月27日中午，DeepSeek官网已数次显示“deepseek网页/api不可用”，当日，DeepSeek成为周末期间iPhone下载量最高的应用程序，在美区下载榜超越了ChatGPT。

![](https://img.huxiucdn.com/article/content/202502/13/103644776598.jpg?imageView2/2/w/1000/format/webp/interlace/1/q/85)

2月5日，DeepSeek移动端上线26天，日活突破4000万，ChatGPT移动端日活为5495万，DeepSeek为ChatGPT的74.3%。几乎在DeepSeek走出陡峭增长曲线的同时，关于其服务器繁忙的吐槽纷至沓来，全世界用户都开始遭遇问几个问题就发生宕机的不便，各类替代访问也开始出现，比如DeepSeek的平替网站，各大云服务商、芯片厂商和基础设施公司都纷纷上线，个人部署教程也到处都是。但人们的抓狂却没有缓解：全球几乎所有重要厂商都宣称支持部署了DeepSeek，但各地用户却依然在吐槽服务的不稳定。

这背后到底发生了什么？

一、习惯了ChatGPT的人们，受不了打不开的DeepSeek

人们对“DeepSeek服务器繁忙”的不满，来自于此前以ChatGPT为主的AI顶流应用们，甚少出现卡顿。

自OpenAI服务推出以来，ChatGPT虽然也经历了几次P0级别宕机事故，但总体来说，它相对可靠，已然在创新和稳定性之间找到平衡，并逐步成为类似传统云服务的关键组成部分。

![](https://img.huxiucdn.com/article/content/202502/13/110738617305.jpg?imageView2/2/w/1000/format/webp/interlace/1/q/85)

ChatGPT大范围宕机次数并不算多

ChatGPT的推理过程相对稳定，包括编码和解码两个步骤，编码阶段把输入文本转换成向量，向量包含输入文本的语义信息，解码阶段，ChatGPT使用先前生成的文本作为上下文，通过Transformer模型生成下一个单词或短语，直到生成符合需求的完整语句，大模型本身属于Decoder架构，解码阶段就是一个个token的输出过程，每向ChatGPT提问一次，就启动一次推理流程。

举例来说，如果向ChatGPT提问，“你今天心情如何”，ChatGPT会对这句话进行编码，生成每层的注意力表示，根据之前所有token的注意力表示，预测得到第一个输出token "我"，之后进行解码，将“我”拼接到“你今天心情如何？”，后面得到“你今天心情如何？我”，得到新的注意力表示，然后预测下一个token:"的"，之后按照第一步，第二步循环，最终得到“你今天心情如何？我的心情很好。”

编排容器的工具Kubernetes是ChatGPT的“幕后指挥官”，它负责调度和分配服务器资源。当涌入的用户承载完全超出Kubernetes控制平面的承受能力时，就会导致ChatGPT系统的全面瘫痪。

ChatGPT发生瘫痪的总次数不算太多，但这背后是它依靠的强大资源作为支撑，维持稳定运转背后是强大算力，而这是人们忽视的地方。

一般而言，由于推理处理的数据规模往往较小，因此对算力的要求不如训练般高。有业界人士估算指出，在正常大模型推理过程中，显存的主要占用模型参数权重占大头，大概占比在80%以上。现实情况是，在ChatGPT内置的多个模型中，里面默认模型尺寸都比DeepSeek-R1的671B要小，加上ChatGPT拥有比DeepSeek多得多的GPU算力，自然展现出比DS-R1更为稳定的表现。

DeepSeek-V3与R1都是一个671B的模型，模型启动过程就是推理的过程，推理时的算力储备需要与用户量相衬，比如有1亿用户量就需配备1亿用户量的显卡，不仅庞大，且与训练时的算力储备独立开来，并不相关。从各方信息看，DS的显卡和算力储备明显不足，于是频频卡顿。

这种对比让适应了ChatGPT丝滑体验的用户并不习惯，特别是他们对R1的兴趣愈发高涨的当下。

二、卡，卡，还是卡

而且，仔细对比，OpenAI和DeepSeek遇到的情况是很不同的。

前者有微软做后盾，作为OpenAI的独家平台，微软Azure云服务搭载了ChatGPT、Dalle-E 2图像生成器、GitHub Copilot自动编码工具，此后，这一组合成为了云+AI的经典范式，并快速普及成为业界标配；后者虽是初创，却大部分情况下依靠自建数据中心，与谷歌类似，而不依赖第三方云计算提供商。硅星人查阅公开信息后发现，DeepSeek在任何层面都没有跟云厂商芯片厂商开启合作。

而且，DeepSeek遇到了史无前例的用户增长，这意味着它对应激情况的准备时间也比ChatGPT更少。

DeepSeek的良好性能来自其在硬件和系统层面做出的整体优化。DeepSeek的母公司幻方量化，早在2019年就花了2亿打造萤火一号超算集群，到22年就默默存储万张A100显卡，为了更高效的并行训练，DeepSeek自研了HAI LLM训练框架。业界认为，萤火集群可能采用了数千至数万张高性能GPU，以提供强大的并行计算能力。目前萤火集群支撑了DeepSeek-R1、DeepSeek-MoE等模型训练，这些模型在数学、代码等复杂任务中表现接近于GPT-4水平。

萤火集群代表着DeepSeek在全新架构和方法上的探索历程，也让外界认为，通过这类创新技术，DS降低了训练的成本，可以仅需西方最先进模型几分之一的算力，就训练出与顶级AI模型性能相当的R1。SemiAnalysis经推算指出，DeepSeek实际拥有庞大的算力储备：DeepSeek共堆砌了6万张英伟达GPU卡，其中包括1万张A100、1万张H100、1万张“特供版”H800以及3万张“特供版”H20。

这似乎意味着R1的卡量比较充足。但实际上，作为推理模型的R1，对标的是OpenAI的O3，这类推理模型需要部署更多算力用于应答环节，但DS在训练成本侧节约的算力，与推理成本侧骤增的算力，孰高孰低，目前并不明确。

值得一提的是，DeepSeek-V3和DeepSeek-R1都是大语言模型，但运作方式有差。DeepSeek-V3是指令模型，类似ChatGPT，接收提示词生成相应文本进行回复。但DeepSeek-R1是推理模型，用户向R1提问时，它会首先进行大量的推理过程，然后再生成最终答案。R1生成的token中首先出现的是大量的思维链过程，模型在生成答案之前，会先解释问题，分解问题，所有这些推理过程都会以token的形式快速生成。

在耀途资本副总裁温廷灿看来，前述DeepSeek庞大的算力储备是指训练阶段，训练阶段算力团队可规划，可预期，不容易出现算力不足，但推理算力则不确定性较大，因为主要取决于用户规模和使用量，相对来说弹性较大，“推理算力会按照一定规律增长，但随着DeepSeek成为现象级产品，短时间内用户规模和使用量爆炸性增长，这导致推理阶段算力需求爆炸性增长，所以出现卡顿。”

即刻上活跃的模型产品设计师，独立开发者歸藏认同卡量是DeepSeek卡顿的主因，他认为DS作为当前在全球140个市场下载量最高的移动应用，现在的卡无论如何都撑不住，哪怕用新的卡也不行，因为“新的卡做云是需要时间”。

“英伟达A100、H100等芯片运行一个小时的成本有公允的市场价格，DeepSeek从输出token的推理成本上看是比OpenAI同类模型o1便宜90%以上，这个跟大家的计算偏差不大，因此模型架构MOE本身不是最主要问题，但DS拥有的GPU数量决定了他们每分钟最多可以生产提供的token数，即便可以把更多GPU用来做推理服务用户，而不用于预训练研究，但上限在那摆着。”AI原生应用小猫补光灯的开发者陈云飞持类似观点。

也有业界人士向硅星人提到，DeepSeek卡顿本质在于私有云没有做好。

黑客攻击则是R1卡顿另一驱动因素。1月30日，媒体从网络安全公司奇安信获悉，针对DeepSeek线上服务的攻击烈度突然升级，其攻击指令较1月28日暴增上百倍。奇安信Xlab实验室观察到至少有2个僵尸网络参与攻击。

但这种R1自身服务的卡顿，有一个看起来比较显然的解决方案，是第三方提供服务。这也是我们在春节期间目睹的最为热闹的景观——各家厂商纷纷部署服务，承接人们对DeepSeek的需求。

1月31日，英伟达宣布，NVIDIA NIM已经可以使用DeepSeek-R1，此前英伟达受DeepSeek影响，一夜市值蒸发近6000亿美元。同天，亚马逊云AWS的用户可以在其人工智能平台，Amazon Bedrock和Amazon SageMaker AI中部署DeepSeek最新R1基础模型。随后，包括Perplexity，Cursor在内的AI应用新贵，也批量接入DeepSeek。微软则抢在亚马逊、英伟达之前，率先把DeepSeek-R1部署在了云服务Azure和Github上。

2月1日大年初四开始，华为云，阿里云，字节跳动旗下的火山引擎和腾讯云也加入其间，他们一般提供的是DeepSeek全系、全尺寸模型部署服务。再之后是壁仞科技、瀚博半导体、昇腾、沐曦等AI芯片厂商，他们自称适配了DeepSeek原版或更小尺寸的蒸馏版本。软件公司方面，用友、金蝶等是在部分产品中接入DeepSeek模型，增强产品力，最后是终端厂商如联想、华为、荣耀旗下部分产品接入DeepSeek模型，用作端侧个人助手和汽车智能座舱。

迄今，DeepSeek依靠自身价值吸引来了全面庞大的朋友圈，囊括海内外云厂商、运营商、券商和国家级平台国家超算互联网平台。由于DeepSeek-R1是完全开源的模型，接入的服务商都成为了DS模型的受益方。这一方面极大抬高了DS的声量，也同时造成了更为频繁的卡顿现象，服务商和DS自身越来越受困于蜂拥而至的用户，竟都没有找到解决稳定使用问题之关键窍门。

考虑到DeepSeek V3与R1两个模型原版都高达6710亿参数，适合跑在云上，云厂商本身具备更充足的算力和推理能力，他们上线DeepSeek相关部署服务是为降低企业使用的门槛，其部署DeepSeek模型后对外提供DS模型的API，相比DS自己提供是的API，本被认为是可以提供比DS官方更好的使用体验。

但现实中，DeepSeek-R1模型自身运行的体验问题，在各家服务中都没有得到解决，外界认为服务商们并不缺卡，但实际上他们部署的R1，开发者们对反应体验不稳定的反馈，频度完全与R1相当，这更多在于能分配给R1进行推理的卡量也并不太多。

“R1热度保持在高位，服务商需要兼顾接入的其他模型，能提供给R1的卡很有限，R1的热度又高，谁家一上R1，又以相对较低的价格提供，就会被冲垮。”模型产品设计师，独立开发者歸藏对硅星人解释了原因。

模型部署优化是一个涵盖众多环节的宽泛领域，从训练完成到实际硬件部署，涉及多层面工作，但对于DeepSeek的卡顿事件来说，原因可能更为简单，比如太大的模型和上线之前的优化准备不足。

一个热门大模型上线之前，会遇到涉及技术、工程、业务等多方挑战，比如训练数据与生产环境数据的一致性，数据延迟与实时性影响模型推理效果，线上推理效率和资源占用过高，模型泛化能力不足，以及工程方面像服务稳定性、API与系统集成等方面。

很多当红大模型上线之前都高度重视做好推理优化，这是因为计算耗时和内存问题，前者是指推理时延太长，造成用户体验差，甚至不能满足延迟需求，也就是卡顿等现象，后者是指模型参数量多，耗费显存，甚至单张GPU卡放不下，也会导致卡顿。

温廷灿对硅星人解释了原因，他称服务商提供提R1服务遇到挑战，本质是DS模型结构特殊，模型太大+MOE架构，“优化需要时间，但是市场热度是有时间窗口的，所以都是先上再优化，而不是充分优化后上线。”

R1要想稳定运行，如今核心在于推理侧的储备和优化之能力。DeepSeek需要做的是，找到方式把推理的成本降下来，把卡的输出，单次输出token的数量降下来。

与此同时，卡顿也说明DS本身的算力储备很可能也没有SemiAnalysis所述庞大，幻方基金公司要用卡，DeepSeek训练团队也要用卡，能排出来给用户的卡一直不多。按照目前发展情形看，短期内DeepSeek未必有动力花钱租服务，继而免费提供给用户更好的体验，他们更可能等到第一波C端商业模式梳理清晰之后，再考虑服务租赁的议题，这也意味着，卡顿还会持续不短的时间。

他们大概需要两步动作：

1）做付费机制，限制免费用户模型用量；

2）找云服务厂商合作，用上别人的GPU资源。”开发者陈云飞给出的临时解法在业界颇有共识。

但目前来看，DeepSeek对自己这个“服务器繁忙”问题显得并不太着急。做为一家追逐AGI的公司，DeepSeek似乎不愿太着眼于这蜂拥而来的用户流量。可能用户们在未来不短时间里还是要习惯面对“服务器繁忙”的界面了。

----
来源：虎嗅网