# DeepSeek如何搅动AI产业？

从ChatGPT、Sora、Kimi、豆包，再到如今的DeepSeek，这些横空出世的大模型及其产品，为日新月异的AI大模型产业写下关键的注脚。

引发海内外科技巨头和媒体关注、全社会都在热议的DeepSeek将如何影响大模型产业的走向？在英伟达股价震荡，OpenAI、Meta产生危机感，以及A股“DeepSeek概念股”火热的背后存在着怎样的逻辑？

上海证券报记者采访阿里云、优刻得等业界、学界专家了解到，预计今年一季度，将会有更多中国头部公司发布对标DeepSeek的大模型。新一轮AI大模型应用热潮的兴起，为我国深入开展“人工智能+”行动带来新机遇。

硬核技术：软硬一体创新，效率全面提升

2024年12月26日，DeepSeek-V3首个版本上线并同步开源，性能比肩闭源模型GPT-4o以及Claude-3.5-Sonnet；2025年1月20日，DeepSeek-R1发布，性能对标OpenAI o1正式版。

一位头部科技公司专家对记者说，目前大模型可以分为基座大模型、推理模型、多模态模型、用于科研的模型四种。DeepSeek-V3和DeepSeek-R1分别在基座大模型和推理模型上追平了全球领先的大模型。

DeepSeek发布的论文显示，其模型在开发过程中采取了一系列软、硬件一体的优化和创新，在各个层面实现加速计算、提高硬件利用效率，最终实现了有效节省计算资源。

不过，上述专家也澄清，根据DeepSeek-V3论文得出的557.6万美元成本额是单次训练成本，前期的成本投入不能忽略，而且用来估算的英伟达H800的市场价也存在波动。“虽然没有外界认为的那么夸张，但DeepSeek的确将单次训练的成本降低了20%到40%。”这位专家说。

推理模型是OpenAI发布o1、o3模型开创的新范式。这类模型意味着不再是一次性输出，而是展示一个思考的过程。

复旦大学计算机科学技术学院教授张奇接受记者采访时说，对于如何训练出推理模型，OpenAI几乎没有对外公布任何信息。自o1模型发布以来，复现o1是产业界的重要工作。DeepSeek可以说是首个复现成功的模型，而且其采用的跳过监督微调，直接从强化和学习开始训练的思路是一个重要创新点。

“我国大模型产业经过两年左右的探索和发展，对大模型的训练有了更深刻的理解，而2024年OpenAI的脚步有所放慢。因此从GPT-4到o1的发展中，我国企业的追赶速度加快，某种程度上这种差距在缩小。”张奇说。

鲶鱼效应：降低应用门槛，重塑行业格局

DeepSeek公司成立于2023年7月，成立一年半来，已不止一次在大模型产业中激发了“鲶鱼效应”，对大模型价格、开源闭源路径选择、竞争格局等均产生了较大影响。

张奇认为，目前做大模型的公司分为三类，其中第一类是OpenAI、DeepSeek。这类公司由于种种因素拥有充裕的资金、算力等资源，首要目的是追求创新、保持领先。“如果DeepSeek坚持下来，很有可能开辟新的路线，成为引领者。”张奇说。

DeepSeek与OpenAI还存在着开源、闭源路线的差异。华泰证券研究认为，OpenAI原本凭借技术壁垒和闭源模式在AI领域占据优势，但DeepSeek的开源模式和低成本可能降低行业进入门槛，削弱其技术垄断地位。特别是对于依赖高额算力投入和专有模型训练的闭源公司而言，DeepSeek的低成本、高效率特性可能导致部分市场份额的流失，或迫使其调整商业模式。

业内认为，OpenAI面对当前情况可能采取两种方式应对竞争：一种是选择开源一部分，减少用户流失，加入与其他生态的竞争；另一种是推出更出色的模型，证明其领先性，从而维持其闭源收费的模式。

阿里云智能科技研究中心主任安琳对记者说：“开源和闭源路径，本就不意味着性能差异，而是商业策略的选择。不管哪种路径，更重要的是如何形成可持续的商业化闭环。大模型的能力的确在不断提升，但也面临着边际效益降低的瓶颈。只有将前期投入转化为商业化收入，继续赋能技术提升，这项技术的创新和应用才能持续下去。”

第二类是腾讯、阿里、字节跳动、Meta等互联网巨头。这些公司拥有充足的资源进行投入，同时其自有生态就有丰富的应用场景和需求。

虽然目前国内外科技公司尚未发布对标DeepSeek-R1的模型，但业内预计二三月份会有更多中国头部公司发布类似的模型。1月29日，阿里发布通义千问Qwen2.5-Max大模型。在多个基准测试中，Qwen2.5-Max比肩Claude-3.5-Sonnet，并几乎全面超越了GPT-4o、DeepSeek-V3及Llama-3.1-405B。

第三类是包括国内“大模型六小虎”（智谱、MiniMax、百川智能、月之暗面、阶跃星辰、零一万物）等在内的创业企业。这些公司依靠外部融资，目前已有较大的融资金额和较高的估值。面对DeepSeek这样一个异军突起的黑马，这些创业公司面临着较大的压力和变数。

近日，A股上市公司密集宣布了接入DeepSeek的消息，掀起了新一轮探索大模型应用的热潮。例如，网络安全公司奇安信将DeepSeek-R1引入到威胁研判、安全运营、渗透测试和漏洞管理等多场景，实现成本降低、性能提升。视觉中国完成了DeepSeek-R1的接入与本地化部署，实现了图片分析和理解上的“一图有万言”，以及搜索意图解析与匹配方面的“一图胜万言”。

“DeepSeek的开源模式和低成本，降低了应用门槛。我认为从应用的角度来说，DeepSeek-R1的出现，比o1推出的影响更大。”张奇说，全社会开始更加深刻地认识到AI的能力，有了推理能力的加持，大模型的幻觉大幅降低，用户体验也更好。

“当全社会都在谈论DeepSeek的时候，无疑会加速AI的普及。这对我国深入开展‘人工智能+’行动是巨大的机遇，AI在制造、医疗、教育、交通、农业等多个领域都有机会发展壮大。”安琳说。

云计算上市公司优刻得研发总监王晓慧告诉记者，自大模型问世以来，许多公司都尝试过业务和大模型的融合。在融合中不少公司发现，原以为无所不能的AI，实际上应用的准确率和精度还达不到业务要求。但DeepSeek出圈后，这些公司开始用DeepSeek进行新的尝试，完成相关分析、推理的业务。

对于算力来说，DeepSeek虽然通过创新路径削弱了大模型训练对高端GPU的依赖，但业内共识是，未来的算力需求将取决于大模型大规模应用的推理算力。近日，阿里云、腾讯云、优刻得等云计算厂商均上架了DeepSeek系列模型，提供了多种部署方式，进一步简化了模型开发流程。

---
来源：中国经济网