/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.values;

import docking.widgets.textfield.IntegerTextField;
import docking.widgets.values.AbstractValue;
import javax.swing.JComponent;

public class IntValue
extends AbstractValue<Integer> {
    private boolean displayAsHex;
    private IntegerTextField field;

    public IntValue(String name) {
        this(name, null, false);
    }

    public IntValue(String name, int defaultValue) {
        this(name, defaultValue, false);
    }

    public IntValue(String name, Integer defaultValue, boolean displayAsHex) {
        super(name, defaultValue);
        this.displayAsHex = displayAsHex;
    }

    @Override
    public JComponent getComponent() {
        if (this.field == null) {
            this.field = new IntegerTextField(20);
            this.field.setAllowsHexPrefix(false);
            this.field.setShowNumberMode(false);
            if (this.displayAsHex) {
                this.field.setHexMode();
                this.field.setShowNumberMode(true);
            }
        }
        return this.field.getComponent();
    }

    @Override
    protected void updateValueFromComponent() {
        String text = this.field.getText();
        if (this.getValue() == null && text.equals("")) {
            return;
        }
        this.setValue(this.field.getIntValue());
    }

    @Override
    protected void updateComponentFromValue() {
        Integer value = (Integer)this.getValue();
        if (value == null) {
            this.field.setText("");
            return;
        }
        this.field.setValue(value);
    }

    @Override
    public Integer fromString(String valueString) {
        return this.displayAsHex ? Integer.parseInt(valueString, 16) : Integer.parseInt(valueString, 10);
    }

    @Override
    public String toString(Integer v) {
        return this.displayAsHex ? Integer.toHexString(v) : v.toString();
    }
}

