/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsImpl;
import java.lang.ref.WeakReference;
import javax.swing.JTable;

public class GTableCellRenderingData {
    private final WeakReference<JTable> jTableRef;
    private int columnViewIndex;
    private int rowViewIndex;
    private Object value;
    private boolean isSelected;
    private boolean hasFocus;
    private final WeakReference<Settings> columnSettingsRef;
    private WeakReference<Object> rowObjectRef;

    public GTableCellRenderingData(JTable jTable, int column, Settings columnSettings) {
        this.jTableRef = new WeakReference<JTable>(jTable);
        this.columnViewIndex = column;
        this.columnSettingsRef = new WeakReference<Settings>(columnSettings);
        this.resetRowData();
    }

    public GTableCellRenderingData copyWithNewValue(Object newValue) {
        GTableCellRenderingData newData = new GTableCellRenderingData(this.getTable(), this.getColumnViewIndex(), this.getColumnSettings());
        newData.setRowData(this.getRowViewIndex(), this.getRowObject());
        newData.setCellData(newValue, this.columnViewIndex, this.isSelected(), this.hasFocus());
        return newData;
    }

    public void setRowData(int row, Object rowObject) {
        this.rowViewIndex = row;
        this.rowObjectRef = new WeakReference<Object>(rowObject);
    }

    public void setCellData(Object value, int column, boolean isSelected, boolean hasFocus) {
        this.value = value;
        this.columnViewIndex = column;
        this.isSelected = isSelected;
        this.hasFocus = hasFocus;
    }

    void resetRowData() {
        this.setRowData(this.rowViewIndex, null);
        this.setCellData(null, this.columnViewIndex, this.isSelected, this.hasFocus);
    }

    public JTable getTable() {
        return (JTable)this.jTableRef.get();
    }

    public int getColumnViewIndex() {
        return this.columnViewIndex;
    }

    public int getColumnModelIndex() {
        return this.getTable().convertColumnIndexToModel(this.columnViewIndex);
    }

    public Settings getColumnSettings() {
        Settings s = (Settings)this.columnSettingsRef.get();
        if (s == null) {
            s = SettingsImpl.NO_SETTINGS;
        }
        return s;
    }

    public int getRowViewIndex() {
        return this.rowViewIndex;
    }

    public int getRowModelIndex() {
        return this.getTable().convertRowIndexToModel(this.rowViewIndex);
    }

    public Object getValue() {
        return this.value;
    }

    public Object getRowObject() {
        return this.rowObjectRef.get();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + ":" + this.getTable().getModel().getClass().getSimpleName() + ":" + this.getColumnViewIndex() + ":" + String.valueOf(this.getColumnSettings()) + "]";
    }
}

