/*
 * Decompiled with CFR 0.152.
 */
package docking.theme.gui;

import docking.DialogComponentProvider;
import docking.widgets.button.BrowseButton;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.label.GLabel;
import generic.theme.GTheme;
import generic.theme.LafType;
import generic.theme.ThemeManager;
import generic.theme.ThemeWriter;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ExportThemeDialog
extends DialogComponentProvider {
    private JTextField nameField;
    private JTextField fileTextField;
    private GCheckBox includeDefaultsCheckbox;
    private boolean exportAsZip;
    private ThemeManager themeManager;

    public ExportThemeDialog(ThemeManager themeManager, boolean exportAsZip) {
        super("Export Theme");
        this.themeManager = themeManager;
        this.exportAsZip = exportAsZip;
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setRememberSize(false);
    }

    @Override
    protected void okCallback() {
        if (this.exportTheme()) {
            this.close();
        }
    }

    private boolean exportTheme() {
        String themeName = this.nameField.getText();
        GTheme activeTheme = this.themeManager.getActiveTheme();
        LafType laf = activeTheme.getLookAndFeelType();
        boolean useDarkDefaults = activeTheme.useDarkDefaults();
        File file = new File(this.fileTextField.getText());
        if (themeName.isBlank()) {
            this.setStatusText("Missing Theme Name", MessageType.ERROR, true);
            return false;
        }
        try {
            GTheme exportTheme = new GTheme(file, themeName, laf, useDarkDefaults);
            this.loadValues(exportTheme);
            ThemeWriter themeWriter = new ThemeWriter(exportTheme);
            themeWriter.writeTheme(file, this.exportAsZip);
            return true;
        }
        catch (IOException e) {
            Msg.error((Object)"Error Exporting Theme", (Object)"I/O Error encountered trying to export theme!", (Throwable)e);
            return false;
        }
    }

    private void loadValues(GTheme exportTheme) {
        if (this.includeDefaultsCheckbox.isSelected()) {
            exportTheme.load(this.themeManager.getCurrentValues());
        } else {
            exportTheme.load(this.themeManager.getNonDefaultValues());
        }
    }

    @Override
    protected void cancelCallback() {
        this.close();
    }

    private JComponent buildMainPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        panel.add(new GLabel("Theme Name:", 4));
        panel.add(this.buildNameField());
        panel.add(new GLabel("Output File:", 4));
        panel.add(this.buildFilePanel());
        panel.add(new GLabel("Include Defaults:", 4));
        panel.add(this.buildIncludeDefaultsCheckbox());
        panel.getAccessibleContext().setAccessibleName("Export Theme");
        return panel;
    }

    private Component buildNameField() {
        this.nameField = new JTextField(25);
        this.nameField.setText(this.themeManager.getActiveTheme().getName());
        this.nameField.getAccessibleContext().setAccessibleName("Name");
        return this.nameField;
    }

    private Component buildIncludeDefaultsCheckbox() {
        this.includeDefaultsCheckbox = new GCheckBox();
        this.includeDefaultsCheckbox.setSelected(true);
        this.includeDefaultsCheckbox.getAccessibleContext().setAccessibleName("Include Defaults");
        return this.includeDefaultsCheckbox;
    }

    private Component buildFilePanel() {
        File homeDir = new File(System.getProperty("user.home"));
        String name = this.themeManager.getActiveTheme().getName();
        String filename = name.replaceAll(" ", "_") + ".";
        filename = filename + (this.exportAsZip ? GTheme.ZIP_FILE_EXTENSION : GTheme.FILE_EXTENSION);
        File file = new File(homeDir, filename);
        this.fileTextField = new JTextField();
        this.fileTextField.setText(file.getAbsolutePath());
        this.fileTextField.setEditable(false);
        this.fileTextField.setFocusable(false);
        this.fileTextField.getAccessibleContext().setAccessibleName("File");
        BrowseButton folderButton = new BrowseButton();
        folderButton.addActionListener(e -> this.chooseFile());
        folderButton.getAccessibleContext().setAccessibleName("Folder");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.fileTextField, "Center");
        panel.add((Component)folderButton, "East");
        panel.getAccessibleContext().setAccessibleName("File");
        return panel;
    }

    private void chooseFile() {
        GhidraFileChooser chooser = new GhidraFileChooser(this.getComponent());
        chooser.setTitle("Choose Theme File");
        chooser.getComponent().getAccessibleContext().setAccessibleName("File Theme");
        chooser.setApproveButtonToolTipText("Select File");
        chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        chooser.setSelectedFileFilter(GhidraFileFilter.ALL);
        chooser.setSelectedFile(new File(this.fileTextField.getText()));
        File file = chooser.getSelectedFile();
        if (file != null) {
            this.fileTextField.setText(file.getAbsolutePath());
        }
        chooser.dispose();
    }

    public void setOutputFile(File outputFile) {
        this.fileTextField.setText(outputFile.getAbsolutePath());
    }
}

