/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.PowerPC_ElfRelocationHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;
import java.math.BigInteger;
import java.util.Map;

public class PowerPC_ElfRelocationContext
extends ElfRelocationContext<PowerPC_ElfRelocationHandler> {
    private Integer sdaBase;
    private Integer sda2Base;

    protected PowerPC_ElfRelocationContext(PowerPC_ElfRelocationHandler handler, ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        super((ElfRelocationHandler)handler, loadHelper, symbolMap);
    }

    Integer getSDABase() {
        if (this.sdaBase != null) {
            if (this.sdaBase == -1) {
                return null;
            }
            return this.sdaBase;
        }
        this.sdaBase = this.getBaseOffset("_SDA_BASE_", ".sdata", ".sbss");
        if (this.sdaBase == -1) {
            this.getLog().appendMsg("ERROR: failed to establish _SDA_BASE_");
            return null;
        }
        this.setRegisterContext("r13", BigInteger.valueOf(this.sdaBase.intValue()));
        return this.sdaBase;
    }

    Integer getSDA2Base() {
        if (this.sda2Base != null) {
            if (this.sda2Base == -1) {
                return null;
            }
            return this.sda2Base;
        }
        this.sda2Base = this.getBaseOffset("_SDA2_BASE_", ".sdata2", ".sbss2");
        if (this.sda2Base == -1) {
            this.getLog().appendMsg("ERROR: failed to establish _SDA2_BASE_");
            return null;
        }
        this.setRegisterContext("r2", BigInteger.valueOf(this.sda2Base.intValue()));
        return this.sda2Base;
    }

    private void setRegisterContext(String regName, BigInteger value) {
        Register reg = this.program.getRegister(regName);
        for (MemoryBlock block : this.program.getMemory().getBlocks()) {
            if (!block.isExecute()) continue;
            try {
                this.program.getProgramContext().setValue(reg, block.getStart(), block.getEnd(), value);
            }
            catch (ContextChangeException e) {
                throw new AssertException((Throwable)e);
            }
        }
    }

    private Integer getBaseOffset(String symbolName, String ... blockNames) {
        MessageLog log = this.getLog();
        Symbol baseSymbol = SymbolUtilities.getLabelOrFunctionSymbol((Program)this.program, (String)symbolName, msg -> log.appendMsg(msg));
        if (baseSymbol != null) {
            int baseOffset = (int)baseSymbol.getAddress().getOffset();
            String absString = "";
            if (baseSymbol.isPinned()) {
                absString = "absolute ";
            }
            log.appendMsg("Using " + absString + symbolName + " of 0x" + Integer.toHexString(baseOffset));
            return baseOffset;
        }
        Memory mem = this.program.getMemory();
        AddressSpace defaultSpace = this.program.getAddressFactory().getDefaultAddressSpace();
        AddressSet blockSet = new AddressSet();
        for (String blockName : blockNames) {
            MemoryBlock block = mem.getBlock(blockName);
            if (block == null) continue;
            if (!block.getStart().getAddressSpace().equals((Object)defaultSpace)) {
                log.appendMsg("ERROR: " + blockName + " not in default space");
                return -1;
            }
            blockSet.add(block.getStart(), block.getEnd());
        }
        if (blockSet.isEmpty()) {
            return -1;
        }
        Address baseAddr = blockSet.getMinAddress();
        long range = blockSet.getMaxAddress().subtract(baseAddr) + 1L;
        if (range > 32767L) {
            baseAddr = baseAddr.add(range / 2L & 0xFFFFFFFFFFFFFFF0L);
        }
        try {
            this.program.getSymbolTable().createLabel(baseAddr, symbolName, SourceType.ANALYSIS);
        }
        catch (InvalidInputException e) {
            throw new AssertException((Throwable)e);
        }
        int baseOffset = (int)baseAddr.getOffset();
        log.appendMsg("Defined " + symbolName + " of 0x" + Integer.toHexString(baseOffset));
        return baseOffset;
    }
}

