/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat;

public final class OatConstants {
    public static final String MAGIC = "oat\n";
    public static final String SYMBOL_OAT_BSS = "oatbss";
    public static final String SYMBOL_OAT_BSS_LASTWORD = "oatbsslastword";
    public static final String SYMBOL_OAT_BSS_METHODS = "oatbssmethods";
    public static final String SYMBOL_OAT_BSS_ROOTS = "oatbssroots";
    public static final String SYMBOL_OAT_DATA = "oatdata";
    public static final String SYMBOL_OAT_DATA_BIMGRELRO = "oatdatabimgrelro";
    public static final String SYMBOL_OAT_DATA_BIMGRELRO_LASTWORD = "oatdatabimgrelrolastword";
    public static final String SYMBOL_OAT_DEX = "oatdex";
    public static final String SYMBOL_OAT_DEX_LASTWORD = "oatdexlastword";
    public static final String SYMBOL_OAT_EXEC = "oatexec";
    public static final String SYMBOL_OAT_LASTWORD = "oatlastword";
    public static final String OAT_SECTION_NAME = ".rodata";
    public static final String DOT_OAT_PATCHES_SECTION_NAME = ".oat_patches";
    public static final String kApexVersionsKey = "apex-versions";
    public static final String kBootClassPathKey = "bootclasspath";
    public static final String kBootClassPathChecksumsKey = "bootclasspath-checksums";
    public static final String kClassPathKey = "classpath";
    public static final String kCompilationReasonKey = "compilation-reason";
    public static final String kCompilerFilter = "compiler-filter";
    public static final String kConcurrentCopying = "concurrent-copying";
    public static final String kDebuggableKey = "debuggable";
    public static final String kDex2OatCmdLineKey = "dex2oat-cmdline";
    public static final String kDex2OatHostKey = "dex2oat-host";
    public static final String kHasPatchInfoKey = "has-patch-info";
    public static final String kImageLocationKey = "image-location";
    public static final String kNativeDebuggableKey = "native-debuggable";
    public static final String kPicKey = "pic";
    public static final String kRequiresImage = "requires-image";
    public static final String kTrueValue = "true";
    public static final String kFalseValue = "false";
    public static final String OAT_VERSION_007 = "007";
    public static final String oat_version_008 = "008";
    public static final String OAT_VERSION_039 = "039";
    public static final String OAT_VERSION_045 = "045";
    public static final String OAT_VERSION_051 = "051";
    public static final String OAT_VERSION_064 = "064";
    public static final String OAT_VERSION_079 = "079";
    public static final String oat_version_083 = "083";
    public static final String OAT_VERSION_088 = "088";
    public static final String oat_version_114 = "114";
    public static final String OAT_VERSION_124 = "124";
    public static final String oat_version_125 = "125";
    public static final String OAT_VERSION_126 = "126";
    public static final String OAT_VERSION_131 = "131";
    public static final String oat_version_132 = "132";
    public static final String oat_version_135 = "135";
    public static final String OAT_VERSION_138 = "138";
    public static final String oat_version_139 = "139";
    public static final String oat_version_140 = "140";
    public static final String oat_version_141 = "141";
    public static final String oat_version_146 = "146";
    public static final String oat_version_147 = "147";
    public static final String oat_version_166 = "166";
    public static final String OAT_VERSION_170 = "170";
    public static final String OAT_VERSION_183 = "183";
    public static final String OAT_VERSION_195 = "195";
    public static final String oat_version_197 = "197";
    public static final String OAT_VERSION_199 = "199";
    public static final String OAT_VERSION_220 = "220";
    public static final String OAT_VERSION_223 = "223";
    public static final String OAT_VERSION_225 = "225";
    public static final String OAT_VERSION_227 = "227";
    public static final String[] SUPPORTED_VERSIONS = new String[]{"007", "039", "045", "051", "064", "079", "088", "124", "126", "131", "138", "170", "183", "195", "199", "220", "223", "225"};

    public static final boolean isSupportedVersion(String version) {
        for (String supportedVersion : SUPPORTED_VERSIONS) {
            if (!supportedVersion.equals(version)) continue;
            return true;
        }
        return false;
    }
}

