/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.art;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer32DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ArtField
implements StructConverter {
    private int declaring_class_;
    private int access_flags_;
    private int field_dex_idx_;
    private int offset_;

    public ArtField(BinaryReader reader) throws IOException {
        this.declaring_class_ = reader.readNextInt();
        this.access_flags_ = reader.readNextInt();
        this.field_dex_idx_ = reader.readNextInt();
        this.offset_ = reader.readNextInt();
    }

    public int getDeclaringClass() {
        return this.declaring_class_;
    }

    public int getAccessFlags() {
        return this.access_flags_;
    }

    public int getFieldDexIndex() {
        return this.field_dex_idx_;
    }

    public int getOffset() {
        return this.offset_;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType(ArtField.class.getSimpleName(), 0);
        structure.setCategoryPath(new CategoryPath("/art"));
        structure.add((DataType)new Pointer32DataType(), "declaring_class_", null);
        structure.add(DWORD, "access_flags_", null);
        structure.add(DWORD, "field_dex_idx_", null);
        structure.add(DWORD, "offset_", null);
        return structure;
    }
}

