/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.EventType;
import ghidra.program.model.address.Address;
import ghidra.program.util.ProgramEvent;

public class CodeUnitUserDataChangeRecord
extends DomainObjectChangeRecord {
    private String propertyName;
    private Address address;

    public CodeUnitUserDataChangeRecord(String propertyName, Address codeUnitAddr, Object oldValue, Object newValue) {
        super((EventType)ProgramEvent.CODE_UNIT_USER_DATA_CHANGED, oldValue, newValue);
        this.propertyName = propertyName;
        this.address = codeUnitAddr;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Address getAddress() {
        return this.address;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append(", property = " + this.propertyName);
        if (this.address != null) {
            builder.append(", address = ");
            builder.append(this.address);
        }
        return builder.toString();
    }
}

