/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.pcode.ByteIngest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class StringIngest
implements ByteIngest {
    private ByteArrayOutputStream outStream = null;
    private String description = null;
    private int maxBytes = 0;

    @Override
    public void open(int max, String desc) {
        this.maxBytes = max;
        this.description = desc;
        this.outStream = new ByteArrayOutputStream();
    }

    @Override
    public void ingestStreamToNextTerminator(InputStream inStream) throws IOException {
        int tok = inStream.read();
        while (tok > 0) {
            this.outStream.write(tok);
            if (this.outStream.size() >= this.maxBytes) {
                throw new IOException("Buffer size exceeded: " + this.description);
            }
            tok = inStream.read();
        }
    }

    @Override
    public void ingestStream(InputStream inStream) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public void ingestBytes(byte[] byteArray, int off, int sz) throws IOException {
        for (int i = 0; i < sz; ++i) {
            byte tok = byteArray[off + i];
            this.outStream.write(tok);
            if (this.outStream.size() < this.maxBytes) continue;
            throw new IOException("Buffer size exceeded: " + this.description);
        }
    }

    @Override
    public void endIngest() {
    }

    @Override
    public void clear() {
        this.outStream = null;
        this.description = null;
    }

    public String toString() {
        if (this.outStream == null) {
            return "<empty>";
        }
        return this.outStream.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.outStream == null || this.outStream.size() == 0;
    }
}

