/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.address.Address;
import ghidra.program.model.lang.InstructionBlock;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Instruction;
import ghidra.program.util.InstructionUtils;
import ghidra.util.Msg;

public class InstructionError {
    private InstructionBlock block;
    private InstructionErrorType type;
    private Address conflictAddress;
    private Address instructionAddress;
    private RegisterValue parseContext;
    private Address flowFromAddress;
    private String message;

    InstructionError(InstructionBlock block, InstructionErrorType type, Address instructionAddress, Address conflictAddress, Address flowFromAddress, String message) {
        this.block = block;
        this.type = type;
        this.instructionAddress = instructionAddress;
        this.conflictAddress = conflictAddress;
        this.flowFromAddress = flowFromAddress;
        this.message = message;
    }

    InstructionError(InstructionBlock block, RegisterValue contextValue, Address instructionAddress, Address flowFromAddress, String message) {
        this.block = block;
        this.type = InstructionErrorType.PARSE;
        this.parseContext = contextValue;
        this.instructionAddress = instructionAddress;
        this.flowFromAddress = flowFromAddress;
        this.message = message;
    }

    public InstructionBlock getInstructionBlock() {
        return this.block;
    }

    public InstructionErrorType getInstructionErrorType() {
        return this.type;
    }

    public boolean isInstructionConflict() {
        return this.type == InstructionErrorType.OFFCUT_INSTRUCTION || this.type == InstructionErrorType.INSTRUCTION_CONFLICT;
    }

    public boolean isOffcutError() {
        return this.type == InstructionErrorType.OFFCUT_INSTRUCTION;
    }

    public Address getInstructionAddress() {
        return this.instructionAddress;
    }

    public Address getConflictAddress() {
        return this.conflictAddress;
    }

    public RegisterValue getParseContextValue() {
        return this.parseContext;
    }

    public Address getFlowFromAddress() {
        return this.flowFromAddress;
    }

    public String getConflictMessage() {
        return this.message;
    }

    public static void dumpInstructionDifference(Instruction newInst, Instruction existingInstr) {
        StringBuilder buf = new StringBuilder("Instruction conflict details at " + String.valueOf(newInst.getAddress()));
        buf.append("\n  New Instruction: ");
        buf.append(InstructionError.getInstructionDetails(newInst));
        buf.append("\n  Existing Instruction: ");
        buf.append(InstructionError.getInstructionDetails(existingInstr));
        Msg.debug(InstructionError.class, (Object)buf.toString());
    }

    private static String getInstructionDetails(Instruction instr) {
        StringBuilder buf = new StringBuilder();
        buf.append(instr.toString());
        buf.append("\n");
        buf.append(InstructionUtils.getFormattedContextRegisterValueBreakout(instr, "     "));
        return buf.toString();
    }

    public static enum InstructionErrorType {
        DUPLICATE(true),
        INSTRUCTION_CONFLICT(true),
        DATA_CONFLICT(true),
        OFFCUT_INSTRUCTION(true),
        PARSE(false),
        MEMORY(false),
        FLOW_ALIGNMENT(false);

        public final boolean isConflict;

        private InstructionErrorType(boolean isConflict) {
            this.isConflict = isConflict;
        }
    }
}

