/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import java.util.HashSet;
import java.util.Set;

public class BitGroup {
    private Set<Long> values = new HashSet<Long>();
    private long mask;

    BitGroup(long value) {
        this.values.add(value);
        this.mask = value;
    }

    public boolean intersects(BitGroup bitGroup) {
        return (this.mask & bitGroup.mask) != 0L;
    }

    public void merge(BitGroup bitGroup) {
        this.values.addAll(bitGroup.values);
        this.mask |= bitGroup.mask;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("BitGroup - Mask: ");
        buf.append(Long.toHexString(this.mask));
        buf.append(" values: ");
        for (Long value : this.values) {
            buf.append(value);
            buf.append(",");
        }
        return buf.toString();
    }

    public long getMask() {
        return this.mask;
    }

    public Set<Long> getValues() {
        return this.values;
    }
}

