/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolutionFactory;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class AbstractAssemblyResolution
implements AssemblyResolution {
    protected final AbstractAssemblyResolutionFactory<?, ?> factory;
    protected final String description;
    protected final List<AssemblyResolution> children;
    protected final AssemblyResolution right;
    private boolean hashed = false;
    private int hash;

    protected AbstractAssemblyResolution(AbstractAssemblyResolutionFactory<?, ?> factory, String description, List<? extends AssemblyResolution> children, AssemblyResolution right) {
        this.factory = factory;
        this.description = description;
        this.children = children == null ? List.of() : Collections.unmodifiableList(children);
        this.right = right;
    }

    public int hashCode() {
        if (!this.hashed) {
            this.hash = this.computeHash();
            this.hashed = true;
        }
        return this.hash;
    }

    protected abstract int computeHash();

    protected List<AssemblyResolution> getAllRight() {
        ArrayList<AssemblyResolution> result = new ArrayList<AssemblyResolution>();
        this.collectAllRight(result);
        return result;
    }

    @Override
    public void collectAllRight(Collection<AssemblyResolution> into) {
        into.add(this);
        if (this.right == null) {
            return;
        }
        this.right.collectAllRight(into);
    }

    protected String childrenToString(String indent) {
        StringBuilder sb = new StringBuilder();
        for (AssemblyResolution child : this.children) {
            sb.append(child.toString(indent) + "\n");
        }
        return sb.substring(0, sb.length() - 1);
    }

    @Override
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append(this.lineToString());
        if (this.hasChildren()) {
            sb.append(":\n");
            String newIndent = indent + "  ";
            sb.append(this.childrenToString(newIndent));
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    @Override
    public int compareTo(AssemblyResolution that) {
        return this.toString().compareTo(that.toString());
    }

    @Override
    public boolean hasChildren() {
        if (this.children == null) {
            return false;
        }
        return this.children.size() != 0;
    }

    @Override
    public abstract AssemblyResolution shift(int var1);

    public AssemblyResolution withoutRight() {
        return this.withRight(null);
    }

    public abstract AssemblyResolution withRight(AssemblyResolution var1);

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<AssemblyResolution> getChildren() {
        return this.children;
    }

    @Override
    public AssemblyResolution getRight() {
        return this.right;
    }
}

