/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.IntBinOpGen;
import ghidra.pcode.emu.jit.gen.op.IntSCarryOpGen;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.op.JitIntSBorrowOp;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;

public enum IntSBorrowOpGen implements IntBinOpGen<JitIntSBorrowOp>
{
    GEN;


    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public JitType afterLeft(JitCodeGenerator gen, JitIntSBorrowOp op, JitType lType, JitType rType, MethodVisitor rv) {
        return TypeConversions.forceUniform(gen, lType, rType, TypeConversions.Ext.SIGN, rv);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JitType generateBinOpRunCode(JitCodeGenerator gen, JitIntSBorrowOp op, JitControlFlowModel.JitBlock block, JitType lType, JitType rType, MethodVisitor rv) {
        JitType jitType = rType = TypeConversions.forceUniform(gen, rType, lType, TypeConversions.Ext.SIGN, rv);
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0: {
                int size;
                JitType.IntJitType intJitType = (JitType.IntJitType)jitType2;
                try {
                    int n2;
                    size = n2 = intJitType.size();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, "sBorrowIntRaw", GenConsts.MDESC_JIT_COMPILED_PASSAGE__S_CARRY_INT_RAW, true);
                rv.visitLdcInsn((Object)(size * 8 - 1));
                rv.visitInsn(122);
                rv.visitLdcInsn((Object)1);
                rv.visitInsn(126);
                return JitType.IntJitType.I1;
            }
            case 1: {
                int size;
                JitType.LongJitType longJitType = (JitType.LongJitType)jitType2;
                {
                    int n3;
                    size = n3 = longJitType.size();
                }
                rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, "sBorrowLongRaw", GenConsts.MDESC_JIT_COMPILED_PASSAGE__S_CARRY_LONG_RAW, true);
                rv.visitLdcInsn((Object)(size * 8 - 1));
                rv.visitInsn(123);
                rv.visitInsn(136);
                rv.visitLdcInsn((Object)1);
                rv.visitInsn(126);
                return JitType.IntJitType.I1;
            }
            case 2: {
                JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                return IntSCarryOpGen.generateMpIntSCarry(gen, t, "sBorrowMpInt", rv);
            }
        }
        throw new AssertionError();
    }
}

