/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.transform;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.SqlUtils;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.transform.ISingleValueColumnTransform;
import org.jumpmind.symmetric.io.data.transform.IgnoreColumnException;
import org.jumpmind.symmetric.io.data.transform.IgnoreRowException;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.data.transform.TransformedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdditiveColumnTransform
implements ISingleValueColumnTransform,
IBuiltInExtensionPoint {
    private static final Logger log = LoggerFactory.getLogger(AdditiveColumnTransform.class);
    public static final String NAME = "additive";

    public String getName() {
        return NAME;
    }

    @Override
    public boolean isExtractColumnTransform() {
        return false;
    }

    @Override
    public boolean isLoadColumnTransform() {
        return true;
    }

    public String getFullyQualifiedTableName(IDatabasePlatform platform, String schema, String catalog, String tableName) {
        String quote = platform.getDdlBuilder().isDelimitedIdentifierModeOn() ? platform.getDatabaseInfo().getDelimiterToken() : "";
        tableName = quote + (String)tableName + quote;
        if (!StringUtils.isBlank((CharSequence)schema)) {
            tableName = schema + "." + (String)tableName;
        }
        if (!StringUtils.isBlank((CharSequence)catalog)) {
            tableName = catalog + "." + (String)tableName;
        }
        return tableName;
    }

    @Override
    public String transform(IDatabasePlatform platform, DataContext context, TransformColumn column, TransformedData data, Map<String, String> sourceValues, String newValue, String oldValue) throws IgnoreColumnException, IgnoreRowException {
        ISqlTransaction transaction;
        Table table;
        BigDecimal multiplier = new BigDecimal(1.0);
        if (StringUtils.isNotBlank((CharSequence)column.getTransformExpression())) {
            multiplier = new BigDecimal(column.getTransformExpression());
        }
        if ((table = platform.getTableFromCache(data.getCatalogName(), data.getSchemaName(), data.getTableName(), false)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("Could not find the target table '{}'", (Object)data.getFullyQualifiedTableName());
            }
            throw new IgnoreColumnException();
        }
        if (table.getColumnWithName(column.getTargetColumnName()) == null) {
            if (log.isDebugEnabled()) {
                log.debug("Could not find the target column '{}'", (Object)column.getTargetColumnName());
            }
            throw new IgnoreColumnException();
        }
        if (log.isDebugEnabled()) {
            log.debug("Old, new, transform expression as received: " + oldValue + ", " + newValue + ", " + column.getTransformExpression());
        }
        if (!StringUtils.isNotBlank((CharSequence)newValue) || data.getSourceDmlType() == DataEventType.DELETE) {
            newValue = "0";
        }
        if (!StringUtils.isNotBlank((CharSequence)oldValue)) {
            oldValue = "0";
        }
        BigDecimal delta = new BigDecimal(newValue);
        delta = delta.subtract(new BigDecimal(oldValue));
        delta = delta.multiply(multiplier);
        newValue = delta.toString();
        String quote = platform.getDdlBuilder().isDelimitedIdentifierModeOn() ? platform.getDatabaseInfo().getDelimiterToken() : "";
        StringBuilder sql = new StringBuilder(String.format("update %s set %s=%s+(%s) where ", this.getFullyQualifiedTableName(platform, SqlUtils.sanitizeIdentifier((String)data.getSchemaName()), SqlUtils.sanitizeIdentifier((String)data.getCatalogName()), SqlUtils.sanitizeIdentifier((String)data.getTableName())), quote + SqlUtils.sanitizeIdentifier((String)column.getTargetColumnName()) + quote, quote + SqlUtils.sanitizeIdentifier((String)column.getTargetColumnName()) + quote, newValue));
        String[] keyNames = data.getKeyNames();
        ArrayList<Column> columns = new ArrayList<Column>();
        ArrayList<String> keyValuesList = new ArrayList<String>();
        boolean addedFirstKey = false;
        for (int i = 0; i < keyNames.length; ++i) {
            Column targetCol = table.getColumnWithName(keyNames[i]);
            if (targetCol == null) continue;
            columns.add(targetCol);
            String value = sourceValues.get(keyNames[i]);
            if (value != null) {
                keyValuesList.add(value);
            }
            if (addedFirstKey) {
                sql.append("and ");
            } else {
                addedFirstKey = true;
            }
            sql.append(quote);
            sql.append(SqlUtils.sanitizeIdentifier((String)keyNames[i]));
            sql.append(quote);
            if (value == null) {
                sql.append("is null ");
                continue;
            }
            sql.append("=? ");
        }
        if (log.isDebugEnabled()) {
            log.debug("SQL: " + String.valueOf(sql));
        }
        if (0 < (transaction = context.findTransaction()).prepareAndExecute(sql.toString(), platform.getObjectValues(context.getBatch().getBinaryEncoding(), keyValuesList.toArray(new String[keyValuesList.size()]), columns.toArray(new Column[columns.size()])))) {
            throw new IgnoreColumnException();
        }
        return newValue;
    }
}

