/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.io.data.DataProcessor;
import org.jumpmind.symmetric.io.data.reader.CsvDquoteDataReader;
import org.jumpmind.symmetric.io.data.reader.CsvTableDataReader;
import org.jumpmind.symmetric.io.data.reader.SqlDataReader;
import org.jumpmind.symmetric.io.data.reader.SymXmlDataReader;
import org.jumpmind.symmetric.io.data.reader.XmlDataReader;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterErrorIgnorer;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.io.data.writer.DefaultDatabaseWriter;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;

public class DbImport {
    private Format format = Format.SQL;
    private String catalog;
    private String schema;
    private long commitRate = 10000L;
    private int interval = 5;
    private boolean useVariableDates = false;
    private boolean forceImport = false;
    private boolean replaceRows = false;
    private boolean ignoreCollisions = false;
    private boolean alterCaseToMatchDatabaseDefaultCase = false;
    private boolean alterTables = false;
    private boolean dropIfExists = false;
    private boolean ignoreMissingTables = true;
    private boolean createIndexConvertUniqueToNonuniqueWhenColumnsNotRequired = true;
    protected IDatabasePlatform symmetricPlatform;
    protected List<IDatabaseWriterFilter> databaseWriterFilters = new ArrayList<IDatabaseWriterFilter>();

    public DbImport() {
    }

    public DbImport(IDatabasePlatform symmetricPlatform) {
        this();
        this.symmetricPlatform = symmetricPlatform;
    }

    public void importTables(String importData, String tableName) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(importData.getBytes(Charset.defaultCharset()));
            this.importTables(in, tableName);
            in.close();
        }
        catch (IOException e) {
            throw new IoException("Failed to read '" + importData + "' for table '" + tableName + "'", (Throwable)e);
        }
    }

    public void importTables(String importData) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(importData.getBytes(Charset.defaultCharset()));
            this.importTables(in);
            in.close();
        }
        catch (IOException e) {
            throw new IoException("Failed to read '" + importData + "'", (Throwable)e);
        }
    }

    public void importTables(InputStream in) {
        this.importTables(in, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importTables(InputStream in, String tableName) {
        if (this.format == Format.SQL) {
            this.importTablesFromSql(in);
            return;
        } else if (this.format == Format.CSV) {
            if (!StringUtils.isNotBlank((CharSequence)tableName)) throw new RuntimeException("Table name argument is required when importing CSV.");
            this.importTablesFromCsv(in, tableName);
            return;
        } else if (this.format == Format.CSV_DQUOTE) {
            if (!StringUtils.isNotBlank((CharSequence)tableName)) throw new RuntimeException("Table name argument is required when importing CSV.");
            this.importTablesFromCsvDquote(in, tableName);
            return;
        } else if (this.format == Format.XML) {
            this.importTablesFromXml(in);
            return;
        } else {
            if (this.format != Format.SYM_XML) return;
            this.importTablesFromSymXml(in);
        }
    }

    protected Conflict buildConflictSettings() {
        Conflict conflict = new Conflict();
        conflict.setDetectType(Conflict.DetectConflict.USE_PK_DATA);
        if (this.replaceRows) {
            conflict.setResolveType(Conflict.ResolveConflict.FALLBACK);
        } else if (this.forceImport || this.ignoreCollisions) {
            conflict.setResolveType(Conflict.ResolveConflict.IGNORE);
        } else {
            conflict.setResolveType(Conflict.ResolveConflict.MANUAL);
        }
        return conflict;
    }

    protected DatabaseWriterSettings buildDatabaseWriterSettings() {
        DatabaseWriterSettings settings = new DatabaseWriterSettings();
        settings.setMaxRowsBeforeCommit(this.commitRate);
        settings.setCommitSleepInterval(this.interval);
        settings.setDefaultConflictSetting(this.buildConflictSettings());
        settings.setUsePrimaryKeysFromSource(false);
        settings.setAlterTable(this.alterTables);
        settings.setCreateTableDropFirst(this.dropIfExists);
        settings.setCreateTableFailOnError(!this.forceImport);
        settings.setDatabaseWriterFilters(this.databaseWriterFilters);
        settings.setIgnoreMissingTables(this.ignoreMissingTables);
        settings.setCreateTableAlterCaseToMatchDatabaseDefault(this.alterCaseToMatchDatabaseDefaultCase);
        settings.setCreateIndexConvertUniqueToNonuniqueWhenColumnsNotRequired(this.createIndexConvertUniqueToNonuniqueWhenColumnsNotRequired);
        if (this.forceImport) {
            settings.addErrorHandler(new DatabaseWriterErrorIgnorer());
        }
        return settings;
    }

    protected void importTablesFromCsv(InputStream in, String tableName) {
        DefaultDatabaseWriter writer = new DefaultDatabaseWriter(this.symmetricPlatform, this.buildDatabaseWriterSettings());
        Table table = writer.getPlatform(tableName).readTableFromDatabase(this.catalog, this.schema, tableName);
        if (table == null) {
            throw new RuntimeException("Unable to find table '" + tableName + "' in the database.");
        }
        CsvTableDataReader reader = new CsvTableDataReader(BinaryEncoding.HEX, table.getCatalog(), table.getSchema(), table.getName(), in);
        DataProcessor dataProcessor = new DataProcessor(reader, writer, "import");
        dataProcessor.process();
    }

    protected void importTablesFromCsvDquote(InputStream in, String tableName) {
        DefaultDatabaseWriter writer = new DefaultDatabaseWriter(this.symmetricPlatform, this.buildDatabaseWriterSettings());
        Table table = writer.getPlatform(tableName).readTableFromDatabase(this.catalog, this.schema, tableName);
        if (table == null) {
            throw new RuntimeException("Unable to find table '" + tableName + "' in the database.");
        }
        CsvDquoteDataReader reader = new CsvDquoteDataReader(BinaryEncoding.HEX, table.getCatalog(), table.getSchema(), table.getName(), in);
        DataProcessor dataProcessor = new DataProcessor(reader, writer, "import");
        dataProcessor.process();
    }

    protected void importTablesFromXml(InputStream in) {
        XmlDataReader reader = new XmlDataReader(in);
        reader.setCatalog(this.catalog);
        reader.setSchema(this.schema);
        DefaultDatabaseWriter writer = new DefaultDatabaseWriter(this.symmetricPlatform, this.buildDatabaseWriterSettings());
        DataProcessor dataProcessor = new DataProcessor(reader, writer, "import");
        dataProcessor.process();
    }

    protected void importTablesFromSymXml(InputStream in) {
        SymXmlDataReader reader = new SymXmlDataReader(in);
        DefaultDatabaseWriter writer = new DefaultDatabaseWriter(this.symmetricPlatform, this.buildDatabaseWriterSettings());
        DataProcessor dataProcessor = new DataProcessor(reader, writer, "import");
        dataProcessor.process();
    }

    protected void importTablesFromSql(InputStream in) {
        SqlDataReader reader = new SqlDataReader(in);
        DefaultDatabaseWriter writer = new DefaultDatabaseWriter(this.symmetricPlatform, this.buildDatabaseWriterSettings());
        DataProcessor dataProcessor = new DataProcessor(reader, writer, "import");
        dataProcessor.process();
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setIgnoreMissingTables(boolean ignoreMissingTables) {
        this.ignoreMissingTables = ignoreMissingTables;
    }

    public boolean isIgnoreMissingTables() {
        return this.ignoreMissingTables;
    }

    public void setCreateIndexConvertUniqueToNonuniqueWhenColumnsNotRequired(boolean createIndexConvertUniqueToNonuniqueWhenColumnsNotRequired) {
        this.createIndexConvertUniqueToNonuniqueWhenColumnsNotRequired = createIndexConvertUniqueToNonuniqueWhenColumnsNotRequired;
    }

    public boolean isCreateIndexConvertUniqueToNonuniqueWhenColumnsNotRequired() {
        return this.createIndexConvertUniqueToNonuniqueWhenColumnsNotRequired;
    }

    public boolean isUseVariableDates() {
        return this.useVariableDates;
    }

    public void setUseVariableForDates(boolean useVariableDates) {
        this.useVariableDates = useVariableDates;
    }

    public void setAlterCaseToMatchDatabaseDefaultCase(boolean alterCaseToMatchDatabaseDefaultCase) {
        this.alterCaseToMatchDatabaseDefaultCase = alterCaseToMatchDatabaseDefaultCase;
    }

    public boolean isAlterCaseToMatchDatabaseDefaultCase() {
        return this.alterCaseToMatchDatabaseDefaultCase;
    }

    public void setCommitRate(long commitRate) {
        this.commitRate = commitRate;
    }

    public long getCommitRate() {
        return this.commitRate;
    }

    public void setForceImport(boolean forceImport) {
        this.forceImport = forceImport;
    }

    public boolean isForceImport() {
        return this.forceImport;
    }

    public void setIgnoreCollisions(boolean ignoreConflicts) {
        this.ignoreCollisions = ignoreConflicts;
    }

    public boolean isIgnoreCollisions() {
        return this.ignoreCollisions;
    }

    public void setReplaceRows(boolean replaceRows) {
        this.replaceRows = replaceRows;
    }

    public boolean isReplaceRows() {
        return this.replaceRows;
    }

    public void setAlterTables(boolean alterTables) {
        this.alterTables = alterTables;
    }

    public boolean isAlterTables() {
        return this.alterTables;
    }

    public void setDropIfExists(boolean dropIfExists) {
        this.dropIfExists = dropIfExists;
    }

    public boolean isDropIfExists() {
        return this.dropIfExists;
    }

    public void addDatabaseWriterFilter(IDatabaseWriterFilter filter) {
        this.databaseWriterFilters.add(filter);
    }

    public void removeDatabaseWriterFilter(IDatabaseWriterFilter filter) {
        this.databaseWriterFilters.remove(filter);
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public static enum Format {
        SQL,
        CSV,
        XML,
        SYM_XML,
        CSV_DQUOTE;

    }
}

