/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.csv.CsvReader;
import org.jumpmind.symmetric.csv.CsvWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvUtils {
    private static final Logger log = LoggerFactory.getLogger(CsvUtils.class);
    public static final String DELIMITER = ", ";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static CsvReader getCsvReader(Reader reader) {
        CsvReader csvReader = new CsvReader(reader);
        csvReader.setEscapeMode(2);
        csvReader.setSafetySwitch(false);
        csvReader.setCaptureRawRecord(false);
        return csvReader;
    }

    public static CsvReader getCsvReaderDquote(Reader reader) {
        CsvReader csvReader = new CsvReader(reader);
        csvReader.setEscapeMode(1);
        csvReader.setSafetySwitch(false);
        csvReader.setCaptureRawRecord(false);
        return csvReader;
    }

    public static String[] tokenizeCsvData(String csvData) {
        String[] tokens = null;
        if (csvData != null) {
            try (StringReader sr = new StringReader(csvData);
                 CsvReader csvReader = CsvUtils.getCsvReader(sr);){
                if (csvReader.readRecord()) {
                    tokens = csvReader.getValues();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return tokens;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String escapeCsvData(String data) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            String string;
            try (CsvWriter writer = new CsvWriter((Writer)new OutputStreamWriter(out), ',');){
                writer.setEscapeMode(2);
                writer.write(data);
                writer.flush();
                string = out.toString();
            }
            return string;
        }
        catch (IOException e) {
            return data;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String escapeAndQuoteCsvData(String data) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            String string;
            try (CsvWriter writer = new CsvWriter((Writer)new OutputStreamWriter(out), ',');){
                writer.setEscapeMode(2);
                writer.setTextQualifier('\"');
                writer.setUseTextQualifier(true);
                writer.setForceQualifier(false);
                writer.write(data, true);
                writer.flush();
                string = out.toString();
            }
            return string;
        }
        catch (IOException e) {
            return data;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String escapeCsvData(String[] data) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            String string;
            try (CsvWriter writer = new CsvWriter((Writer)new OutputStreamWriter(out), ',');){
                writer.setEscapeMode(2);
                writer.setTextQualifier('\"');
                writer.setUseTextQualifier(true);
                writer.setForceQualifier(true);
                for (String s : data) {
                    writer.write(s, true);
                }
                writer.flush();
                string = out.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new IoException((Exception)e);
        }
    }

    public static String escapeCsvData(String[] data, char recordDelimiter, char textQualifier) {
        return CsvUtils.escapeCsvData(data, recordDelimiter, textQualifier, 2);
    }

    public static String escapeCsvData(String[] data, char recordDelimiter, char textQualifier, int escapeMode) {
        return CsvUtils.escapeCsvData(data, recordDelimiter, textQualifier, escapeMode, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String escapeCsvData(String[] data, char recordDelimiter, char textQualifier, int escapeMode, String nullString) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            String string;
            try (CsvWriter writer = new CsvWriter((Writer)new OutputStreamWriter(out), ',');){
                writer.setEscapeMode(escapeMode);
                if (recordDelimiter != '\u0000') {
                    writer.setRecordDelimiter(recordDelimiter);
                }
                if (textQualifier != '\u0000') {
                    writer.setTextQualifier(textQualifier);
                    writer.setUseTextQualifier(true);
                    writer.setForceQualifier(true);
                }
                if (nullString != null) {
                    writer.setNullString(nullString);
                }
                writer.writeRecord(data, true);
                writer.flush();
                string = out.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new IoException((Exception)e);
        }
    }

    public static int write(Writer writer, String ... data) {
        try {
            StringBuilder buffer = new StringBuilder();
            for (String string : data) {
                buffer.append(string);
            }
            writer.write(buffer.toString());
            if (log.isDebugEnabled()) {
                log.debug(buffer.toString());
            }
            return buffer.length();
        }
        catch (IOException ex) {
            throw new IoException((Exception)ex);
        }
    }

    public static void writeSql(String sql, Writer writer) {
        CsvUtils.write(writer, "sql", DELIMITER, sql);
        CsvUtils.writeLineFeed(writer);
    }

    public static void writeBsh(String script, Writer writer) {
        CsvUtils.write(writer, "bsh", DELIMITER, script);
        CsvUtils.writeLineFeed(writer);
    }

    public static void writeLineFeed(Writer writer) {
        try {
            writer.write(LINE_SEPARATOR);
        }
        catch (IOException ex) {
            throw new IoException((Exception)ex);
        }
    }
}

