/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class JarBuilder {
    private File baseDir;
    private File[] sourceFiles;
    private File outputFile;
    private String version;

    public JarBuilder(File baseDir, File outputFile, File[] sourceFiles, String version) {
        this.sourceFiles = sourceFiles;
        this.outputFile = outputFile;
        this.baseDir = baseDir;
        this.version = version;
    }

    public void build() throws IOException {
        this.outputFile.delete();
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, this.version);
        if (this.outputFile.getParentFile() != null) {
            this.outputFile.getParentFile().mkdirs();
        }
        JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(this.outputFile), manifest);
        for (File file : this.sourceFiles) {
            this.add(file, target);
        }
        target.close();
    }

    private String massageJarEntryName(File source) {
        String name = source.getPath();
        if (this.baseDir != null && name.startsWith(this.baseDir.getPath())) {
            name = name.length() > this.baseDir.getPath().length() ? name.substring(this.baseDir.getPath().length() + 1) : "";
        }
        if ((name = name.replace("\\", "/")).equals("META-INF/MANIFEST.MF")) {
            name = "";
        }
        return name;
    }

    private void add(File source, JarOutputStream target) throws IOException {
        block10: {
            block9: {
                File[] files;
                if (!source.isDirectory()) break block9;
                Object name = this.massageJarEntryName(source);
                if (((String)name).trim().length() != 0) {
                    if (!((String)name).endsWith("/")) {
                        name = (String)name + "/";
                    }
                    JarEntry entry = new JarEntry((String)name);
                    entry.setTime(source.lastModified());
                    target.putNextEntry(entry);
                    target.closeEntry();
                }
                if ((files = source.listFiles()) == null) break block10;
                for (File nestedFile : files) {
                    this.add(nestedFile, target);
                }
                break block10;
            }
            JarEntry entry = new JarEntry(this.massageJarEntryName(source));
            entry.setTime(source.lastModified());
            target.putNextEntry(entry);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));){
                int count;
                byte[] buffer = new byte[1024];
                while ((count = in.read(buffer)) != -1) {
                    target.write(buffer, 0, count);
                }
                target.closeEntry();
            }
        }
    }
}

