/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.properties;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.exception.IoException;
import org.jumpmind.properties.TypedProperties;

public class EnvironmentSpecificProperties
extends TypedProperties {
    private static final long serialVersionUID = 1L;
    protected Set<String> propertiesForEnvironment = new HashSet<String>();
    protected String systemPropertyName;
    protected Properties original;

    public EnvironmentSpecificProperties(URL fileUrl, String systemPropertyName, String ... propertiesForEnv) {
        this(new URL[]{fileUrl}, systemPropertyName, propertiesForEnv);
    }

    public EnvironmentSpecificProperties(URL[] fileUrls, String systemPropertyName, String ... propertiesForEnv) {
        this.systemPropertyName = systemPropertyName;
        if (propertiesForEnv != null) {
            for (String property : propertiesForEnv) {
                if (property == null) continue;
                this.propertiesForEnvironment.add(property);
            }
        }
        try {
            this.original = new Properties();
            for (URL fileUrl : fileUrls) {
                this.original.load(fileUrl.openStream());
            }
            this.original.putAll((Map<?, ?>)System.getProperties());
            this.activate();
        }
        catch (IOException e) {
            throw new IoException(e);
        }
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public synchronized void load(Reader reader) throws IOException {
        throw new NotImplementedException();
    }

    protected final void activate() {
        this.clear();
        if (this.original != null) {
            HashSet<String> properties = new HashSet<String>(this.propertiesForEnvironment);
            if (StringUtils.isNotBlank((CharSequence)this.systemPropertyName)) {
                String additionalActivationKeys = System.getProperty(this.systemPropertyName);
                if (StringUtils.isBlank((CharSequence)additionalActivationKeys)) {
                    additionalActivationKeys = this.original.getProperty(this.systemPropertyName);
                }
                if (StringUtils.isNotBlank((CharSequence)additionalActivationKeys)) {
                    String[] tokens;
                    for (String token : tokens = additionalActivationKeys.split(",")) {
                        properties.add(token);
                    }
                }
            }
            Set<Object> keys = this.original.keySet();
            for (Object originalKey : keys) {
                String keyName = originalKey.toString();
                boolean foundMatch = true;
                while (foundMatch) {
                    foundMatch = false;
                    for (String property : properties) {
                        if (!keyName.startsWith(property + ".")) continue;
                        keyName = keyName.substring(property.length() + 1, keyName.length());
                        foundMatch = true;
                    }
                }
                this.setProperty(keyName, this.original.getProperty(originalKey.toString()));
            }
        }
    }

    protected Set<String> getPropertyKeysThatBeginWith(String prefix) {
        HashSet<String> set = new HashSet<String>();
        Set<Object> keys = this.keySet();
        for (Object key : keys) {
            if (!key.toString().startsWith(prefix)) continue;
            set.add(key.toString());
        }
        return set;
    }
}

