/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.jumpmind.driver.InterceptResult;
import org.jumpmind.driver.WrapperInterceptor;
import org.jumpmind.properties.TypedProperties;

public class PreparedStatementWrapper
implements PreparedStatement {
    private WrapperInterceptor interceptor;
    private PreparedStatement wrapped;
    private String statement;
    private TypedProperties engineProperties;

    public PreparedStatementWrapper(PreparedStatement wrapped, String statement, TypedProperties engineProperties) {
        this.wrapped = wrapped;
        this.interceptor = WrapperInterceptor.createInterceptor(this, engineProperties);
        this.statement = statement;
    }

    @Override
    public void setBoolean(int arg1, boolean arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setBoolean", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setBoolean(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setBoolean", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setByte(int arg1, byte arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setByte", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setByte(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setByte", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setShort(int arg1, short arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setShort", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setShort(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setShort", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setInt(int arg1, int arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setInt", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setInt(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setInt", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setLong(int arg1, long arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setLong", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setLong(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setLong", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setFloat(int arg1, float arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setFloat", arg1, Float.valueOf(arg2));
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setFloat(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setFloat", null, startTime, endTime, arg1, Float.valueOf(arg2));
    }

    @Override
    public void setDouble(int arg1, double arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setDouble", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setDouble(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setDouble", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setTimestamp(int arg1, Timestamp arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setTimestamp", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setTimestamp(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setTimestamp", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setTimestamp(int arg1, Timestamp arg2, Calendar arg3) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setTimestamp", arg1, arg2, arg3);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setTimestamp(arg1, arg2, arg3);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setTimestamp", null, startTime, endTime, arg1, arg2, arg3);
    }

    @Override
    public void setURL(int arg1, URL arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setURL", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setURL(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setURL", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setTime(int arg1, Time arg2, Calendar arg3) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setTime", arg1, arg2, arg3);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setTime(arg1, arg2, arg3);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setTime", null, startTime, endTime, arg1, arg2, arg3);
    }

    @Override
    public void setTime(int arg1, Time arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setTime", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setTime(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setTime", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public boolean execute() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("execute", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.execute();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("execute", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("getMetaData", new Object[0]);
        if (preResult.isIntercepted()) {
            return (ResultSetMetaData)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        ResultSetMetaData value = this.wrapped.getMetaData();
        InterceptResult postResult = this.interceptor.postExecute("getMetaData", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (ResultSetMetaData)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("executeQuery", new Object[0]);
        if (preResult.isIntercepted()) {
            return (ResultSet)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        ResultSet value = this.wrapped.executeQuery();
        InterceptResult postResult = this.interceptor.postExecute("executeQuery", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (ResultSet)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public int executeUpdate() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("executeUpdate", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.executeUpdate();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("executeUpdate", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void addBatch() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("addBatch", new Object[0]);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.addBatch();
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("addBatch", null, startTime, endTime, new Object[0]);
    }

    @Override
    public void setNull(int arg1, int arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setNull", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setNull(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setNull", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setNull(int arg1, int arg2, String arg3) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setNull", arg1, arg2, arg3);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setNull(arg1, arg2, arg3);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setNull", null, startTime, endTime, arg1, arg2, arg3);
    }

    @Override
    public void setBigDecimal(int arg1, BigDecimal arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setBigDecimal", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setBigDecimal(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setBigDecimal", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setString(int arg1, String arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setString", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setString(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setString", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setBytes(int arg1, byte[] arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setBytes", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setBytes(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setBytes", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setDate(int arg1, Date arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setDate", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setDate(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setDate", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setDate(int arg1, Date arg2, Calendar arg3) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setDate", arg1, arg2, arg3);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setDate(arg1, arg2, arg3);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setDate", null, startTime, endTime, arg1, arg2, arg3);
    }

    @Override
    public void setAsciiStream(int arg1, InputStream arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setAsciiStream", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setAsciiStream(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setAsciiStream", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setAsciiStream(int arg1, InputStream arg2, long arg3) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setAsciiStream", arg1, arg2, arg3);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setAsciiStream(arg1, arg2, arg3);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setAsciiStream", null, startTime, endTime, arg1, arg2, arg3);
    }

    @Override
    public void setAsciiStream(int arg1, InputStream arg2, int arg3) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setAsciiStream", arg1, arg2, arg3);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setAsciiStream(arg1, arg2, arg3);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setAsciiStream", null, startTime, endTime, arg1, arg2, arg3);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int arg1, InputStream arg2, int arg3) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setUnicodeStream", arg1, arg2, arg3);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setUnicodeStream(arg1, arg2, arg3);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setUnicodeStream", null, startTime, endTime, arg1, arg2, arg3);
    }

    @Override
    public void setBinaryStream(int arg1, InputStream arg2, long arg3) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setBinaryStream", arg1, arg2, arg3);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setBinaryStream(arg1, arg2, arg3);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setBinaryStream", null, startTime, endTime, arg1, arg2, arg3);
    }

    @Override
    public void setBinaryStream(int arg1, InputStream arg2, int arg3) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setBinaryStream", arg1, arg2, arg3);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setBinaryStream(arg1, arg2, arg3);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setBinaryStream", null, startTime, endTime, arg1, arg2, arg3);
    }

    @Override
    public void setBinaryStream(int arg1, InputStream arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setBinaryStream", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setBinaryStream(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setBinaryStream", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void clearParameters() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("clearParameters", new Object[0]);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.clearParameters();
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("clearParameters", null, startTime, endTime, new Object[0]);
    }

    @Override
    public void setObject(int arg1, Object arg2, int arg3, int arg4) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setObject", arg1, arg2, arg3, arg4);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setObject(arg1, arg2, arg3, arg4);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setObject", null, startTime, endTime, arg1, arg2, arg3, arg4);
    }

    @Override
    public void setObject(int arg1, Object arg2, int arg3) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setObject", arg1, arg2, arg3);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setObject(arg1, arg2, arg3);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setObject", null, startTime, endTime, arg1, arg2, arg3);
    }

    @Override
    public void setObject(int arg1, Object arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setObject", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setObject(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setObject", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setCharacterStream(int arg1, Reader arg2, long arg3) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setCharacterStream", arg1, arg2, arg3);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setCharacterStream(arg1, arg2, arg3);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setCharacterStream", null, startTime, endTime, arg1, arg2, arg3);
    }

    @Override
    public void setCharacterStream(int arg1, Reader arg2, int arg3) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setCharacterStream", arg1, arg2, arg3);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setCharacterStream(arg1, arg2, arg3);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setCharacterStream", null, startTime, endTime, arg1, arg2, arg3);
    }

    @Override
    public void setCharacterStream(int arg1, Reader arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setCharacterStream", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setCharacterStream(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setCharacterStream", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setRef(int arg1, Ref arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setRef", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setRef(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setRef", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setBlob(int arg1, InputStream arg2, long arg3) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setBlob", arg1, arg2, arg3);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setBlob(arg1, arg2, arg3);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setBlob", null, startTime, endTime, arg1, arg2, arg3);
    }

    @Override
    public void setBlob(int arg1, InputStream arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setBlob", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setBlob(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setBlob", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setBlob(int arg1, Blob arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setBlob", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setBlob(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setBlob", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setClob(int arg1, Reader arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setClob", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setClob(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setClob", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setClob(int arg1, Reader arg2, long arg3) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setClob", arg1, arg2, arg3);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setClob(arg1, arg2, arg3);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setClob", null, startTime, endTime, arg1, arg2, arg3);
    }

    @Override
    public void setClob(int arg1, Clob arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setClob", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setClob(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setClob", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setArray(int arg1, Array arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setArray", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setArray(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setArray", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("getParameterMetaData", new Object[0]);
        if (preResult.isIntercepted()) {
            return (ParameterMetaData)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        ParameterMetaData value = this.wrapped.getParameterMetaData();
        InterceptResult postResult = this.interceptor.postExecute("getParameterMetaData", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (ParameterMetaData)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void setRowId(int arg1, RowId arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setRowId", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setRowId(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setRowId", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setNString(int arg1, String arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setNString", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setNString(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setNString", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setNCharacterStream(int arg1, Reader arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setNCharacterStream", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setNCharacterStream(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setNCharacterStream", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setNCharacterStream(int arg1, Reader arg2, long arg3) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setNCharacterStream", arg1, arg2, arg3);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setNCharacterStream(arg1, arg2, arg3);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setNCharacterStream", null, startTime, endTime, arg1, arg2, arg3);
    }

    @Override
    public void setNClob(int arg1, Reader arg2, long arg3) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setNClob", arg1, arg2, arg3);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setNClob(arg1, arg2, arg3);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setNClob", null, startTime, endTime, arg1, arg2, arg3);
    }

    @Override
    public void setNClob(int arg1, NClob arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setNClob", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setNClob(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setNClob", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setNClob(int arg1, Reader arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setNClob", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setNClob(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setNClob", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void setSQLXML(int arg1, SQLXML arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setSQLXML", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setSQLXML(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setSQLXML", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public void close() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("close", new Object[0]);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.close();
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("close", null, startTime, endTime, new Object[0]);
    }

    @Override
    public Connection getConnection() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("getConnection", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Connection)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        Connection value = this.wrapped.getConnection();
        InterceptResult postResult = this.interceptor.postExecute("getConnection", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (Connection)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public boolean execute(String arg1, int arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("execute", arg1, arg2);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.execute(arg1, arg2);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("execute", value, startTime, endTime, arg1, arg2);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public boolean execute(String arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("execute", arg1);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.execute(arg1);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("execute", value, startTime, endTime, arg1);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public boolean execute(String arg1, String[] arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("execute", arg1, arg2);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.execute(arg1, arg2);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("execute", value, startTime, endTime, arg1, arg2);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public boolean execute(String arg1, int[] arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("execute", arg1, arg2);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.execute(arg1, arg2);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("execute", value, startTime, endTime, arg1, arg2);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public boolean isClosed() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("isClosed", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.isClosed();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("isClosed", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("getWarnings", new Object[0]);
        if (preResult.isIntercepted()) {
            return (SQLWarning)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        SQLWarning value = this.wrapped.getWarnings();
        InterceptResult postResult = this.interceptor.postExecute("getWarnings", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (SQLWarning)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void clearWarnings() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("clearWarnings", new Object[0]);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.clearWarnings();
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("clearWarnings", null, startTime, endTime, new Object[0]);
    }

    @Override
    public ResultSet executeQuery(String arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("executeQuery", arg1);
        if (preResult.isIntercepted()) {
            return (ResultSet)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        ResultSet value = this.wrapped.executeQuery(arg1);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("executeQuery", value, startTime, endTime, arg1);
        if (postResult.isIntercepted()) {
            return (ResultSet)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public int executeUpdate(String arg1, int arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("executeUpdate", arg1, arg2);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.executeUpdate(arg1, arg2);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("executeUpdate", value, startTime, endTime, arg1, arg2);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public int executeUpdate(String arg1, int[] arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("executeUpdate", arg1, arg2);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.executeUpdate(arg1, arg2);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("executeUpdate", value, startTime, endTime, arg1, arg2);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public int executeUpdate(String arg1, String[] arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("executeUpdate", arg1, arg2);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.executeUpdate(arg1, arg2);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("executeUpdate", value, startTime, endTime, arg1, arg2);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public int executeUpdate(String arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("executeUpdate", arg1);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.executeUpdate(arg1);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("executeUpdate", value, startTime, endTime, arg1);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getMaxFieldSize", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.getMaxFieldSize();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getMaxFieldSize", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void setMaxFieldSize(int arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setMaxFieldSize", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setMaxFieldSize(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setMaxFieldSize", null, startTime, endTime, arg1);
    }

    @Override
    public int getMaxRows() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getMaxRows", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.getMaxRows();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getMaxRows", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void setMaxRows(int arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setMaxRows", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setMaxRows(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setMaxRows", null, startTime, endTime, arg1);
    }

    @Override
    public void setEscapeProcessing(boolean arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setEscapeProcessing", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setEscapeProcessing(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setEscapeProcessing", null, startTime, endTime, arg1);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getQueryTimeout", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.getQueryTimeout();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getQueryTimeout", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void setQueryTimeout(int arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setQueryTimeout", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setQueryTimeout(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setQueryTimeout", null, startTime, endTime, arg1);
    }

    @Override
    public void cancel() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("cancel", new Object[0]);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.cancel();
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("cancel", null, startTime, endTime, new Object[0]);
    }

    @Override
    public void setCursorName(String arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setCursorName", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setCursorName(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setCursorName", null, startTime, endTime, arg1);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("getResultSet", new Object[0]);
        if (preResult.isIntercepted()) {
            return (ResultSet)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        ResultSet value = this.wrapped.getResultSet();
        InterceptResult postResult = this.interceptor.postExecute("getResultSet", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (ResultSet)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getUpdateCount", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.getUpdateCount();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getUpdateCount", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public boolean getMoreResults(int arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getMoreResults", arg1);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.getMoreResults(arg1);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getMoreResults", value, startTime, endTime, arg1);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getMoreResults", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.getMoreResults();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getMoreResults", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void setFetchDirection(int arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setFetchDirection", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setFetchDirection(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setFetchDirection", null, startTime, endTime, arg1);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getFetchDirection", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.getFetchDirection();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getFetchDirection", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void setFetchSize(int arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setFetchSize", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setFetchSize(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setFetchSize", null, startTime, endTime, arg1);
    }

    @Override
    public int getFetchSize() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getFetchSize", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.getFetchSize();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getFetchSize", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getResultSetConcurrency", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.getResultSetConcurrency();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getResultSetConcurrency", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public int getResultSetType() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getResultSetType", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.getResultSetType();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getResultSetType", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void addBatch(String arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("addBatch", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.addBatch(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("addBatch", null, startTime, endTime, arg1);
    }

    @Override
    public void clearBatch() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("clearBatch", new Object[0]);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.clearBatch();
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("clearBatch", null, startTime, endTime, new Object[0]);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("executeBatch", new Object[0]);
        if (preResult.isIntercepted()) {
            return (int[])preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int[] value = this.wrapped.executeBatch();
        InterceptResult postResult = this.interceptor.postExecute("executeBatch", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (int[])postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("getGeneratedKeys", new Object[0]);
        if (preResult.isIntercepted()) {
            return (ResultSet)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        ResultSet value = this.wrapped.getGeneratedKeys();
        InterceptResult postResult = this.interceptor.postExecute("getGeneratedKeys", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (ResultSet)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getResultSetHoldability", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.getResultSetHoldability();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getResultSetHoldability", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void setPoolable(boolean arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setPoolable", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setPoolable(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setPoolable", null, startTime, endTime, arg1);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("isPoolable", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.isPoolable();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("isPoolable", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("closeOnCompletion", new Object[0]);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.closeOnCompletion();
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("closeOnCompletion", null, startTime, endTime, new Object[0]);
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("isCloseOnCompletion", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.isCloseOnCompletion();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("isCloseOnCompletion", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    public Object unwrap(Class arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("unwrap", arg1);
        if (preResult.isIntercepted()) {
            return preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        Object value = this.wrapped.unwrap(arg1);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("unwrap", value, startTime, endTime, arg1);
        if (postResult.isIntercepted()) {
            return postResult.getInterceptResult();
        }
        return value;
    }

    public boolean isWrapperFor(Class arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("isWrapperFor", arg1);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.isWrapperFor(arg1);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("isWrapperFor", value, startTime, endTime, arg1);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    public String getStatement() {
        return this.statement;
    }

    public TypedProperties getEngineProperties() {
        return this.engineProperties;
    }

    public void setEngineProperties(TypedProperties engineProperties) {
        this.engineProperties = engineProperties;
    }
}

