/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.util;

import java.sql.Driver;
import java.sql.DriverManager;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.util.NotJdbcDriverException;
import org.jumpmind.db.util.ResettableBasicDataSource;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.security.SecurityServiceFactory;
import org.slf4j.LoggerFactory;

public class BasicDataSourceFactory {
    protected static Map<String, String> requiredConnectionProperties = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareDriver(String clazzName) throws Exception {
        Class<?> clazz = Class.forName(clazzName);
        if (!Driver.class.isAssignableFrom(clazz)) {
            throw new NotJdbcDriverException(clazzName + " is not a JDBC driver");
        }
        Driver driver = (Driver)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Class<DriverManager> clazz2 = DriverManager.class;
        synchronized (DriverManager.class) {
            Enumeration<Driver> drivers = DriverManager.getDrivers();
            while (drivers.hasMoreElements()) {
                Driver driver2 = drivers.nextElement();
                if ((!driver.getClass().getName().equals("com.mysql.jdbc.Driver") || !driver2.getClass().getName().equals("org.mariadb.jdbc.Driver")) && (!driver.getClass().getName().equals("org.mariadb.jdbc.Driver") || !driver2.getClass().getName().equals("com.mysql.jdbc.Driver"))) continue;
                DriverManager.deregisterDriver(driver2);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (clazzName.equals("org.firebirdsql.jdbc.FBDriver")) {
                requiredConnectionProperties.put("columnLabelForName", "true");
            }
            return;
        }
    }

    public static ResettableBasicDataSource create(TypedProperties properties) {
        return BasicDataSourceFactory.create(properties, SecurityServiceFactory.create((SecurityServiceFactory.SecurityServiceType)SecurityServiceFactory.SecurityServiceType.CLIENT, (TypedProperties)properties));
    }

    public static ResettableBasicDataSource create(TypedProperties properties, ISecurityService securityService) {
        String password;
        properties = properties.copy();
        properties.putAll(System.getProperties());
        ResettableBasicDataSource dataSource = new ResettableBasicDataSource();
        dataSource.setDriverClassName(properties.get("db.driver", null));
        try {
            BasicDataSourceFactory.prepareDriver(dataSource.getDriverClassName());
        }
        catch (Exception e) {
            if (e instanceof ClassNotFoundException) {
                throw new IllegalStateException("Missing JDBC driver for '" + dataSource.getDriverClassName() + "'.  Either provide the JAR or use 'symadmin module convert' command to find and install missing driver.", e);
            }
            if (e instanceof NotJdbcDriverException) {
                throw (NotJdbcDriverException)e;
            }
            throw new IllegalStateException("Had trouble registering the JDBC driver: " + dataSource.getDriverClassName(), e);
        }
        dataSource.setUrl(properties.get("db.url", null));
        String user = properties.get("db.user", "");
        if (user != null && user.startsWith("enc:")) {
            try {
                user = securityService.decrypt(user.substring("enc:".length()));
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to decrypt the database user from your engine properties file stored under the db.user property.   Please re-encrypt your user", ex);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)user)) {
            dataSource.setUsername(user);
        }
        if ((password = properties.get("db.password", "")) != null && password.startsWith("enc:")) {
            try {
                password = securityService.decrypt(password.substring("enc:".length()));
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to decrypt the database password from your engine properties file stored under the db.password property.   Please re-encrypt your password", ex);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)password)) {
            dataSource.setPassword(password);
        }
        dataSource.setInitialSize(properties.getInt("db.pool.initial.size", 2));
        dataSource.setMaxTotal(properties.getInt("db.pool.max.active", 10));
        dataSource.setMaxWait(Duration.ofMillis(properties.getInt("db.pool.max.wait.millis", 5000)));
        dataSource.setMaxIdle(properties.getInt("db.pool.max.idle", 8));
        dataSource.setMinIdle(properties.getInt("db.pool.min.idle", 0));
        dataSource.setMinEvictableIdle(Duration.ofMillis(properties.getInt("db.pool.min.evictable.idle.millis", 60000)));
        dataSource.setDurationBetweenEvictionRuns(Duration.ofMillis(120000L));
        dataSource.setNumTestsPerEvictionRun(10);
        dataSource.setValidationQuery(properties.get("db.validation.query", null));
        dataSource.setTestOnBorrow(properties.is("db.test.on.borrow", true));
        dataSource.setTestOnReturn(properties.is("db.test.on.return", false));
        dataSource.setTestWhileIdle(properties.is("db.test.while.idle", false));
        String connectionProperties = properties.get("db.connection.properties", null);
        if (StringUtils.isNotBlank((CharSequence)connectionProperties)) {
            Object tokens;
            for (Object property : tokens = connectionProperties.split(";")) {
                String[] keyValue = ((String)property).replaceAll("==", "!!").split("=");
                if (keyValue == null || keyValue.length <= 1) continue;
                keyValue[1] = keyValue[1].replaceAll("!!", "=");
                LoggerFactory.getLogger(BasicDataSourceFactory.class).info("Setting database connection property {} to {}", (Object)keyValue[0], (Object)keyValue[1]);
                dataSource.addConnectionProperty(keyValue[0], keyValue[1]);
            }
        }
        for (String key : requiredConnectionProperties.keySet()) {
            String value = requiredConnectionProperties.get(key);
            LoggerFactory.getLogger(BasicDataSourceFactory.class).info("Setting required database connection property {}={}", (Object)key, (Object)value);
            dataSource.addConnectionProperty(key, value);
        }
        String initSql = properties.get("db.init.sql", null);
        if (StringUtils.isNotBlank((CharSequence)initSql)) {
            ArrayList<String> initSqlList = new ArrayList<String>(1);
            initSql = initSql.replaceAll(";;", "!!");
            for (String i : initSql.split(";")) {
                i = i.replaceAll("!!", ";");
                initSqlList.add(i);
            }
            dataSource.setConnectionInitSqls(initSqlList);
        }
        return dataSource;
    }
}

