/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.sqlanywhere;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.sqlanywhere.SqlAnywhereDdlBuilder;
import org.jumpmind.db.platform.sqlanywhere.SqlAnywhereDdlReader;
import org.jumpmind.db.platform.sqlanywhere.SqlAnywhereJdbcSqlTemplate;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlTemplateSettings;

public class SqlAnywhereDatabasePlatform
extends AbstractJdbcDatabasePlatform {
    public static final String JDBC_DRIVER = "com.sybase.jdbc4.jdbc.SybDriver";
    public static final String JDBC_DRIVER_OLD = "com.sybase.jdbc4.jdbc.SybDriver";
    public static final String JDBC_SUBPROTOCOL = "sybase:Tds";
    public static final String JDBC_SUBPROTOCOL_SHORT = "sybase";
    public static final long MAX_TEXT_SIZE = Integer.MAX_VALUE;
    private Map<String, String> sqlScriptReplacementTokens = super.getSqlScriptReplacementTokens();

    public SqlAnywhereDatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
        if (this.sqlScriptReplacementTokens == null) {
            this.sqlScriptReplacementTokens = new HashMap<String, String>();
        }
        this.sqlScriptReplacementTokens.put("current_timestamp", "getdate()");
    }

    protected SqlAnywhereDdlBuilder createDdlBuilder() {
        return new SqlAnywhereDdlBuilder();
    }

    @Override
    protected SqlAnywhereDdlReader createDdlReader() {
        return new SqlAnywhereDdlReader((IDatabasePlatform)this);
    }

    @Override
    protected SqlAnywhereJdbcSqlTemplate createSqlTemplate() {
        return new SqlAnywhereJdbcSqlTemplate(this.dataSource, this.settings, null, this.getDatabaseInfo());
    }

    public String getName() {
        return "sqlanywhere";
    }

    public String getDefaultCatalog() {
        if (StringUtils.isBlank((CharSequence)this.defaultCatalog)) {
            this.defaultCatalog = (String)this.getSqlTemplate().queryForObject("select DB_NAME()", String.class, new Object[0]);
        }
        return this.defaultCatalog;
    }

    public String getDefaultSchema() {
        if (StringUtils.isBlank((CharSequence)this.defaultSchema)) {
            this.defaultSchema = (String)this.getSqlTemplate().queryForObject("select USER_NAME()", String.class, new Object[0]);
        }
        return this.defaultSchema;
    }

    public Map<String, String> getSqlScriptReplacementTokens() {
        return this.sqlScriptReplacementTokens;
    }

    public PermissionResult getCreateSymTriggerPermission() {
        String delimiter = this.getDatabaseInfo().getDelimiterToken();
        delimiter = delimiter != null ? delimiter : "";
        String triggerSql = "CREATE OR REPLACE TRIGGER TEST_TRIGGER AFTER UPDATE ON " + delimiter + "SYM_PERMISSION_TEST" + delimiter + " BEGIN SELECT 1 END";
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TRIGGER, triggerSql);
        try {
            this.getSqlTemplate().update(triggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE TRIGGER permission or TRIGGER permission");
        }
        return result;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public String massageForLimitOffset(String sql, int limit, int offset) {
        return Strings.CI.replace(sql, "select", "select top " + limit + " start at " + (offset + 1));
    }
}

