/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.raima;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.IndexColumn;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.platform.AbstractJdbcDdlReader;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;

public class RaimaDdlReader
extends AbstractJdbcDdlReader {
    public RaimaDdlReader(IDatabasePlatform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
        this.setDefaultTablePattern(null);
    }

    @Override
    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Table table = super.readTable(connection, metaData, values);
        if (table != null) {
            this.determineAutoIncrementFromResultSetMetaData(connection, table, table.getColumns());
            table.setCatalog(null);
            if (table.getIndexCount() > 0) {
                ArrayList<IIndex> nonPkIndices = new ArrayList<IIndex>();
                for (IIndex index : table.getIndices()) {
                    if (index.getColumnCount() == table.getPrimaryKeyColumnCount()) {
                        int matches = 0;
                        for (IndexColumn indexColumn : index.getColumns()) {
                            for (String pkColName : table.getPrimaryKeyColumnNames()) {
                                if (!pkColName.equals(indexColumn.getName())) continue;
                                ++matches;
                            }
                        }
                        if (matches == index.getColumnCount()) continue;
                        nonPkIndices.add(index);
                        continue;
                    }
                    nonPkIndices.add(index);
                }
                table.removeAllIndices();
                table.addIndices(nonPkIndices);
            }
        }
        return table;
    }

    @Override
    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Column column = super.readColumn(metaData, values);
        return column;
    }

    @Override
    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, IIndex index) {
        return (table.getName().toUpperCase() + "..PRIMARY_KEY").equals(index.getName());
    }

    @Override
    protected boolean isInternalForeignKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, ForeignKey fk, IIndex index) {
        return this.getPlatform().getDdlBuilder().getForeignKeyName(table, fk).equals(index.getName());
    }

    @Override
    public List<Trigger> getTriggers(String catalog, String schema, String tableName) {
        ArrayList<Trigger> triggers = new ArrayList();
        this.log.debug("Reading triggers for: " + tableName);
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        String sql = "SELECT schemaname, tabname, name, event, trig.* FROM sys_trigger trig WHERE tabname = ? AND schemaname = ?";
        triggers = sqlTemplate.query(sql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

            public Trigger mapRow(Row row) {
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("NAME"));
                trigger.setSchemaName(row.getString("SCHEMANAME"));
                trigger.setTableName(row.getString("TABNAME"));
                trigger.setEnabled(true);
                String triggerType = row.getString("EVENT");
                if (triggerType.equalsIgnoreCase("DELETE") || triggerType.equalsIgnoreCase("INSERT") || triggerType.equalsIgnoreCase("UPDATE")) {
                    trigger.setTriggerType(Trigger.TriggerType.valueOf((String)triggerType.toUpperCase()));
                }
                trigger.setMetaData((Map)row);
                return trigger;
            }
        }, new Object[]{tableName, schema});
        return triggers;
    }

    @Override
    protected Integer mapUnknownJdbcTypeForColumn(Map<String, Object> values) {
        Integer type = (Integer)values.get("DATA_TYPE");
        if (type != null && type == -8) {
            return -5;
        }
        return super.mapUnknownJdbcTypeForColumn(values);
    }
}

