/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.mssql;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.CompressionTypes;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.IndexColumn;
import org.jumpmind.db.model.PlatformColumn;
import org.jumpmind.db.model.PlatformIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.AbstractJdbcDdlReader;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.DdlException;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.mssql.MsSql2005DatabasePlatform;
import org.jumpmind.db.platform.mssql.MsSql2008DatabasePlatform;
import org.jumpmind.db.sql.ChangeCatalogConnectionHandler;
import org.jumpmind.db.sql.IConnectionHandler;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.mapper.StringMapper;

public class MsSqlDdlReader
extends AbstractJdbcDdlReader {
    private static final String[] KNOWN_SYSTEM_TABLES = new String[]{"dtproperties"};
    private Pattern isoDatePattern = Pattern.compile("'(\\d{4}\\-\\d{2}\\-\\d{2})'");
    private Pattern isoTimePattern = Pattern.compile("'(\\d{2}:\\d{2}:\\d{2})'");
    private Set<String> userDefinedDataTypes = new HashSet<String>();
    private boolean compressAndFilterAndIncludecolumns;

    public MsSqlDdlReader(IDatabasePlatform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
        this.setDefaultTablePattern("%");
        ISqlTemplate sqlTemplate = platform.getSqlTemplateDirty();
        if (sqlTemplate.getDatabaseMajorVersion() >= 9) {
            String sql = "select name from sys.types where is_user_defined = 1";
            List rows = sqlTemplate.query(sql);
            for (Row r : rows) {
                this.userDefinedDataTypes.add(r.getString("name"));
            }
        }
        this.compressAndFilterAndIncludecolumns = platform.getProperties().is("mssql.metadata.query.for.compression.filters.includecolumns", true);
    }

    @Override
    protected String getTableNamePattern(String tableName) {
        tableName = tableName.replace("_", "\\_");
        tableName = tableName.replace("%", "\\%");
        return tableName;
    }

    @Override
    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        String tableName = (String)values.get("TABLE_NAME");
        for (int idx = 0; idx < KNOWN_SYSTEM_TABLES.length; ++idx) {
            if (!KNOWN_SYSTEM_TABLES[idx].equals(tableName)) continue;
            return null;
        }
        Table table = super.readTable(connection, metaData, values);
        if (table != null) {
            if (Strings.CI.equals(table.getSchema(), "sys")) {
                return null;
            }
            this.determineAutoIncrementFromResultSetMetaData(connection, table, table.getColumns());
            int idx = 0;
            while (idx < table.getIndexCount()) {
                IIndex index = table.getIndex(idx);
                if (index.isUnique() && this.existsPKWithName(metaData, table, index.getName())) {
                    table.removeIndex(idx);
                    continue;
                }
                ++idx;
            }
            if (table.hasGeneratedColumns()) {
                String sql = "SELECT name, definition FROM sys.computed_columns WHERE OBJECT_NAME(object_id) = ?";
                try (PreparedStatement ps = connection.prepareStatement(sql);){
                    ps.setString(1, tableName);
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            Column column = table.findColumn(rs.getString(1));
                            if (column == null || column.getDefaultValue() != null) continue;
                            column.setDefaultValue(rs.getString(2));
                            this.parseDefaultValue(column);
                        }
                    }
                }
            }
            if (this.compressAndFilterAndIncludecolumns && this.platform instanceof MsSql2008DatabasePlatform) {
                String sql = "SELECT [TABLENAME] = t.[Name]\n        ,[INDEXNAME] = i.[Name]\n        ,[IndexType] = i.[type_desc]\n        ,[FILTER] = i.filter_definition\n        ,[HASFILTER] = i.has_filter\n        ,[COMPRESSIONTYPE] = p.data_compression\n        ,[COMPRESSIONDESCRIPTION] = p.data_compression_desc\nFROM sys.indexes i WITH (NOLOCK)\nINNER JOIN sys.tables t WITH (NOLOCK) ON t.object_id = i.object_id\nINNER JOIN sys.partitions p WITH (NOLOCK) ON p.object_id=t.object_id AND p.index_id=i.index_id\nWHERE t.type_desc = N'USER_TABLE'\n    and t.name=?\n    and p.index_id in (0,1)\n";
                ArrayList<String> l = new ArrayList<String>();
                l.add(tableName);
                this.log.debug("Running the following query to get metadata about whether a table has compression\n {}", (Object)sql);
                try (PreparedStatement ps = connection.prepareStatement(sql);){
                    ps.setString(1, tableName);
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            int compressionType = rs.getInt("COMPRESSIONTYPE");
                            boolean hasCompression = compressionType > 0;
                            if (!hasCompression) continue;
                            String compressionTypeLabel = null;
                            if (compressionType == 1) {
                                compressionTypeLabel = CompressionTypes.ROW.name();
                                table.setCompressionType(CompressionTypes.ROW);
                            } else if (compressionType == 2) {
                                compressionTypeLabel = CompressionTypes.PAGE.name();
                                table.setCompressionType(CompressionTypes.PAGE);
                            } else if (compressionType == 3) {
                                compressionTypeLabel = CompressionTypes.COLUMNSTORE.name();
                                table.setCompressionType(CompressionTypes.COLUMNSTORE);
                            } else if (compressionType == 4) {
                                compressionTypeLabel = CompressionTypes.COLUMNSTORE_ARCHIVE.name();
                                table.setCompressionType(CompressionTypes.COLUMNSTORE_ARCHIVE);
                            } else {
                                table.setCompressionType(CompressionTypes.NONE);
                            }
                            if (compressionTypeLabel == null) continue;
                            this.log.debug("table: {} has compression: {}", (Object)tableName, (Object)compressionTypeLabel);
                        }
                    }
                }
            }
        }
        return table;
    }

    @Override
    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, IIndex index) {
        StringBuilder pkIndexName = new StringBuilder();
        pkIndexName.append("PK__");
        pkIndexName.append(table.getName());
        pkIndexName.append("__");
        return index.getName().toUpperCase().startsWith(pkIndexName.toString().toUpperCase());
    }

    private boolean existsPKWithName(DatabaseMetaDataWrapper metaData, Table table, String name) {
        try {
            ResultSet pks = metaData.getPrimaryKeys(table.getName());
            boolean found = false;
            while (pks.next() && !found) {
                if (!name.equals(pks.getString("PK_NAME"))) continue;
                found = true;
            }
            pks.close();
            return found;
        }
        catch (SQLException ex) {
            throw new DdlException((Throwable)ex);
        }
    }

    @Override
    protected Integer mapUnknownJdbcTypeForColumn(Map<String, Object> values) {
        String typeName = (String)values.get("TYPE_NAME");
        int size = -1;
        String columnSize = (String)values.get("COLUMN_SIZE");
        if (StringUtils.isNotBlank((CharSequence)columnSize)) {
            size = Integer.parseInt(columnSize);
        }
        if (typeName != null) {
            if (typeName.toLowerCase().startsWith("text")) {
                return -1;
            }
            if (typeName.toLowerCase().startsWith("ntext")) {
                return 2011;
            }
            if (typeName.toLowerCase().equals("float")) {
                return 6;
            }
            if (typeName.toUpperCase().contains("GEOMETRY")) {
                return 12;
            }
            if (typeName.toUpperCase().contains("GEOGRAPHY")) {
                return 12;
            }
            if (typeName.toUpperCase().contains("VARCHAR") && size > 8000) {
                return -1;
            }
            if (typeName.toUpperCase().contains("NVARCHAR") && size > 4000) {
                return -16;
            }
            if (typeName.toUpperCase().equals("SQL_VARIANT")) {
                return -150;
            }
            if (typeName.equalsIgnoreCase("DATETIMEOFFSET")) {
                return -101;
            }
            if (typeName.equalsIgnoreCase("datetime2")) {
                return 93;
            }
            if (typeName.equalsIgnoreCase("DATE")) {
                return 91;
            }
            if (typeName.equalsIgnoreCase("TIME")) {
                return 92;
            }
            if (typeName.equalsIgnoreCase("VARBINARY") && size > 8000) {
                return 2004;
            }
        }
        return super.mapUnknownJdbcTypeForColumn(values);
    }

    @Override
    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Column column = super.readColumn(metaData, values);
        this.parseDefaultValue(column);
        if (column.getMappedTypeCode() == 3 && column.getSizeAsInt() == 19 && column.getScale() == 0) {
            column.setMappedTypeCode(-5);
        }
        if (column.getJdbcTypeName() != null && (column.getJdbcTypeName().equals("smallmoney") || column.getJdbcTypeName().equals("money") || column.getJdbcTypeName().equals("uniqueidentifier") || column.getJdbcTypeName().equals("date")) || column.getJdbcTypeName().equals("timestamp")) {
            this.removePlatformColumnSize(column);
        }
        if (column.getJdbcTypeName() != null) {
            if (column.getJdbcTypeName().equalsIgnoreCase("datetime2")) {
                this.adjustColumnSize(column, -20);
            } else if (column.getJdbcTypeName().equalsIgnoreCase("datetime")) {
                column.setSize("3");
                this.removePlatformColumnSize(column);
            } else if (column.getJdbcTypeName().equalsIgnoreCase("time")) {
                this.adjustColumnSize(column, -9);
            } else if (column.getJdbcTypeName().equalsIgnoreCase("datetimeoffset")) {
                this.adjustColumnSize(column, -27);
            } else if (column.getJdbcTypeName().equalsIgnoreCase("date") || column.getJdbcTypeName().equalsIgnoreCase("smalldatetime")) {
                this.removeColumnSize(column);
            }
        }
        if (this.userDefinedDataTypes.size() > 0 && this.userDefinedDataTypes.contains(column.getJdbcTypeName())) {
            this.removePlatformColumnSize(column);
            for (PlatformColumn pc : column.getPlatformColumns().values()) {
                pc.setUserDefinedType(true);
            }
        }
        return column;
    }

    protected void parseDefaultValue(Column column) {
        String defaultValue = column.getDefaultValue();
        if (defaultValue != null) {
            String substring;
            while (defaultValue.startsWith("(") && defaultValue.endsWith(")") && (substring = defaultValue.substring(1, defaultValue.length() - 1)).indexOf("(") <= substring.indexOf(")") && substring.lastIndexOf("(") <= substring.lastIndexOf(")")) {
                defaultValue = substring;
            }
            if (column.getMappedTypeCode() == 93) {
                Matcher matcher = this.isoDatePattern.matcher(defaultValue);
                Timestamp timestamp = null;
                if (matcher.matches()) {
                    timestamp = new Timestamp(Date.valueOf(matcher.group(1)).getTime());
                } else {
                    matcher = this.isoTimePattern.matcher(defaultValue);
                    if (matcher.matches()) {
                        timestamp = new Timestamp(Time.valueOf(matcher.group(1)).getTime());
                    }
                }
                if (timestamp != null) {
                    defaultValue = timestamp.toString();
                }
            } else if (column.getMappedTypeCode() == 3 || column.getMappedTypeCode() == -5) {
                if (column.getScale() == 0 && defaultValue.endsWith(".")) {
                    defaultValue = defaultValue.substring(0, defaultValue.length() - 1);
                }
            } else if (TypeMap.isTextType((int)column.getMappedTypeCode())) {
                String unescapedValue = this.unescapeTextValue(defaultValue, column);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Unescaped default value for column={}, Original={}, Result={}", new Object[]{column.getName(), defaultValue, unescapedValue});
                }
                defaultValue = unescapedValue;
            }
            column.setDefaultValue(defaultValue);
        }
    }

    protected String unescapeTextValue(String defaultValue, Column column) {
        if (defaultValue.endsWith("'") && (defaultValue.startsWith("N'") || defaultValue.startsWith("'"))) {
            int newStartPos = 0;
            int newEndPos = defaultValue.length() - 1;
            newStartPos = defaultValue.startsWith("N'") ? 2 : 1;
            return this.unescape(defaultValue.substring(newStartPos, newEndPos), "'", "''");
        }
        return defaultValue;
    }

    @Override
    public List<String> getTableNamesFromDatabase(String catalog, String schema, String[] tableTypes) {
        StringBuilder sql = new StringBuilder("select \"TABLE_NAME\" from ");
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            sql.append("\"").append(catalog).append("\"").append(".");
        }
        sql.append("\"INFORMATION_SCHEMA\".\"TABLES\" where \"TABLE_TYPE\"='BASE TABLE'");
        ArrayList<String> args = new ArrayList<String>(2);
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            sql.append(" and \"TABLE_CATALOG\"=?");
            args.add(catalog);
        }
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            sql.append(" and \"TABLE_SCHEMA\"=?");
            args.add(schema);
        }
        return schema == null ? new ArrayList<String>() : this.platform.getSqlTemplateDirty().queryWithHandler(sql.toString(), (ISqlRowMapper)new StringMapper(), (IConnectionHandler)new ChangeCatalogConnectionHandler(catalog), args.toArray(new Object[args.size()]));
    }

    @Override
    public List<Trigger> getTriggers(String catalog, String schema, String tableName) throws SqlException {
        this.log.debug("Reading triggers for: " + tableName);
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplateDirty();
        String sql = "select TRIG.name, TAB.name as table_name, SC.name as table_schema, TRIG.is_disabled, TRIG.is_ms_shipped, TRIG.is_not_for_replication, TRIG.is_instead_of_trigger, TRIG.create_date, TRIG.modify_date, OBJECTPROPERTY(TRIG.OBJECT_ID, 'ExecIsUpdateTrigger') AS isupdate, OBJECTPROPERTY(TRIG.OBJECT_ID, 'ExecIsDeleteTrigger') AS isdelete, OBJECTPROPERTY(TRIG.OBJECT_ID, 'ExecIsInsertTrigger') AS isinsert, OBJECTPROPERTY(TRIG.OBJECT_ID, 'ExecIsAfterTrigger') AS isafter, OBJECTPROPERTY(TRIG.OBJECT_ID, 'ExecIsInsteadOfTrigger') AS isinsteadof, TRIG.object_id, TRIG.parent_id, TAB.schema_id, OBJECT_DEFINITION(TRIG.OBJECT_ID) as trigger_source from sys.triggers as TRIG inner join sys.tables as TAB on TRIG.parent_id = TAB.object_id inner join sys.schemas as SC on TAB.schema_id = SC.schema_id where TAB.name=? and SC.name=? ";
        return sqlTemplate.queryWithHandler(sql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

            public Trigger mapRow(Row row) {
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("name"));
                trigger.setSchemaName(row.getString("table_schema"));
                trigger.setTableName(row.getString("table_name"));
                trigger.setEnabled(Boolean.valueOf(row.getString("is_disabled")) == false);
                trigger.setSource(row.getString("trigger_source"));
                row.remove((Object)"trigger_source");
                for (String s : new String[]{"isupdate", "isdelete", "isinsert", "isafter", "isinsteadof"}) {
                    if (row.getString(s).equals("0")) {
                        row.put(s, (Object)false);
                        continue;
                    }
                    row.put(s, (Object)true);
                }
                if (row.getBoolean("isupdate")) {
                    trigger.setTriggerType(Trigger.TriggerType.UPDATE);
                } else if (row.getBoolean("isdelete")) {
                    trigger.setTriggerType(Trigger.TriggerType.DELETE);
                } else if (row.getBoolean("isinsert")) {
                    trigger.setTriggerType(Trigger.TriggerType.INSERT);
                }
                trigger.setMetaData((Map)row);
                return trigger;
            }
        }, (IConnectionHandler)new ChangeCatalogConnectionHandler(catalog), new Object[]{tableName, schema});
    }

    @Override
    protected IConnectionHandler getConnectionHandler(String catalog) {
        return new ChangeCatalogConnectionHandler(catalog == null ? this.platform.getDefaultCatalog() : catalog);
    }

    private String getIndicesQuery(Collection<IIndex> indices) {
        String sql = null;
        if (this.platform instanceof MsSql2008DatabasePlatform) {
            sql = "SELECT [TABLENAME] = t.[Name]\n        ,[INDEXNAME] = i.[Name]\n        ,[IndexType] = i.[type_desc]\n        ,[FILTER] = i.filter_definition\n        ,[HASFILTER] = i.has_filter\n        ,[COMPRESSIONTYPE] = p.data_compression\n        ,[COMPRESSIONDESCRIPTION] = p.data_compression_desc\n        ,[COLUMN_NAME] = c.name\n        ,[IS_INCLUDED_COLUMN] = ixc.is_included_column\nFROM sys.indexes i WITH (NOLOCK)\nINNER JOIN sys.tables t WITH (NOLOCK) ON t.object_id = i.object_id\nINNER JOIN sys.partitions p WITH (NOLOCK) ON p.object_id=t.object_id AND p.index_id=i.index_id\nINNER JOIN sys.index_columns ixc WITH (NOLOCK) ON t.object_id=ixc.object_id and i.index_id=ixc.index_id\nINNER JOIN sys.columns c WITH (NOLOCK) ON c.object_id=t.object_id and ixc.column_id=c.column_id\nWHERE t.type_desc = N'USER_TABLE'\n        and t.name=?\n        and i.name in (%s)\n        and p.index_id > 1\n";
        } else if (this.platform instanceof MsSql2005DatabasePlatform) {
            sql = "select [TABLENAME] = t.[Name]\n    ,[INDEXNAME] = i.[Name]\n    ,[COLUMN_NAME] = c.name\n    ,[IS_INCLUDED_COLUMN] = ixc.is_included_column\nfrom sys.tables t WITH (NOLOCK)\nINNER JOIN sys.indexes i WITH (NOLOCK) ON t.object_id=i.object_id\nINNER JOIN sys.index_columns ixc WITH (NOLOCK) ON t.object_id=ixc.object_id and i.index_id=ixc.index_id\nINNER JOIN sys.columns c WITH (NOLOCK) ON c.object_id=t.object_id and ixc.column_id=c.column_id\nWHERE t.type_desc = N'USER_TABLE'\n    and i.type > 1\n    and t.name=?\n    and i.name in (%s)\n";
        }
        if (sql != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < indices.size(); ++i) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append("?");
            }
            sql = String.format(sql, sb.toString());
        }
        return sql;
    }

    @Override
    protected Collection<IIndex> readIndices(Connection connection, DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        Collection<IIndex> indices = super.readIndices(connection, metaData, tableName);
        String sql = null;
        if (this.compressAndFilterAndIncludecolumns && indices != null && indices.size() > 0) {
            sql = this.getIndicesQuery(indices);
        }
        if (sql != null) {
            this.log.debug("Running the following query to get metadata about whether an index has compression or filters\n {}", sql);
            try (PreparedStatement ps = connection.prepareStatement(sql);){
                int i = 1;
                ps.setString(i++, tableName);
                for (IIndex index : indices) {
                    ps.setString(i++, index.getName());
                }
                try (ResultSet rs = ps.executeQuery();){
                    Set<String> columnLabels = this.getColumnLabels(rs);
                    while (rs.next()) {
                        this.readIndex(indices, tableName, rs, columnLabels);
                    }
                }
            }
        }
        return indices;
    }

    private void readIndex(Collection<IIndex> indices, String tableName, ResultSet rs, Set<String> columnLabels) throws SQLException {
        String indexName = rs.getString("INDEXNAME");
        IIndex iIndex = this.findIndex(indexName, indices);
        if (iIndex != null) {
            if (columnLabels.contains("HASFILTER")) {
                boolean hasCompression;
                boolean hasFilter = rs.getBoolean("HASFILTER");
                int compressionType = rs.getInt("COMPRESSIONTYPE");
                boolean bl = hasCompression = compressionType > 0;
                if (hasFilter || hasCompression) {
                    PlatformIndex platformIndex = this.findPlatformIndex(indexName, iIndex);
                    if (platformIndex == null) {
                        platformIndex = new PlatformIndex();
                        platformIndex.setName(indexName);
                    }
                    if (hasFilter) {
                        this.log.debug("table: {} index: {} has filter: {}", new Object[]{tableName, indexName, rs.getString("FILTER")});
                        platformIndex.setFilterCondition("WHERE " + rs.getString("FILTER"));
                    }
                    if (hasCompression) {
                        String compressionTypeLabel = null;
                        if (compressionType == 1) {
                            compressionTypeLabel = CompressionTypes.ROW.name();
                            platformIndex.setCompressionType(CompressionTypes.ROW);
                        } else if (compressionType == 2) {
                            compressionTypeLabel = CompressionTypes.PAGE.name();
                            platformIndex.setCompressionType(CompressionTypes.PAGE);
                        } else if (compressionType == 3) {
                            compressionTypeLabel = CompressionTypes.COLUMNSTORE.name();
                            platformIndex.setCompressionType(CompressionTypes.COLUMNSTORE);
                        } else if (compressionType == 4) {
                            compressionTypeLabel = CompressionTypes.COLUMNSTORE_ARCHIVE.name();
                            platformIndex.setCompressionType(CompressionTypes.COLUMNSTORE_ARCHIVE);
                        } else {
                            platformIndex.setCompressionType(CompressionTypes.NONE);
                        }
                        if (compressionTypeLabel != null) {
                            this.log.debug("table: {} index: {} has compression: {}", new Object[]{tableName, indexName, compressionTypeLabel});
                        }
                    }
                    iIndex.addPlatformIndex(platformIndex);
                }
            }
            if (columnLabels.contains("IS_INCLUDED_COLUMN")) {
                int includedColumn = rs.getInt("IS_INCLUDED_COLUMN");
                String columnName = rs.getString("COLUMN_NAME");
                if (includedColumn > 0) {
                    IndexColumn indexColumn = new IndexColumn();
                    indexColumn.setName(columnName);
                    iIndex.addIncludedColumn(indexColumn);
                }
            }
        }
    }

    private IIndex findIndex(String indexName, Collection<IIndex> indices) {
        for (IIndex index : indices) {
            if (!Strings.CS.equals(index.getName(), indexName)) continue;
            return index;
        }
        return null;
    }

    private PlatformIndex findPlatformIndex(String indexName, IIndex iIndex) {
        if (iIndex.getPlatformIndexes() != null && iIndex.getPlatformIndexes().containsKey(indexName)) {
            return (PlatformIndex)iIndex.getPlatformIndexes().get(indexName);
        }
        return null;
    }

    private Set<String> getColumnLabels(ResultSet rs) throws SQLException {
        HashSet<String> s = new HashSet<String>();
        ResultSetMetaData rsmeta = rs.getMetaData();
        int columnCount = rsmeta.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            s.add(rsmeta.getColumnLabel(i));
        }
        return s;
    }

    @Override
    protected String getWithNoLockHint() {
        return " WITH (NOLOCK) ";
    }
}

