/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.ingres;

import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.platform.IDdlReader;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.ingres.IngresDdlBuilder;
import org.jumpmind.db.platform.ingres.IngresDdlReader;
import org.jumpmind.db.platform.ingres.IngresJdbcSqlTemplate;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.sql.SymmetricLobHandler;

public class IngresDatabasePlatform
extends AbstractJdbcDatabasePlatform {
    public static final String JDBC_DRIVER = "com.ingres.jdbc.IngresDriver";
    public static final String JDBC_SUBPROTOCOL = "ingres";

    public IngresDatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
    }

    public String getName() {
        return JDBC_SUBPROTOCOL;
    }

    public String getDefaultSchema() {
        if (StringUtils.isBlank((CharSequence)this.defaultSchema)) {
            this.defaultSchema = (String)this.getSqlTemplate().queryForObject("SELECT DBMSINFO('SESSION_SCHEMA')", String.class, new Object[0]);
        }
        return this.defaultSchema;
    }

    public String getDefaultCatalog() {
        return null;
    }

    public SqlTemplateSettings getSettings() {
        return this.settings;
    }

    @Override
    protected IDdlBuilder createDdlBuilder() {
        return new IngresDdlBuilder();
    }

    @Override
    protected IDdlReader createDdlReader() {
        return new IngresDdlReader((IDatabasePlatform)this);
    }

    @Override
    protected IngresJdbcSqlTemplate createSqlTemplate() {
        SymmetricLobHandler lobHandler = new SymmetricLobHandler();
        return new IngresJdbcSqlTemplate(this.dataSource, this.settings, lobHandler, this.getDatabaseInfo());
    }

    @Override
    protected ISqlTemplate createSqlTemplateDirty() {
        IngresJdbcSqlTemplate sqlTemplateDirty = new IngresJdbcSqlTemplate(this.dataSource, this.settings, null, this.getDatabaseInfo());
        sqlTemplateDirty.setIsolationLevel(1);
        return sqlTemplateDirty;
    }

    protected PermissionResult getCreateSymTriggerPermission() {
        String delimiter = this.getDatabaseInfo().getDelimiterToken();
        delimiter = delimiter != null ? delimiter : "";
        this.getCreateSymRoutinePermission();
        String triggerSql = "CREATE TRIGGER TEST_TRIGGER after insert of SYM_PERMISSION_TEST for each row execute procedure SYM_PROCEDURE_TEST";
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TRIGGER, triggerSql);
        try {
            this.getSqlTemplate().update(triggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE TRIGGER permission and/or DROP TRIGGER permission");
        }
        return result;
    }

    protected PermissionResult getDropSymTriggerPermission() {
        String dropTriggerSql = "DROP TRIGGER TEST_TRIGGER";
        PermissionResult result = new PermissionResult(PermissionType.DROP_TRIGGER, dropTriggerSql);
        try {
            this.getSqlTemplate().update(dropTriggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PermissionResult getCreateSymRoutinePermission() {
        String procedureSql = "CREATE OR REPLACE PROCEDURE SYM_PROCEDURE_TEST AS DECLARE err INT; BEGIN err = 1; END";
        PermissionResult result = new PermissionResult(PermissionType.CREATE_ROUTINE, procedureSql);
        try (ISqlTransaction transaction = null;){
            transaction = this.getSqlTemplate().startSqlTransaction();
            transaction.execute(procedureSql);
            transaction.commit();
            result.setStatus(PermissionResult.Status.PASS);
        }
        return result;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public String massageForLimitOffset(String sql, int limit, int offset) {
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        return sql + " offset " + offset + " fetch first " + limit + " rows only";
    }
}

