/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.cache;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jumpmind.db.model.CatalogSchema;
import org.jumpmind.db.platform.AbstractJdbcDdlReader;

public class ObjectDefinitionCache {
    private AbstractJdbcDdlReader ddlReader;
    private Object tableNameCacheLock = new Object();
    private volatile Map<TableNameCacheKey, List<String>> tableNameCache = new HashMap<TableNameCacheKey, List<String>>();
    private volatile long tableNameCacheTime;

    public ObjectDefinitionCache(AbstractJdbcDdlReader ddlReader) {
        this.ddlReader = ddlReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTableNames(CatalogSchema catalogSchema, String[] tableTypes) {
        List<String> tableNames;
        TableNameCacheKey cacheKey = new TableNameCacheKey(catalogSchema, tableTypes);
        long cacheTimeoutInMs = this.ddlReader.getPlatform().getClearCacheModelTimeoutInMs();
        Object object = this.tableNameCacheLock;
        synchronized (object) {
            boolean timedOut = System.currentTimeMillis() - this.tableNameCacheTime >= cacheTimeoutInMs;
            tableNames = this.tableNameCache.get(cacheKey);
            if (timedOut || tableNames == null) {
                if (timedOut) {
                    this.clearTableNameCache();
                }
                tableNames = this.ddlReader.getTableNamesFromDatabase(catalogSchema.getCatalog(), catalogSchema.getSchema(), tableTypes);
                this.tableNameCache.put(cacheKey, tableNames);
            }
        }
        return tableNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTableNameCache() {
        Object object = this.tableNameCacheLock;
        synchronized (object) {
            this.tableNameCache.clear();
            this.tableNameCacheTime = System.currentTimeMillis();
        }
    }

    private class TableNameCacheKey {
        private CatalogSchema catalogSchema;
        private String[] tableTypes;

        public TableNameCacheKey(CatalogSchema catalogSchema, String[] tableTypes) {
            this.catalogSchema = catalogSchema;
            this.tableTypes = tableTypes;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.catalogSchema == null ? 0 : this.catalogSchema.hashCode());
            result = 31 * result + Arrays.hashCode(this.tableTypes);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TableNameCacheKey)) {
                return false;
            }
            TableNameCacheKey other = (TableNameCacheKey)obj;
            if (this.catalogSchema == null ? other.catalogSchema != null : !this.catalogSchema.equals((Object)other.catalogSchema)) {
                return false;
            }
            return Arrays.equals(this.tableTypes, other.tableTypes);
        }
    }
}

