/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.util.AppUtils;

public class TransportUtils {
    public static BufferedReader toReader(InputStream is) {
        return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    public static BufferedWriter toWriter(OutputStream os) {
        return new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
    }

    public static String toCSV(Map<?, ?> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder buff = new StringBuilder();
        for (Object key : map.keySet()) {
            buff.append(key).append(":").append(map.get(key)).append(",");
        }
        buff.setLength(buff.length() - 1);
        return buff.toString();
    }

    public static Node convertPropertiesToNode(Map<String, String> prop) throws IOException {
        Node node = new Node();
        node.setNodeGroupId(prop.get("nodeGroupId"));
        node.setExternalId(prop.get("externalId"));
        node.setSyncUrl(prop.get("syncURL"));
        node.setSchemaVersion(prop.get("schemaVersion"));
        node.setDatabaseType(prop.get("databaseType"));
        node.setDatabaseVersion(prop.get("databaseVersion"));
        node.setDatabaseName(prop.get("databaseName"));
        node.setSymmetricVersion(prop.get("symmetricVersion"));
        node.setDeploymentType(prop.get("deploymentType"));
        return node;
    }

    public static Map<String, String> convertNodeToProperties(Node node, Map<String, String> prop) {
        if (prop == null) {
            prop = new HashMap<String, String>();
        }
        prop.put("nodeGroupId", node.getNodeGroupId());
        prop.put("externalId", node.getExternalId());
        prop.put("syncURL", node.getSyncUrl());
        prop.put("schemaVersion", node.getSchemaVersion());
        prop.put("databaseType", node.getDatabaseType());
        prop.put("databaseVersion", node.getDatabaseVersion());
        prop.put("databaseName", node.getDatabaseName());
        prop.put("symmetricVersion", node.getSymmetricVersion());
        prop.put("deploymentType", node.getDeploymentType());
        prop.put("hostName", AppUtils.getHostName());
        prop.put("ipAddress", AppUtils.getIpAddress());
        return prop;
    }
}

