/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.statistic;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jumpmind.symmetric.model.DataGap;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessInfoKey;
import org.jumpmind.symmetric.statistic.ChannelStats;
import org.jumpmind.symmetric.statistic.HostStats;
import org.jumpmind.symmetric.statistic.JobStats;
import org.jumpmind.symmetric.statistic.RouterStats;

public interface IStatisticManager {
    public ProcessInfo newProcessInfo(ProcessInfoKey var1);

    public List<ProcessInfo> getProcessInfos();

    public List<ProcessInfo> getProcessInfosThatHaveDoneWork();

    public Set<String> getNodesWithProcessesInError();

    public void flush();

    public void addJobStats(String var1, long var2, long var4, long var6);

    public void addJobStats(String var1, long var2, long var4, long var6, Exception var8);

    public void addJobStats(String var1, long var2, long var4, long var6, String var8);

    public void addJobStats(String var1, int var2, String var3, long var4, long var6, long var8);

    public void addRouterStats(long var1, long var3, long var5, long var7, List<DataGap> var9, Set<String> var10, Collection<OutgoingBatch> var11);

    public RouterStats getRouterStatsByBatch(Long var1);

    public void removeRouterStatsByBatch(Long var1);

    public void incrementDataLoadedErrors(String var1, long var2);

    public void incrementDataBytesLoaded(String var1, long var2);

    public void incrementDataLoaded(String var1, long var2);

    public void incrementDataLoadedOutgoingErrors(String var1, long var2);

    public void incrementDataBytesLoadedOutgoing(String var1, long var2);

    public void incrementDataLoadedOutgoing(String var1, long var2);

    public void incrementDataBytesSent(String var1, long var2);

    public void incrementDataSent(String var1, long var2);

    public void incrementDataEventInserted(String var1, long var2);

    public void incrementDataExtractedErrors(String var1, long var2);

    public void incrementDataBytesExtracted(String var1, long var2);

    public void incrementDataExtracted(String var1, long var2);

    public void setDataUnRouted(String var1, long var2);

    public void incrementDataRouted(String var1, long var2);

    public void incrementDataSentErrors(String var1, long var2);

    public void incrementRestart();

    public void incrementNodesPulled(long var1);

    public void incrementNodesPushed(long var1);

    public void incrementTotalNodesPulledTime(long var1);

    public void incrementTotalNodesPushedTime(long var1);

    public void incrementNodesRejected(long var1);

    public void incrementNodesLoaded(long var1);

    public void incrementNodesRegistered(long var1);

    public void incrementNodesDisabled(long var1);

    public void incrementPurgedBatchIncomingRows(long var1);

    public void incrementPurgedBatchOutgoingRows(long var1);

    public void incrementPurgedDataRows(long var1);

    public void incrementPurgedDataEventRows(long var1);

    public void incrementPurgedStrandedDataRows(long var1);

    public void incrementPurgedStrandedDataEventRows(long var1);

    public void incrementPurgedExpiredDataRows(long var1);

    public void incrementTriggersRemovedCount(long var1);

    public void incrementTriggersRebuiltCount(long var1);

    public void incrementTriggersCreatedCount(long var1);

    public void incrementTableRows(Map<String, Map<String, Long>> var1, boolean var2);

    public Map<String, ChannelStats> getWorkingChannelStats();

    public List<JobStats> getWorkingJobStats();

    public HostStats getWorkingHostStats();

    public TreeMap<Date, Map<String, ChannelStats>> getNodeStatsForPeriod(Date var1, Date var2, String var3, int var4);

    public String getMostRecentActiveTableSynced();

    public Map<Integer, Date> getTotalLoadedRows();
}

