/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.Date;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.service.IContextService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.ContextServiceSqlMap;

public class ContextService
extends AbstractService
implements IContextService {
    public ContextService(IParameterService parameterService, ISymmetricDialect dialect) {
        super(parameterService, dialect);
        this.setSqlMap(new ContextServiceSqlMap(this.symmetricDialect.getPlatform(), this.createSqlReplacementTokens()));
    }

    @Override
    public boolean is(String name) {
        return Boolean.parseBoolean(this.getString(name));
    }

    @Override
    public int getInt(String name) {
        return Integer.parseInt(this.getString(name));
    }

    @Override
    public int getInt(String name, int defaultVal) {
        String val = this.getString(name);
        if (val != null) {
            return Integer.parseInt(val);
        }
        return defaultVal;
    }

    @Override
    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    @Override
    public long getLong(String name, long defaultVal) {
        String val = this.getString(name);
        if (val != null) {
            return Long.parseLong(val);
        }
        return defaultVal;
    }

    @Override
    public String getString(String name) {
        return this.sqlTemplate.queryForString(this.getSql("selectSql"), new Object[]{name});
    }

    @Override
    public int insert(ISqlTransaction transaction, String name, String value) {
        return transaction.prepareAndExecute(this.getSql("insertSql"), new Object[]{name, value, new Date()});
    }

    @Override
    public int update(ISqlTransaction transaction, String name, String value) {
        return transaction.prepareAndExecute(this.getSql("updateSql"), new Object[]{value, new Date(), name});
    }

    @Override
    public int delete(ISqlTransaction transaction, String name) {
        return transaction.prepareAndExecute(this.getSql("deleteSql"), new Object[]{name});
    }

    @Override
    public int delete(String name) {
        return this.sqlTemplate.update(this.getSql("deleteSql"), new Object[]{name});
    }

    @Override
    public void save(String name, String value) {
        this.save(null, name, value);
    }

    @Override
    public void save(ISqlTransaction transaction, String name, String value) {
        if (transaction != null) {
            if (this.update(transaction, name, value) <= 0) {
                this.insert(transaction, name, value);
            }
        } else {
            int count = this.sqlTemplate.update(this.getSql("updateSql"), new Object[]{value, new Date(), name});
            if (count <= 0) {
                this.sqlTemplate.update(this.getSql("insertSql"), new Object[]{name, value, new Date()});
            }
        }
    }
}

