/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.extension.IProcessInfoListener;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.IncomingError;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.RemoteNodeStatus;
import org.jumpmind.symmetric.service.impl.DataLoaderService;
import org.jumpmind.symmetric.transport.IIncomingTransport;

public interface IDataLoaderService {
    public boolean refreshFromDatabase();

    public RemoteNodeStatus loadDataFromPull(Node var1, String var2) throws IOException;

    public void loadDataFromPull(Node var1, RemoteNodeStatus var2) throws IOException;

    public void loadDataFromPush(Node var1, InputStream var2, OutputStream var3) throws IOException;

    public void loadDataFromPush(Node var1, String var2, InputStream var3, OutputStream var4) throws IOException;

    public List<IncomingBatch> loadDataFromTransport(ProcessInfo var1, Node var2, IIncomingTransport var3) throws IOException;

    public List<IncomingBatch> loadDataFromOfflineTransport(Node var1, RemoteNodeStatus var2, IIncomingTransport var3) throws IOException;

    public void loadDataFromConfig(Node var1, RemoteNodeStatus var2, boolean var3) throws IOException;

    public List<String> getAvailableDataLoaderFactories();

    public List<IncomingBatch> loadDataBatch(String var1);

    public List<IncomingBatch> loadDataBatch(String var1, IProcessInfoListener var2);

    public List<DataLoaderService.ConflictNodeGroupLink> getConflictSettingsNodeGroupLinks(NodeGroupLink var1, boolean var2);

    public List<DataLoaderService.ConflictNodeGroupLink> getConflictSettinsNodeGroupLinksFromDb(NodeGroupLink var1);

    public List<DataLoaderService.ConflictNodeGroupLink> getConflictSettingsNodeGroupLinks();

    public void delete(DataLoaderService.ConflictNodeGroupLink var1);

    public void deleteAllConflicts();

    public void save(DataLoaderService.ConflictNodeGroupLink var1);

    public void saveAsCopy(DataLoaderService.ConflictNodeGroupLink var1);

    public void rename(String var1, DataLoaderService.ConflictNodeGroupLink var2);

    public void clearCache();

    public List<IncomingError> getIncomingErrors(long var1, String var3);

    public IncomingError getIncomingError(long var1, String var3, long var4);

    public IncomingError getCurrentIncomingError(long var1, String var3);

    public void insertIncomingError(ISqlTransaction var1, IncomingError var2);

    public void insertIncomingError(IncomingError var1);

    public void updateIncomingError(IncomingError var1);
}

