/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.mapper.NumberMapper;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.model.DataGap;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessInfoKey;
import org.jumpmind.symmetric.model.ProcessType;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.IRouterService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataGapDetector {
    private static final Logger log = LoggerFactory.getLogger(DataGapDetector.class);
    protected IDataService dataService;
    protected IParameterService parameterService;
    protected ISymmetricDialect symmetricDialect;
    protected IRouterService routerService;
    protected IStatisticManager statisticManager;
    protected INodeService nodeService;

    public DataGapDetector() {
    }

    public DataGapDetector(IDataService dataService, IParameterService parameterService, ISymmetricDialect symmetricDialect, IRouterService routerService, IStatisticManager statisticManager, INodeService nodeService) {
        this.dataService = dataService;
        this.parameterService = parameterService;
        this.routerService = routerService;
        this.symmetricDialect = symmetricDialect;
        this.statisticManager = statisticManager;
        this.nodeService = nodeService;
    }

    public void beforeRouting() {
        long printStats = System.currentTimeMillis();
        ProcessInfo processInfo = this.statisticManager.newProcessInfo(new ProcessInfoKey(this.nodeService.findIdentityNodeId(), null, ProcessType.GAP_DETECT));
        try {
            long updateTimeInMs;
            DataGap newGap;
            Object date;
            long ts = System.currentTimeMillis();
            processInfo.setStatus(ProcessInfo.ProcessStatus.QUERYING);
            List<DataGap> gaps = this.dataService.findDataGaps();
            long lastDataId = -1L;
            int dataIdIncrementBy = this.parameterService.getInt("data.id.increment.by");
            long maxDataToSelect = this.parameterService.getLong("routing.largest.gap.size");
            long gapTimoutInMs = this.parameterService.getLong("routing.stale.dataid.gap.time.ms");
            long databaseTime = this.symmetricDialect.getDatabaseTime();
            int idsFilled = 0;
            int newGapsInserted = 0;
            int rangeChecked = 0;
            int gapsDeleted = 0;
            HashSet<DataGap> gapCheck = new HashSet<DataGap>(gaps);
            boolean supportsTransactionViews = this.symmetricDialect.supportsTransactionViews();
            long earliestTransactionTime = 0L;
            if (supportsTransactionViews && (date = this.symmetricDialect.getEarliestTransactionStartTime()) != null) {
                earliestTransactionTime = ((Date)date).getTime() - this.parameterService.getLong("oracle.transaction.view.clock.sync.threshold.ms", 60000L);
            }
            for (DataGap dataGap : gaps) {
                boolean lastGap = dataGap.equals(gaps.get(gaps.size() - 1));
                String sql = this.routerService.getSql("selectDistinctDataIdFromDataEventUsingGapsSql");
                ISqlTemplate sqlTemplate = this.symmetricDialect.getPlatform().getSqlTemplate();
                Object[] params = new Object[]{dataGap.getStartId(), dataGap.getEndId()};
                lastDataId = -1L;
                processInfo.setStatus(ProcessInfo.ProcessStatus.QUERYING);
                long queryForIdsTs = System.currentTimeMillis();
                List ids = sqlTemplate.query(sql, (ISqlRowMapper)new NumberMapper(), params);
                if (System.currentTimeMillis() - queryForIdsTs > 30000L) {
                    log.info("It took longer than {}ms to run the following sql for gap from {} to {}.  {}", new Object[]{30000L, dataGap.getStartId(), dataGap.getEndId(), sql});
                }
                processInfo.setStatus(ProcessInfo.ProcessStatus.PROCESSING);
                idsFilled += ids.size();
                rangeChecked = (int)((long)rangeChecked + (dataGap.getEndId() - dataGap.getStartId()));
                ISqlTransaction transaction = null;
                try {
                    transaction = sqlTemplate.startSqlTransaction();
                    for (Number number : ids) {
                        long dataId = number.longValue();
                        processInfo.incrementCurrentDataCount();
                        if (lastDataId == -1L && dataGap.getStartId() + (long)dataIdIncrementBy <= dataId) {
                            newGap = new DataGap(dataGap.getStartId(), dataId - 1L);
                            if (!gapCheck.contains(newGap)) {
                                this.dataService.insertDataGap(transaction, newGap);
                                gapCheck.add(newGap);
                            }
                            ++newGapsInserted;
                        } else if (lastDataId != -1L && lastDataId + (long)dataIdIncrementBy != dataId && lastDataId != dataId) {
                            newGap = new DataGap(lastDataId + 1L, dataId - 1L);
                            if (!gapCheck.contains(newGap)) {
                                this.dataService.insertDataGap(transaction, newGap);
                                gapCheck.add(newGap);
                            }
                            ++newGapsInserted;
                        }
                        lastDataId = dataId;
                    }
                    if (lastDataId != -1L) {
                        if (!lastGap && lastDataId + (long)dataIdIncrementBy <= dataGap.getEndId()) {
                            DataGap newGap2 = new DataGap(lastDataId + (long)dataIdIncrementBy, dataGap.getEndId());
                            if (!gapCheck.contains(newGap2)) {
                                this.dataService.insertDataGap(transaction, newGap2);
                                gapCheck.add(newGap2);
                            }
                            ++newGapsInserted;
                        }
                        this.dataService.deleteDataGap(transaction, dataGap);
                        ++gapsDeleted;
                    } else if (!lastGap) {
                        Date createTime = dataGap.getCreateTime();
                        if (supportsTransactionViews) {
                            if (createTime != null && (createTime.getTime() < earliestTransactionTime || earliestTransactionTime == 0L) && this.dataService.countDataInRange(dataGap.getStartId() - 1L, dataGap.getEndId() + 1L) == 0) {
                                if (dataGap.getStartId() == dataGap.getEndId()) {
                                    log.info("Found a gap in data_id at {}.  Skipping it because there are no pending transactions in the database", (Object)dataGap.getStartId());
                                } else {
                                    log.info("Found a gap in data_id from {} to {}.  Skipping it because there are no pending transactions in the database", (Object)dataGap.getStartId(), (Object)dataGap.getEndId());
                                }
                                this.dataService.deleteDataGap(transaction, dataGap);
                                ++gapsDeleted;
                            }
                        } else if (createTime != null && databaseTime - createTime.getTime() > gapTimoutInMs && this.dataService.countDataInRange(dataGap.getStartId() - 1L, dataGap.getEndId() + 1L) == 0) {
                            if (dataGap.getStartId() == dataGap.getEndId()) {
                                log.info("Found a gap in data_id at {}.  Skipping it because the gap expired", (Object)dataGap.getStartId());
                            } else {
                                log.info("Found a gap in data_id from {} to {}.  Skipping it because the gap expired", (Object)dataGap.getStartId(), (Object)dataGap.getEndId());
                            }
                            this.dataService.deleteDataGap(transaction, dataGap);
                            ++gapsDeleted;
                        }
                    }
                    if (System.currentTimeMillis() - printStats > 30000L) {
                        log.info("The data gap detection process has been running for {}ms, detected {} rows that have been previously routed over a total gap range of {}, inserted {} new gaps, and deleted {} gaps", new Object[]{System.currentTimeMillis() - ts, idsFilled, rangeChecked, newGapsInserted, gapsDeleted});
                        printStats = System.currentTimeMillis();
                    }
                    transaction.commit();
                }
                catch (Error ex) {
                    if (transaction != null) {
                        transaction.rollback();
                    }
                    throw ex;
                }
                catch (RuntimeException ex) {
                    if (transaction != null) {
                        transaction.rollback();
                    }
                    throw ex;
                }
                finally {
                    if (transaction == null) continue;
                    transaction.close();
                }
            }
            if (lastDataId != -1L && !gapCheck.contains(newGap = new DataGap(lastDataId + 1L, lastDataId + maxDataToSelect))) {
                this.dataService.insertDataGap(newGap);
                gapCheck.add(newGap);
            }
            if ((updateTimeInMs = System.currentTimeMillis() - ts) > 10000L) {
                log.info("Detecting gaps took {} ms", (Object)updateTimeInMs);
            }
            processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
        }
        catch (RuntimeException ex) {
            processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
            throw ex;
        }
    }

    public void afterRouting() {
    }

    public List<DataGap> getDataGaps() {
        return this.dataService.findDataGaps();
    }

    public DataGap getLastDataGap() {
        List<DataGap> gaps = this.getDataGaps();
        if (gaps.size() > 0) {
            return gaps.get(gaps.size() - 1);
        }
        return null;
    }

    public void addDataIds(List<Long> dataIds) {
    }

    public void setIsAllDataRead(boolean isAllDataRead) {
    }

    public void setFullGapAnalysis(boolean isFullGapAnalysis) {
    }

    public void setFullGapAnalysis(ISqlTransaction sqlTransaction, boolean b) {
    }
}

