/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.route.AbstractFileParsingRouter;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.parse.DBFReader;

public class DBFRouter
extends AbstractFileParsingRouter
implements IDataRouter,
IBuiltInExtensionPoint {
    private ISymmetricEngine engine;
    private DBFReader dbfReader = null;

    public DBFRouter(ISymmetricEngine engine) {
        this.engine = engine;
    }

    @Override
    public ISymmetricEngine getEngine() {
        return this.engine;
    }

    @Override
    public List<String> parse(InputStream in, String fileName, int lineNumber, int tableIndex) {
        ArrayList<String> rows = new ArrayList<String>();
        int currentLine = 1;
        try {
            boolean validateHeader = this.engine.getParameterService().is("dbf.router.validate.header", true);
            this.dbfReader = new DBFReader(in, validateHeader);
            while (this.dbfReader.hasNextRecord()) {
                StringBuilder row = new StringBuilder();
                Object[] record = this.dbfReader.nextRecord();
                if (currentLine > lineNumber) {
                    for (int i = 0; i < record.length; ++i) {
                        if (i > 0) {
                            row.append(",");
                        }
                        row.append(record[i]);
                    }
                    rows.add(row.toString());
                }
                ++currentLine;
            }
        }
        catch (Exception e) {
            this.log.error("Unable to parse DBF file " + fileName + " line number " + currentLine, (Throwable)e);
        }
        return rows;
    }

    @Override
    public String getColumnNames() {
        StringBuilder columns = new StringBuilder();
        try {
            for (int i = 0; i < this.dbfReader.getFieldCount(); ++i) {
                if (i > 0) {
                    columns.append(",");
                }
                columns.append(this.dbfReader.getField(i));
            }
        }
        catch (Exception e) {
            this.log.error("Unable to read column names for DBF file ", (Throwable)e);
        }
        return columns.toString();
    }
}

