/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.AbstractDataRouter;
import org.jumpmind.symmetric.route.SimpleRouterContext;

public class BshDataRouter
extends AbstractDataRouter
implements IBuiltInExtensionPoint {
    protected ISymmetricEngine engine;
    final String INTERPRETER_KEY = String.format("%d.BshInterpreter", this.hashCode());

    public BshDataRouter(ISymmetricEngine engine) {
        this.engine = engine;
    }

    @Override
    public Set<String> routeToNodes(SimpleRouterContext context, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad, boolean initialLoadSelectUsed, TriggerRouter triggerRouter) {
        LinkedHashSet<String> boundVariableNames = new LinkedHashSet<String>();
        try {
            long ts = System.currentTimeMillis();
            Interpreter interpreter = this.getInterpreter(context);
            context.incrementStat(System.currentTimeMillis() - ts, "bsh.init.ms");
            HashSet<String> targetNodes = new HashSet<String>();
            ts = System.currentTimeMillis();
            this.bind(interpreter, dataMetaData, nodes, targetNodes, boundVariableNames, initialLoad);
            context.incrementStat(System.currentTimeMillis() - ts, "bsh.bind.ms");
            ts = System.currentTimeMillis();
            Object returnValue = interpreter.eval(dataMetaData.getRouter().getRouterExpression());
            context.incrementStat(System.currentTimeMillis() - ts, "bsh.eval.ms");
            return this.eval(returnValue, nodes, targetNodes);
        }
        catch (EvalError e) {
            if (e instanceof TargetError) {
                Throwable t = ((TargetError)((Object)e)).getTarget();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException("Routing script failed at line " + ((TargetError)((Object)e)).getErrorLineNumber(), t);
            }
            throw new RuntimeException("Failed to evaluate bsh router script.  Bound variables were: " + String.valueOf(boundVariableNames), e);
        }
    }

    protected Interpreter getInterpreter(SimpleRouterContext context) {
        Interpreter interpreter = (Interpreter)context.getContextCache().get(this.INTERPRETER_KEY);
        if (interpreter == null) {
            interpreter = new Interpreter();
            context.getContextCache().put(this.INTERPRETER_KEY, interpreter);
        }
        return interpreter;
    }

    protected Set<String> eval(Object value, Set<Node> nodes, Set<String> targetNodes) {
        targetNodes.remove(null);
        if (targetNodes.size() > 0) {
            return targetNodes;
        }
        if (value instanceof Set) {
            Set values = (Set)value;
            HashSet<String> nodeIds = new HashSet<String>(values.size());
            for (Object v : values) {
                if (v == null) continue;
                nodeIds.add(v.toString());
            }
            return nodeIds;
        }
        if (value instanceof Boolean && value.equals(Boolean.TRUE)) {
            return this.toNodeIds(nodes, null);
        }
        if (value instanceof String) {
            HashSet<String> node = new HashSet<String>(1);
            node.add(value.toString());
            return node;
        }
        return Collections.emptySet();
    }

    protected void bind(Interpreter interpreter, DataMetaData dataMetaData, Set<Node> nodes, Set<String> targetNodes, Set<String> boundVariableNames, boolean initialLoad) throws EvalError {
        this.bind(interpreter, boundVariableNames, "log", this.log);
        this.bind(interpreter, boundVariableNames, "initialLoad", initialLoad);
        this.bind(interpreter, boundVariableNames, "dataMetaData", dataMetaData);
        this.bind(interpreter, boundVariableNames, "nodes", nodes);
        this.bind(interpreter, boundVariableNames, "nodeIds", this.toNodeIds(nodes, null));
        this.bind(interpreter, boundVariableNames, "identityNodeId", this.engine.getNodeService().findIdentityNodeId());
        this.bind(interpreter, boundVariableNames, "targetNodes", targetNodes);
        this.bind(interpreter, boundVariableNames, "engine", this.engine);
        Map<String, Object> params = this.getDataObjectMap(dataMetaData, this.engine.getSymmetricDialect(), true);
        if (params != null) {
            for (String param : params.keySet()) {
                this.bind(interpreter, boundVariableNames, param, params.get(param));
            }
        }
    }

    protected void bind(Interpreter interpreter, Set<String> boundVariableNames, String name, Object value) throws EvalError {
        interpreter.set(name, value);
        boundVariableNames.add(name);
    }

    @Override
    public boolean isDmlOnly() {
        return false;
    }
}

