/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.io.DatabaseXmlUtil;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.file.IFileSourceTracker;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.FileSnapshot;
import org.jumpmind.symmetric.model.FileTrigger;
import org.jumpmind.symmetric.model.FileTriggerRouter;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerReBuildReason;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.AbstractDataRouter;
import org.jumpmind.symmetric.route.FileParsingOptions;
import org.jumpmind.symmetric.route.SimpleRouterContext;
import org.jumpmind.symmetric.service.IContextService;
import org.jumpmind.symmetric.service.IDataService;

public abstract class AbstractFileParsingRouter
extends AbstractDataRouter {
    public static final String TRIGGER_ID_FILE_PARSER = "SYM_VIRTUAL_FILE_PARSE_TRIGGER";
    public static final String EXTERNAL_DATA_ROUTER_KEY = "R";
    public static final String EXTERNAL_DATA_TRIGGER_KEY = "T";
    public static final String EXTERNAL_DATA_FILE_DATA_ID = "D";
    public static final String CONTEXT_FILE_SOURCE_TRACKERS = "trackers";

    public abstract List<String> parse(InputStream var1, String var2, int var3, int var4);

    public abstract String getColumnNames();

    public abstract ISymmetricEngine getEngine();

    @Override
    public Set<String> routeToNodes(SimpleRouterContext context, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad, boolean initialLoadSelectUsed, TriggerRouter triggerRouter) {
        Map<String, String> newData = this.getNewDataAsString(null, dataMetaData, this.getEngine().getSymmetricDialect());
        String targetTableName = dataMetaData.getRouter().getTargetTableName();
        String fileName = newData.get("FILE_NAME");
        String relativeDir = newData.get("RELATIVE_DIR");
        String triggerId = newData.get("TRIGGER_ID");
        String lastEventType = newData.get("LAST_EVENT_TYPE");
        String routerExpression = dataMetaData.getRouter().getRouterExpression();
        String channelId = "default";
        FileParsingOptions options = new FileParsingOptions();
        String filePath = relativeDir + "/" + fileName;
        IContextService contextService = this.getEngine().getContextService();
        if (lastEventType.equals(DataEventType.DELETE.toString())) {
            this.log.debug("File deleted (" + filePath + "), cleaning up context value.");
            contextService.delete(filePath);
        } else {
            options = FileParsingOptions.parse(routerExpression);
            if (triggerId != null) {
                String baseDir = this.getEngine().getFileSyncService().getFileTrigger(triggerId).getBaseDir();
                IFileSourceTracker tracker = this.getFileSourceTracker(context, baseDir);
                File file = this.createSourceFile(baseDir, relativeDir, fileName, triggerId, dataMetaData.getRouter().getRouterId(), tracker);
                String nodeList = this.buildNodeList(nodes);
                String externalData = EXTERNAL_DATA_TRIGGER_KEY + "=" + triggerId + "," + EXTERNAL_DATA_ROUTER_KEY + "=" + dataMetaData.getRouter().getRouterId() + "," + EXTERNAL_DATA_FILE_DATA_ID + "=" + dataMetaData.getData().getDataId();
                try (InputStream in = this.getInputStream(tracker, file);){
                    Map<Integer, String> tableNames = this.getTableNames(this.getTargetTableName(targetTableName, fileName), in);
                    if (options.isStandardizeNames()) {
                        this.standardizeTableNames(tableNames);
                    }
                    int tableIndex = 0;
                    String transactionId = null;
                    if (options.isIncludeTransactionId()) {
                        transactionId = String.valueOf(System.currentTimeMillis());
                    }
                    for (Map.Entry<Integer, String> tableEntry : tableNames.entrySet()) {
                        String contextId = filePath + "[" + tableEntry.getValue() + "]";
                        Integer lineNumber = 0;
                        if (options.isTailFile()) {
                            lineNumber = contextService.getInt(contextId, 0);
                        }
                        List<String> dataRows = this.parse(in, fileName, lineNumber, tableEntry.getKey());
                        String columnNames = this.getColumnNames();
                        if (options.isStandardizeNames()) {
                            columnNames = this.standardizeColumnNames(columnNames);
                        }
                        TriggerHistory hist = this.getTriggerHistory(tableEntry.getValue(), columnNames);
                        if (options.isSendDdl()) {
                            this.sendTableDefinition(dataRows, channelId, hist, nodes, externalData);
                        }
                        if (options.isOverwrite()) {
                            this.clearTable(channelId, hist, triggerRouter, nodes, externalData);
                        }
                        this.insertIntoData(dataRows, channelId, hist, nodeList, externalData, transactionId);
                        if (!dataRows.isEmpty()) {
                            lineNumber = lineNumber + dataRows.size();
                            if (options.isTailFile()) {
                                contextService.save(contextId, lineNumber.toString());
                            }
                            if (tableNames.size() - 1 == tableIndex) {
                                this.deleteFileIfNecessary(dataMetaData);
                            }
                        }
                        this.log.info("Finished parsing file[table] " + fileName + "[" + tableEntry.getValue() + "]");
                        ++tableIndex;
                    }
                }
                catch (IOException ioe) {
                    this.log.error("Unable to load file", (Throwable)ioe);
                }
            }
        }
        return new HashSet<String>();
    }

    public Map<Integer, String> getTableNames(String tableName, InputStream in) throws IOException {
        HashMap<Integer, String> tableNames = new HashMap<Integer, String>();
        tableNames.put(1, tableName);
        return tableNames;
    }

    public String getTargetTableName(String targetTableName, String fileName) {
        if (targetTableName == null) {
            int i = fileName.indexOf(".");
            targetTableName = i > 0 ? fileName.substring(0, i) : fileName;
        }
        return targetTableName;
    }

    protected String standardizeName(String name) {
        if (name != null) {
            name = ((String)name).trim().toLowerCase();
            name = StringUtils.stripAccents((String)name);
            name = ((String)name).replaceAll("[^\\w_]", "_").replaceAll("_+", "_");
            if (((String)(name = StringUtils.strip((String)name, (String)"_"))).length() > 0 && StringUtils.isNumeric((CharSequence)((String)name).substring(0, 1))) {
                name = "_" + (String)name;
            }
        }
        return name;
    }

    protected Map<Integer, String> standardizeTableNames(Map<Integer, String> tableNames) {
        for (Map.Entry<Integer, String> entry : tableNames.entrySet()) {
            entry.setValue(this.standardizeName(entry.getValue()));
        }
        return tableNames;
    }

    protected String standardizeColumnNames(String names) {
        String[] tokens = CsvUtils.tokenizeCsvData((String)names);
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = this.standardizeName(tokens[i]);
        }
        return CsvUtils.escapeCsvData((String[])tokens);
    }

    public String buildNodeList(Set<Node> nodes) {
        StringBuilder sb = new StringBuilder();
        for (Node n : nodes) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(n.getNodeId());
        }
        return sb.toString();
    }

    public File createSourceFile(String baseDir, String relativeDir, String fileName, String triggerId, String routerId, IFileSourceTracker tracker) {
        File sourceFile = null;
        if (tracker != null) {
            FileSnapshot snapshot = new FileSnapshot();
            snapshot.setTriggerId(triggerId);
            snapshot.setRouterId(routerId);
            snapshot.setRelativeDir(relativeDir);
            snapshot.setFileName(fileName);
            sourceFile = tracker.createSourceFile(snapshot);
        } else {
            File sourceBaseDir = new File(baseDir);
            if (!relativeDir.equals(".")) {
                String sourcePath = relativeDir + "/";
                sourceBaseDir = new File(sourceBaseDir, sourcePath);
            }
            sourceFile = new File(sourceBaseDir, fileName);
        }
        return sourceFile;
    }

    protected void sendTableDefinition(List<String> dataRows, String channelId, TriggerHistory hist, Set<Node> nodes, String externalData) {
        Database db = new Database();
        Table table = new Table(hist.getSourceTableName());
        db.addTable(table);
        for (String name : hist.getParsedColumnNames()) {
            Column column = new Column(name);
            column.setTypeCode(12);
            table.addColumn(column);
        }
        IDataService dataService = this.getEngine().getDataService();
        try (ISqlTransaction transaction = null;){
            transaction = this.getEngine().getSqlTemplate().startSqlTransaction();
            String xml = CsvUtils.escapeCsvData((String)DatabaseXmlUtil.toXml((Database)db));
            for (Node node : nodes) {
                dataService.insertCreateEvent(transaction, node, hist, channelId, false, 0L, this.getClass().getSimpleName(), false, false, false, xml, externalData);
            }
            transaction.commit();
        }
    }

    protected void clearTable(String channelId, TriggerHistory hist, TriggerRouter triggerRouter, Set<Node> nodes, String externalData) {
        IDataService dataService = this.getEngine().getDataService();
        String sql = this.getEngine().getParameterService().getString("initial.load.delete.first.sql");
        if (StringUtils.isBlank((CharSequence)sql)) {
            sql = "delete from %s";
        }
        IDatabasePlatform platform = this.getEngine().getDatabasePlatform();
        DatabaseInfo dbInfo = platform.getDatabaseInfo();
        String tableName = Table.getFullyQualifiedTableName((String)triggerRouter.getTargetCatalog(null, hist), (String)triggerRouter.getTargetSchema(null, hist), (String)hist.getSourceTableName(), null, (String)dbInfo.getCatalogSeparator(), (String)dbInfo.getSchemaSeparator());
        sql = String.format(sql, tableName);
        try (ISqlTransaction transaction = null;){
            transaction = this.getEngine().getSqlTemplate().startSqlTransaction();
            for (Node node : nodes) {
                dataService.insertSqlEvent(transaction, hist, channelId, node, sql, false, 0L, externalData, this.getClass().getSimpleName());
            }
            transaction.commit();
        }
    }

    protected void insertIntoData(List<String> dataRows, String channelId, TriggerHistory hist, String nodeList, String externalData, String transactionId) {
        for (String row : dataRows) {
            Data data = new Data();
            data.setChannelId(channelId);
            data.setDataEventType(DataEventType.INSERT);
            data.setRowData(row);
            data.setTableName(hist.getSourceTableName());
            data.setNodeList(nodeList);
            data.setTriggerHistory(hist);
            data.setExternalData(externalData);
            data.setDataId(this.getEngine().getDataService().insertData(data));
            if (transactionId == null) continue;
            data.setTransactionId(transactionId);
        }
    }

    protected TriggerHistory getTriggerHistory(String tableName, String columnNames) {
        List<TriggerHistory> triggerHistories = this.getEngine().getTriggerRouterService().getActiveTriggerHistories(tableName);
        for (TriggerHistory history : triggerHistories) {
            if (!history.getTriggerId().equals(TRIGGER_ID_FILE_PARSER)) continue;
            return history;
        }
        TriggerHistory newTriggerHist = new TriggerHistory(tableName, "", columnNames);
        newTriggerHist.setTriggerId(TRIGGER_ID_FILE_PARSER);
        newTriggerHist.setTableHash(0);
        newTriggerHist.setTriggerRowHash(0L);
        newTriggerHist.setTriggerTemplateHash(0L);
        newTriggerHist.setLastTriggerBuildReason(TriggerReBuildReason.NEW_TRIGGERS);
        newTriggerHist.setColumnNames(columnNames);
        newTriggerHist.setPkColumnNames(columnNames);
        this.getEngine().getTriggerRouterService().insert(newTriggerHist);
        return newTriggerHist;
    }

    protected InputStream getInputStream(IFileSourceTracker tracker, File file) throws IOException {
        InputStream in = null;
        in = tracker != null ? tracker.getInputStream(file) : new FileInputStream(file);
        return in;
    }

    protected IFileSourceTracker getFileSourceTracker(SimpleRouterContext context, String baseDir) {
        IFileSourceTracker tracker = null;
        for (IFileSourceTracker fileTracker : this.getFileSourceTrackers(context)) {
            if (!fileTracker.handlesDir(baseDir)) continue;
            tracker = fileTracker;
            break;
        }
        return tracker;
    }

    protected List<IFileSourceTracker> getFileSourceTrackers(SimpleRouterContext context) {
        List<IFileSourceTracker> trackers = (List<IFileSourceTracker>)context.get(CONTEXT_FILE_SOURCE_TRACKERS);
        if (trackers == null) {
            trackers = this.getEngine().getExtensionService().getExtensionPointList(IFileSourceTracker.class);
            context.put(CONTEXT_FILE_SOURCE_TRACKERS, trackers);
        }
        return trackers;
    }

    public static String getRouterIdFromExternalData(String externalData) {
        return AbstractFileParsingRouter.parseExternalData(externalData).get(EXTERNAL_DATA_ROUTER_KEY);
    }

    public static Map<String, String> parseExternalData(String externalData) {
        String[] keyValues;
        HashMap<String, String> result = new HashMap<String, String>();
        if (externalData != null && (keyValues = externalData.split(",")).length > 0) {
            for (int i = 0; i < keyValues.length; ++i) {
                String[] keyValue = keyValues[i].split("=");
                if (keyValue.length <= 1) continue;
                for (int j = 0; j < keyValue.length; ++j) {
                    result.put(keyValue[0], keyValue[1]);
                }
            }
        }
        return result;
    }

    public void deleteFileIfNecessary(DataMetaData dataMetaData) {
        Data data = dataMetaData.getData();
        Table snapshotTable = dataMetaData.getTable();
        if (data.getDataEventType() == DataEventType.INSERT || data.getDataEventType() == DataEventType.UPDATE) {
            ArrayList<File> filesToDelete = new ArrayList<File>();
            Map columnData = data.toColumnNameValuePairs(snapshotTable.getColumnNames(), "rowData");
            FileSnapshot fileSnapshot = new FileSnapshot();
            fileSnapshot.setTriggerId((String)columnData.get("TRIGGER_ID"));
            fileSnapshot.setRouterId((String)columnData.get("ROUTER_ID"));
            fileSnapshot.setFileModifiedTime(Long.parseLong((String)columnData.get("FILE_MODIFIED_TIME")));
            fileSnapshot.setFileName((String)columnData.get("FILE_NAME"));
            fileSnapshot.setRelativeDir((String)columnData.get("RELATIVE_DIR"));
            fileSnapshot.setLastEventType(FileSnapshot.LastEventType.fromCode((String)columnData.get("LAST_EVENT_TYPE")));
            FileTriggerRouter triggerRouter = this.getEngine().getFileSyncService().getFileTriggerRouter(fileSnapshot.getTriggerId(), fileSnapshot.getRouterId(), true);
            if (triggerRouter != null) {
                File file;
                FileTrigger fileTrigger = triggerRouter.getFileTrigger();
                if (fileTrigger.isDeleteAfterSync()) {
                    file = fileTrigger.createSourceFile(fileSnapshot);
                    if (!file.isDirectory()) {
                        filesToDelete.add(file);
                        if (fileTrigger.isSyncOnCtlFile()) {
                            ctlFile = this.getEngine().getFileSyncService().getControleFile(file);
                            filesToDelete.add(ctlFile);
                        }
                    }
                } else if (this.getEngine().getParameterService().is("file.sync.delete.ctl.file.after.sync", false) && !(file = fileTrigger.createSourceFile(fileSnapshot)).isDirectory() && fileTrigger.isSyncOnCtlFile()) {
                    ctlFile = this.getEngine().getFileSyncService().getControleFile(file);
                    filesToDelete.add(ctlFile);
                }
            }
            if (filesToDelete != null && filesToDelete.size() > 0) {
                for (File file : filesToDelete) {
                    if (file != null && file.exists()) {
                        this.log.debug("Deleting the '{}' file", (Object)file.getAbsolutePath());
                        boolean deleted = FileUtils.deleteQuietly((File)file);
                        if (!deleted) {
                            this.log.warn("Failed to 'delete on sync' the {} file", (Object)file.getAbsolutePath());
                        }
                    }
                    file = null;
                }
                filesToDelete = null;
            }
        }
    }
}

