/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.io.Serializable;
import java.util.Date;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.TriggerHistory;

public class Data
extends CsvData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private TriggerHistory triggerHistory;
    private boolean isPreRouted;

    public Data(long dataId, String pkData, String rowData, DataEventType eventType, String tableName, Date createTime, TriggerHistory triggerHistory, String channelId, String transactionId, String sourceNodeId) {
        this.setDataId(dataId);
        this.setPkData(pkData);
        this.setRowData(rowData);
        this.setDataEventType(eventType);
        this.setTableName(tableName);
        this.setCreateTime(createTime);
        this.setChannelId(channelId);
        this.setTransactionId(transactionId);
        this.setSourceNodeId(sourceNodeId);
        this.triggerHistory = triggerHistory;
    }

    public Data(String tableName, DataEventType eventType, String rowData, String pkData, TriggerHistory triggerHistory, String channelId, String transactionId, String sourceNodeId) {
        this(-1L, pkData, rowData, eventType, tableName, new Date(), triggerHistory, channelId, transactionId, sourceNodeId);
    }

    public Data() {
    }

    public String[] toParsedRowData() {
        return this.getParsedData("rowData");
    }

    public String[] toParsedOldData() {
        return this.getParsedData("oldData");
    }

    public String[] toParsedPkData() {
        return this.getParsedData("pkData");
    }

    public long getDataId() {
        Long dataId = (Long)this.getAttribute("dataId");
        if (dataId != null) {
            return dataId;
        }
        return -1L;
    }

    public void setDataId(long dataId) {
        this.putAttribute("dataId", dataId);
    }

    public String getTableName() {
        return (String)this.getAttribute("tableName");
    }

    public void setTableName(String tableName) {
        this.putAttribute("tableName", tableName);
    }

    public String getRowData() {
        return this.getCsvData("rowData");
    }

    public void setRowData(String rowData) {
        this.putCsvData("rowData", rowData);
    }

    public String getPkData() {
        return this.getCsvData("pkData");
    }

    public void setPkData(String pkData) {
        this.putCsvData("pkData", pkData);
    }

    public String getOldData() {
        return this.getCsvData("oldData");
    }

    public void setOldData(String oldData) {
        this.putCsvData("oldData", oldData);
    }

    public TriggerHistory getTriggerHistory() {
        return this.triggerHistory;
    }

    public void setTriggerHistory(TriggerHistory triggerHistory) {
        this.triggerHistory = triggerHistory;
    }

    public String getChannelId() {
        return (String)this.getAttribute("channelId");
    }

    public void setChannelId(String channelId) {
        this.putAttribute("channelId", channelId);
    }

    public String getTransactionId() {
        return (String)this.getAttribute("transactionId");
    }

    public void setTransactionId(String transactionId) {
        this.putAttribute("transactionId", transactionId);
    }

    public String getSourceNodeId() {
        return (String)this.getAttribute("sourceNodeId");
    }

    public void setSourceNodeId(String sourceNodeId) {
        this.putAttribute("sourceNodeId", sourceNodeId);
    }

    public String getExternalData() {
        return (String)this.getAttribute("externalData");
    }

    public void setExternalData(String externalData) {
        this.putAttribute("externalData", externalData);
    }

    public void setNodeList(String nodeList) {
        this.putAttribute("nodeList", nodeList);
    }

    public String getNodeList() {
        return (String)this.getAttribute("nodeList");
    }

    public boolean isPreRouted() {
        return this.isPreRouted;
    }

    public void setPreRouted(boolean isPreRouted) {
        this.isPreRouted = isPreRouted;
    }

    public Date getCreateTime() {
        return (Date)this.getAttribute("createTime");
    }

    public void setCreateTime(Date createTime) {
        this.putAttribute("createTime", createTime);
    }

    public String getPkDataFor(String columnName) {
        String[] pkData = this.toParsedPkData();
        String[] keyNames = this.triggerHistory.getParsedPkColumnNames();
        if (columnName != null && pkData != null) {
            for (int i = 0; i < keyNames.length && i < pkData.length; ++i) {
                if (!columnName.equals(keyNames[i])) continue;
                return pkData[i];
            }
        }
        return null;
    }
}

