/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.SyntaxParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnMatchExpression {
    public static final String EQUALS = "=";
    public static final String NOT_EQUALS = "!=";
    public static final String CONTAINS = "contains";
    public static final String NOT_CONTAINS = "not contains";
    public static final String HAS = "has";
    public static final String NOT_HAS = "not has";
    public static final String STARTS_WITH = "starts with";
    public static final String NOT_STARTS_WITH = "not starts with";
    public static final String ENDS_WITH = "ends with";
    public static final String NOT_ENDS_WITH = "not ends with";
    public static final String NULL_VALUE = "NULL";
    protected static Logger log = LoggerFactory.getLogger(ColumnMatchExpression.class);
    boolean hasEquals;
    boolean hasNotEquals;
    boolean hasContains;
    boolean hasNotContains;
    boolean hasHas;
    boolean hasNotHas;
    boolean hasStartsWith;
    boolean hasNotStartsWith;
    boolean hasEndsWith;
    boolean hasNotEndsWith;
    String[] tokens;
    String operator;

    public ColumnMatchExpression(String operator, String[] tokens) {
        this.tokens = tokens;
        this.operator = operator;
        if (operator.equals(EQUALS)) {
            this.hasEquals = true;
        } else if (operator.equals(NOT_EQUALS)) {
            this.hasNotEquals = true;
        } else if (operator.equals(CONTAINS)) {
            this.hasContains = true;
        } else if (operator.equals(NOT_CONTAINS)) {
            this.hasNotContains = true;
        } else if (operator.equals(HAS)) {
            this.hasHas = true;
        } else if (operator.equals(NOT_HAS)) {
            this.hasNotHas = true;
        } else if (operator.equals(STARTS_WITH)) {
            this.hasStartsWith = true;
        } else if (operator.equals(NOT_STARTS_WITH)) {
            this.hasNotStartsWith = true;
        } else if (operator.equals(ENDS_WITH)) {
            this.hasEndsWith = true;
        } else if (operator.equals(NOT_ENDS_WITH)) {
            this.hasNotEndsWith = true;
        }
    }

    public static List<ColumnMatchExpression> parse(String expression) throws SyntaxParsingException {
        ArrayList<ColumnMatchExpression> expressions = new ArrayList<ColumnMatchExpression>();
        if (!StringUtils.isBlank((CharSequence)expression)) {
            String[] operators = new String[]{NOT_EQUALS, EQUALS, NOT_CONTAINS, CONTAINS, NOT_HAS, HAS, NOT_STARTS_WITH, STARTS_WITH, NOT_ENDS_WITH, ENDS_WITH};
            String[] expTokens = expression.split("\\s*(\\s+or|\\s+OR)?(\r\n|\r|\n)(or\\s+|OR\\s+)?\\s*|\\s+or\\s+|\\s+OR\\s+");
            if (expTokens != null) {
                for (String t : expTokens) {
                    if (StringUtils.isBlank((CharSequence)t)) continue;
                    boolean isFound = false;
                    for (String operator : operators) {
                        String[] tokens;
                        if (!t.contains(operator) || (tokens = t.split(operator)).length != 2) continue;
                        tokens[0] = ColumnMatchExpression.parseColumn(tokens[0]);
                        tokens[1] = ColumnMatchExpression.parseValue(tokens[1]);
                        expressions.add(new ColumnMatchExpression(operator, tokens));
                        isFound = true;
                        break;
                    }
                    if (isFound) continue;
                    log.warn("The provided column match expression was invalid: {}.  The full expression is {}.", (Object)t, (Object)expression);
                    throw new SyntaxParsingException("The provided column match expression was invalid: " + t + ".  The full expression is " + expression + ".", new Object[0]);
                }
            }
        } else {
            log.warn("The provided column match expression is empty");
        }
        return expressions;
    }

    private static String parseColumn(String value) {
        return value.trim();
    }

    private static String parseValue(String value) {
        if ((value = value.trim()).charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'') {
            value = value.substring(1, value.length() - 1);
            value = value.replaceAll("''", "'");
        }
        return value;
    }

    public boolean run(String columnValue, String compareValue) {
        boolean result = false;
        if (this.hasEquals && (columnValue == null && compareValue == null || columnValue != null && columnValue.equals(compareValue))) {
            result = true;
        } else if (this.hasNotEquals && (columnValue == null && compareValue != null || columnValue != null && !columnValue.equals(compareValue))) {
            result = true;
        } else if (this.hasContains && columnValue != null && compareValue != null && ArrayUtils.contains((Object[])columnValue.split(","), (Object)compareValue)) {
            result = true;
        } else if (this.hasNotContains && columnValue != null && compareValue != null && !ArrayUtils.contains((Object[])columnValue.split(","), (Object)compareValue)) {
            result = true;
        } else if (this.hasHas && (columnValue == null && compareValue == null || columnValue != null && columnValue.contains(compareValue))) {
            result = true;
        } else if (!(!this.hasNotHas || columnValue == null && compareValue == null || columnValue != null && columnValue.contains(compareValue))) {
            result = true;
        } else if (this.hasStartsWith && (columnValue == null && compareValue == null || columnValue != null && columnValue.startsWith(compareValue))) {
            result = true;
        } else if (!(!this.hasNotStartsWith || columnValue == null && compareValue == null || columnValue != null && columnValue.startsWith(compareValue))) {
            result = true;
        } else if (this.hasEndsWith && (columnValue == null && compareValue == null || columnValue != null && columnValue.endsWith(compareValue))) {
            result = true;
        } else if (!(!this.hasNotEndsWith || columnValue == null && compareValue == null || columnValue != null && columnValue.endsWith(compareValue))) {
            result = true;
        }
        return result;
    }

    public String[] getTokens() {
        return this.tokens;
    }

    public String getOperator() {
        return this.operator;
    }

    public boolean hasEquals() {
        return this.hasEquals;
    }

    public boolean hasNotEquals() {
        return this.hasNotEquals;
    }

    public boolean hasContains() {
        return this.hasContains;
    }

    public boolean hasNotContains() {
        return this.hasNotContains;
    }

    public boolean isHasHas() {
        return this.hasHas;
    }

    public void setHasHas(boolean hasHas) {
        this.hasHas = hasHas;
    }

    public boolean isHasNotHas() {
        return this.hasNotHas;
    }

    public void setHasNotHas(boolean hasNotHas) {
        this.hasNotHas = hasNotHas;
    }

    public boolean isHasStartsWith() {
        return this.hasStartsWith;
    }

    public void setHasStartsWith(boolean hasStartsWith) {
        this.hasStartsWith = hasStartsWith;
    }

    public boolean isHasNotStartsWith() {
        return this.hasNotStartsWith;
    }

    public void setHasNotStartsWith(boolean hasNotStartsWith) {
        this.hasNotStartsWith = hasNotStartsWith;
    }

    public boolean isHasEndsWith() {
        return this.hasEndsWith;
    }

    public void setHasEndsWith(boolean hasEndsWith) {
        this.hasEndsWith = hasEndsWith;
    }

    public boolean isHasNotEndsWith() {
        return this.hasNotEndsWith;
    }

    public void setHasNotEndsWith(boolean hasNotEndsWith) {
        this.hasNotEndsWith = hasNotEndsWith;
    }
}

