/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.sqlite;

import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlUtils;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.db.AbstractSymmetricDialect;
import org.jumpmind.symmetric.db.sqlite.SqliteTriggerTemplate;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.service.IContextService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.impl.ContextService;
import org.jumpmind.util.AppUtils;

public class SqliteSymmetricDialect
extends AbstractSymmetricDialect {
    static final String SYNC_TRIGGERS_DISABLED_USER_VARIABLE = "sync_triggers_disabled";
    static final String SYNC_TRIGGERS_DISABLED_NODE_VARIABLE = "sync_node_disabled";
    IContextService contextService;
    String sqliteFunctionToOverride;

    public SqliteSymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new SqliteTriggerTemplate(this);
        this.contextService = new ContextService(parameterService, this);
        this.sqliteFunctionToOverride = SqlUtils.sanitizeFunction((String)parameterService.getString("sqlite.trigger.function.to.use"));
        platform.getDatabaseInfo().setGeneratedColumnsSupported(!Version.isOlderThanVersion(this.getProductVersion(), "3.31.0"));
    }

    @Override
    public void dropRequiredDatabaseObjects() {
    }

    @Override
    public void cleanDatabase() {
    }

    protected void setSqliteFunctionResult(ISqlTransaction transaction, String name, String result) {
    }

    @Override
    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        if (StringUtils.isBlank((CharSequence)this.sqliteFunctionToOverride)) {
            this.contextService.save(transaction, SYNC_TRIGGERS_DISABLED_USER_VARIABLE, "1");
            if (nodeId != null) {
                this.contextService.save(transaction, SYNC_TRIGGERS_DISABLED_NODE_VARIABLE, nodeId);
            }
        } else {
            Object node = nodeId != null ? ":" + nodeId : "";
            this.setSqliteFunctionResult(transaction, this.sqliteFunctionToOverride, "DISABLED" + (String)node);
        }
    }

    @Override
    public void enableSyncTriggers(ISqlTransaction transaction) {
        if (StringUtils.isBlank((CharSequence)this.sqliteFunctionToOverride)) {
            this.contextService.delete(transaction, SYNC_TRIGGERS_DISABLED_USER_VARIABLE);
            this.contextService.delete(transaction, SYNC_TRIGGERS_DISABLED_NODE_VARIABLE);
        } else {
            this.setSqliteFunctionResult(transaction, this.sqliteFunctionToOverride, "ENABLED");
        }
    }

    @Override
    public String getSyncTriggersExpression() {
        if (StringUtils.isBlank((CharSequence)this.sqliteFunctionToOverride)) {
            String contextTableName = this.parameterService.getTablePrefix() + "_context";
            return "(not exists (select context_value from " + contextTableName + " where name = 'sync_triggers_disabled'))";
        }
        return "(" + this.sqliteFunctionToOverride + "() not like 'DISABLED%')";
    }

    @Override
    protected boolean doesTriggerExistOnPlatform(StringBuilder sqlBuffer, String catalogName, String schema, String tableName, String triggerName) {
        return this.platform.getSqlTemplate().queryForInt("select count(*) from sqlite_master where type='trigger' and name=? and tbl_name=? COLLATE NOCASE", new Object[]{triggerName, tableName}) > 0;
    }

    @Override
    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.HEX;
    }

    @Override
    public boolean isBlobSyncSupported() {
        return true;
    }

    @Override
    public boolean isClobSyncSupported() {
        return true;
    }

    @Override
    public boolean isTransactionIdOverrideSupported() {
        return false;
    }

    @Override
    protected String getDbSpecificDataHasChangedCondition(Trigger trigger) {
        return "$(anyColumnChanged)";
    }

    @Override
    public void truncateTable(String tableName) {
        String quote = this.platform.getDdlBuilder().isDelimitedIdentifierModeOn() ? this.platform.getDatabaseInfo().getDelimiterToken() : "";
        boolean success = false;
        int tryCount = 5;
        while (!success && tryCount > 0) {
            try {
                Table table = this.platform.getTableFromCache(tableName, false);
                if (table != null) {
                    this.platform.getSqlTemplate().update(String.format("delete from %s%s%s", quote, table.getName(), quote), new Object[0]);
                    success = true;
                    continue;
                }
                throw new RuntimeException(String.format("Could not find %s to trunate", tableName));
            }
            catch (SqlException ex) {
                this.log.warn("Failed to truncate the " + tableName + " table", (Throwable)ex);
                AppUtils.sleep((long)5000L);
                --tryCount;
            }
        }
    }

    @Override
    public boolean canGapsOccurInCapturedDataIds() {
        return false;
    }
}

