/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.jdbc.SecurityInformation;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.jdbc.nl.NLException;
import oracle.net.ns.NetException;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.ConnOption;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.net.nt.DNVerifier;
import oracle.net.nt.MetricsEnabledSSLSocketFactoryWrapper;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.SSLSocketChannel;
import oracle.net.nt.TcpNTAdapter;
import oracle.net.nt.TcpsConfigure;
import oracle.net.nt.WSSSocketChannel;

public class TcpsNTAdapter
extends TcpNTAdapter {
    private static final String CLASS_NAME = TcpsNTAdapter.class.getName();
    private static final int SSL_CERT_SAN_TYPE_DNS_NAME = 2;
    private static final int SSL_CERT_SAN_TYPE_IP_ADDR = 7;
    private String dnToMatch;
    private SecurityInformation.DNMatchStatus dnMatchStatus = SecurityInformation.DNMatchStatus.NOT_VERIFIED;
    private String hostNameForDNMatch = this.host;
    private String serviceNameForDNMatch = null;
    SSLSocketFactory l_sslSockFac;
    Socket underlyingSocket = null;
    SocketChannel underlyingSocketChannel = null;
    SSLSocket socketWithListener;
    SSLEngine l_sslEngine;
    private String webSocketURI = "/sqlnet";
    private SSLContext sslContext;
    private final DNVerifier dnVerifier;

    public TcpsNTAdapter(String address, @Blind(value=PropertiesBlinder.class) Properties socketOptions, Diagnosable diagnosable, ConnOption connOption) throws NLException, IOException {
        super(address, socketOptions, diagnosable, connOption);
        this.dnVerifier = new DNVerifier(connOption, Boolean.valueOf((String)this.getOption(106)), diagnosable);
        if (this.useNio.booleanValue() && "WSS".equalsIgnoreCase(this.protocol) && connOption.webSocketUri != null) {
            this.webSocketURI = connOption.webSocketUri;
        }
    }

    @Override
    public void connect(DMSFactory.DMSNoun dmsParent) throws IOException, InterruptedIOException {
        if (!this.useNio.booleanValue()) {
            this.l_sslSockFac = this.newSSLSocketFactory(dmsParent);
            this.underlyingSocket = new Socket();
        } else {
            this.l_sslEngine = this.newSSLEngine();
        }
        super.connect(dmsParent);
    }

    @Override
    protected void establishSocket(InetSocketAddress inetAddr, DMSFactory.DMSNoun dmsParent) throws IOException, InterruptedIOException {
        long socketConnectStartTime = System.currentTimeMillis();
        super.establishSocket(inetAddr, dmsParent);
        try {
            this.underlyingSocket = this.socket;
            this.underlyingSocketChannel = this.socketChannel;
            if (!this.useNio.booleanValue()) {
                this.socket = this.l_sslSockFac.createSocket(this.socket, this.host, this.port, true);
            } else {
                this.socketChannel = new SSLSocketChannel(this.socketChannel, this.l_sslEngine, this.getDiagnosable(), this.dnVerifier, false);
                this.socket = this.socketChannel.socket();
            }
            this.setSSLSocketOptions();
            if (this.useNio.booleanValue() && "WSS".equalsIgnoreCase(this.protocol)) {
                this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "establishSocket", "websocketURI={0}. ", (String)null, null, (Object)this.webSocketURI);
                String httpAuthUser = (String)this.socketOptions.get(26);
                OpaqueString httpAuthPwd = (OpaqueString)this.socketOptions.get(27);
                this.socketChannel = new WSSSocketChannel(this.socketChannel, this.webSocketURI, this.host, this.port, httpAuthUser, httpAuthPwd, this.getDiagnosable());
            }
        }
        catch (IOException ioe) {
            throw this.socketConnectFailure(ioe, System.currentTimeMillis() - socketConnectStartTime, inetAddr.getHostString());
        }
    }

    private IOException socketConnectFailure(IOException initCause, long elapsed, String hostIdentifier) {
        String newExMessage = String.format("%s, socket connect lapse %d ms. %s %d %s %s %s %s", initCause.getMessage(), elapsed, hostIdentifier, this.port, this.proxy == null ? "" : "Proxy = " + this.proxy.toString(), this.connectTimeout, this.getInetAddress(), this.useNio);
        IOException newEx = new IOException(newExMessage, initCause);
        return newEx;
    }

    @Override
    public final CompletionStage<Void> connectAsync(DMSFactory.DMSNoun dmsParent, AsyncOutboundTimeoutHandler outboundTimeout, Executor asyncExecutor) {
        if (!this.useNio.booleanValue()) {
            return CompletionStageUtil.failedStage(new IOException("Asynchronous connection is not supported when oracle.jdbc.javaNetNio=false"));
        }
        if ("WSS".equalsIgnoreCase(this.protocol)) {
            return CompletionStageUtil.failedStage(new IOException("Asynchronous connection is not supported with the WebSocket Secureprotocol"));
        }
        try {
            this.l_sslEngine = this.newSSLEngine();
        }
        catch (IOException newEngineFailure) {
            return CompletionStageUtil.failedStage(newEngineFailure);
        }
        return super.connectAsync(dmsParent, outboundTimeout, asyncExecutor);
    }

    @Override
    protected CompletionStage<Void> establishSocketAsync(InetSocketAddress inetAddr, DMSFactory.DMSNoun dmsParent, AsyncOutboundTimeoutHandler outboundTimeout, Executor asyncExecutor) {
        long socketConnectStartTime = System.currentTimeMillis();
        return super.establishSocketAsync(inetAddr, dmsParent, outboundTimeout, asyncExecutor).thenCompose(nil -> {
            try {
                this.underlyingSocket = this.socket;
                this.underlyingSocketChannel = this.socketChannel;
                SSLSocketChannel sslSocketChannel = new SSLSocketChannel(this.socketChannel, this.l_sslEngine, this.getDiagnosable(), this.dnVerifier, false);
                this.socketChannel = sslSocketChannel;
                this.socket = this.socketChannel.socket();
                this.setSSLSocketOptions();
                return sslSocketChannel.doSSLHandshakeAsync(asyncExecutor).exceptionally(CompletionStageUtil.exceptionalCompletionHandler(IOException.class, ioException -> {
                    throw new AsyncHandshakeException((IOException)ioException);
                }));
            }
            catch (IOException ioe) {
                return CompletionStageUtil.failedStage(this.socketConnectFailure(ioe, System.currentTimeMillis() - socketConnectStartTime, inetAddr.getHostString()));
            }
        });
    }

    public void renegotiateSession() throws IOException {
        if (this.useNio.booleanValue()) {
            this.l_sslEngine = this.newSSLEngine();
            SSLSocketChannel newSSLSocketChannel = new SSLSocketChannel(this.underlyingSocketChannel, this.l_sslEngine, this.getDiagnosable(), this.dnVerifier, true);
            if (this.protocol.equalsIgnoreCase("wss")) {
                this.socketChannel.setUnderlyingChannel(newSSLSocketChannel);
            } else {
                this.socketChannel = newSSLSocketChannel;
            }
            this.socket = this.socketChannel.socket();
        } else {
            this.socketWithListener = (SSLSocket)this.socket;
            this.socket = this.l_sslSockFac.createSocket(this.underlyingSocket, this.inetSocketAddress.getHostString(), this.port, true);
        }
        String temp = (String)this.socketOptions.get(3);
        if (temp != null) {
            this.setOption(3, temp);
        }
        this.setSSLSocketOptions();
    }

    public void setSSLSocketOptions() throws IOException {
        super.setSocketOptions();
        SSLSocket sslSocket = null;
        if (!this.useNio.booleanValue()) {
            sslSocket = (SSLSocket)this.socket;
            sslSocket.setUseClientMode(true);
        }
        TcpsConfigure.configureVersion(sslSocket, this.l_sslEngine, (String)this.socketOptions.get(6), this.useNio);
        TcpsConfigure.configureCipherSuites(sslSocket, this.l_sslEngine, (String)this.socketOptions.get(7), this.useNio);
    }

    public String getNegotiatedTLSVersion() throws IOException {
        SSLSession session = this.getSSLSession();
        if (session != null) {
            return session.getProtocol();
        }
        return null;
    }

    @Override
    public void setOption(int option, Object value) throws IOException, NetException {
        switch (option) {
            case 108: {
                this.setServerDNMatchValue((String[])value);
                break;
            }
            default: {
                super.setOption(option, value);
            }
        }
    }

    @Override
    public Object getOption(int option) throws IOException, NetException {
        switch (option) {
            case 102: {
                String cipherSuiteInUse = this.getSSLSession().getCipherSuite();
                if (cipherSuiteInUse != null && cipherSuiteInUse.indexOf("NULL") == -1) {
                    return "TRUE";
                }
                return "FALSE";
            }
            case 105: {
                return this.getSSLSession().getCipherSuite();
            }
            case 103: {
                X509Certificate l_certificate = (X509Certificate)this.getSSLSession().getPeerCertificates()[0];
                return l_certificate.getSubjectDN().getName();
            }
            case 104: {
                return this.getSSLSession().getPeerCertificateChain();
            }
            case 106: {
                String sslServerDNMatchRequiredString = (String)this.socketOptions.getOrDefault((Object)4, this.socketOptions.get(40));
                return Boolean.toString(sslServerDNMatchRequiredString.equalsIgnoreCase("YES") || sslServerDNMatchRequiredString.equalsIgnoreCase("ON") || sslServerDNMatchRequiredString.equalsIgnoreCase("TRUE"));
            }
        }
        return super.getOption(option);
    }

    private SSLSession getSSLSession() {
        return this.useNio != false ? this.l_sslEngine.getSession() : ((SSLSocket)this.socket).getSession();
    }

    public SecurityInformation.DNMatchStatus getDNMatchStatus() {
        return ((SSLSocketChannel)this.socketChannel).getDnMatchStatus();
    }

    public void verifyDN() throws IOException {
        if (this.dnVerifier.isWeakDNMatchAllowed()) {
            ((SSLSocketChannel)this.socketChannel).verifyDN();
        }
    }

    private void setServerDNMatchValue(String[] value) {
        String origSSLServerCertDN = value[0];
        String origServiceName = value[1];
        if (value[2] != null) {
            this.hostNameForDNMatch = value[2];
        }
        if (origSSLServerCertDN != null) {
            this.dnToMatch = origSSLServerCertDN;
        }
        if (origServiceName != null) {
            this.serviceNameForDNMatch = origServiceName.trim();
        }
    }

    @Override
    public NTAdapter.NetworkAdapterType getNetworkAdapterType() {
        return NTAdapter.NetworkAdapterType.TCPS;
    }

    private SSLEngine newSSLEngine() throws IOException {
        if (this.sslContext == null) {
            this.sslContext = CustomSSLSocketFactory.getSSLContext(this.socketOptions);
        }
        SSLEngine userSSLEngine = this.sslContext.createSSLEngine(this.inetSocketAddress.getHostString(), this.port);
        userSSLEngine.setUseClientMode(true);
        return userSSLEngine;
    }

    private SSLSocketFactory newSSLSocketFactory(DMSFactory.DMSNoun dmsParent) throws IOException {
        if (this.sslContext == null) {
            return CustomSSLSocketFactory.getSSLSocketFactory(this.socketOptions, dmsParent);
        }
        SSLSocketFactory userSSLSocketFactory = this.sslContext.getSocketFactory();
        userSSLSocketFactory = new MetricsEnabledSSLSocketFactoryWrapper(userSSLSocketFactory, dmsParent);
        return userSSLSocketFactory;
    }

    @Override
    public final void registerForNonBlockingRead(Consumer<Throwable> onReady) throws IOException {
        assert (this.socketChannel instanceof SSLSocketChannel) : "Not an SSLSocketChannel: " + this.socketChannel;
        if (((SSLSocketChannel)this.socketChannel).hasRemaining()) {
            onReady.accept(null);
        } else {
            super.registerForNonBlockingRead(onReady);
        }
    }

    void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    static class AsyncHandshakeException
    extends IOException {
        AsyncHandshakeException(IOException cause) {
            super(cause);
        }
    }
}

