/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.T4CAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIoer11;
import oracle.net.ns.BreakNetException;

abstract class T4CMarshaller {
    private static final T4CMarshaller BASIC = new BasicMarshaller();
    private static final T4CMarshaller STREAM = new StreamMarshaller();
    static final T4CMarshaller CHAR = BASIC;
    static final T4CMarshaller LONG_RAW = STREAM;
    static final T4CMarshaller RAW = BASIC;
    static final T4CMarshaller VARCHAR = BASIC;
    static final T4CMarshaller LONG = STREAM;

    abstract boolean unmarshalOneRow(Accessor var1) throws SQLException, IOException;

    abstract int readStreamFromWire(byte[] var1, int var2, int var3, int[] var4, boolean[] var5, boolean[] var6, T4CMAREngine var7, T4CTTIoer11 var8) throws SQLException, IOException;

    private T4CMarshaller() {
    }

    private static final class StreamMarshaller
    extends T4CMarshaller {
        private StreamMarshaller() {
        }

        @Override
        boolean unmarshalOneRow(Accessor acc) throws SQLException, IOException {
            T4CAccessor t4cAcc = (T4CAccessor)((Object)acc);
            T4CMAREngine mare = t4cAcc.getMAREngine();
            if (acc.isUseless()) {
                ++acc.lastRowProcessed;
                return false;
            }
            boolean isStream = false;
            acc.escapeSequenceArr[0] = mare.unmarshalUB1();
            if (mare.escapeSequenceNull(acc.escapeSequenceArr[0])) {
                acc.setNull(acc.lastRowProcessed, true);
                mare.processIndicator(false, 0);
                int ignore = (int)mare.unmarshalUB4();
                acc.escapeSequenceArr[0] = 0;
                acc.previousRowProcessed = acc.lastRowProcessed++;
            } else {
                acc.setNull(acc.lastRowProcessed, false);
                acc.readHeaderArr[0] = true;
                acc.readAsNonStreamArr[0] = false;
                if (acc.statement.isFetchStreams || acc.definedColumnType == -2 || acc.definedColumnType == 12 || acc.definedColumnType == 1) {
                    int nbBytesReadTemp = 0;
                    int nbBytesRead = 0;
                    byte[] buf = acc.statement.connection.getByteBuffer(32768);
                    acc.setOffset(acc.lastRowProcessed);
                    while (nbBytesReadTemp != -1) {
                        nbBytesReadTemp = this.readStreamFromWire(buf, 0, 32768, acc.escapeSequenceArr, acc.readHeaderArr, acc.readAsNonStreamArr, mare, ((T4CConnection)acc.statement.connection).oer);
                        if (nbBytesReadTemp == -1) continue;
                        if (acc.statement.connection.checksumMode.needToCalculateFetchChecksum()) {
                            long localCheckSum;
                            acc.statement.checkSum = localCheckSum = CRC64.updateChecksum(acc.statement.checkSum, buf, 0, nbBytesReadTemp);
                        }
                        acc.rowData.put(buf, 0, nbBytesReadTemp);
                        nbBytesRead += nbBytesReadTemp;
                    }
                    acc.setLength(acc.lastRowProcessed, nbBytesRead);
                    acc.previousRowProcessed = acc.lastRowProcessed++;
                    acc.isStream = false;
                    acc.statement.connection.cacheBuffer(buf);
                } else {
                    isStream = true;
                }
            }
            return isStream;
        }

        @Override
        int readStreamFromWire(byte[] buffer, int offset, int length, int[] escapeSequenceArr, boolean[] readHeaderArr, boolean[] readAsNonStreamArr, T4CMAREngine mare, T4CTTIoer11 oer) throws SQLException, IOException {
            int bytesToRead;
            block13: {
                bytesToRead = -1;
                try {
                    if (!readAsNonStreamArr[0]) {
                        if (length > 32768 || length < 0) {
                            throw (SQLException)DatabaseError.createSqlException(433).fillInStackTrace();
                        }
                        if (readHeaderArr[0]) {
                            if (escapeSequenceArr[0] == 254) {
                                bytesToRead = mare.useCLRBigChunks ? mare.unmarshalSB4() : (int)mare.unmarshalUB1();
                            } else {
                                if (escapeSequenceArr[0] == 0) {
                                    oer.connection.internalClose();
                                    throw (SQLException)DatabaseError.createSqlException(401).fillInStackTrace();
                                }
                                readAsNonStreamArr[0] = true;
                                bytesToRead = escapeSequenceArr[0];
                            }
                            readHeaderArr[0] = false;
                            escapeSequenceArr[0] = 0;
                        } else {
                            bytesToRead = mare.useCLRBigChunks ? mare.unmarshalSB4() : (int)mare.unmarshalUB1();
                        }
                    } else {
                        readAsNonStreamArr[0] = false;
                    }
                    if (bytesToRead > 0) {
                        mare.unmarshalNBytes(buffer, offset, bytesToRead);
                    } else {
                        bytesToRead = -1;
                    }
                }
                catch (BreakNetException ea) {
                    bytesToRead = mare.unmarshalSB1();
                    if (bytesToRead != 4) break block13;
                    oer.init();
                    oer.processError();
                }
            }
            if (bytesToRead == -1) {
                readHeaderArr[0] = true;
                mare.unmarshalUB2();
                mare.unmarshalUB2();
            }
            return bytesToRead;
        }
    }

    private static final class BasicMarshaller
    extends T4CMarshaller {
        private BasicMarshaller() {
        }

        @Override
        boolean unmarshalOneRow(Accessor acc) throws SQLException, IOException {
            T4CAccessor t4cAcc = (T4CAccessor)((Object)acc);
            boolean isStream = false;
            if (!acc.isUseless()) {
                if (acc.isUnexpected()) {
                    long pos = acc.rowData.getPosition();
                    t4cAcc.unmarshalColumnMetadata();
                    this.unmarshalBytes(acc);
                    acc.rowData.setPosition(pos);
                    acc.setNull(acc.lastRowProcessed, true);
                } else if (acc.isNullByDescribe()) {
                    acc.setNull(acc.lastRowProcessed, true);
                    t4cAcc.unmarshalColumnMetadata();
                    if (acc.statement.connection.versionNumber < 9200) {
                        t4cAcc.processIndicator(0);
                    }
                } else {
                    t4cAcc.unmarshalColumnMetadata();
                    isStream = this.unmarshalBytes(acc);
                }
            }
            acc.previousRowProcessed = acc.lastRowProcessed++;
            return isStream;
        }

        private boolean unmarshalBytes(Accessor acc) throws SQLException, IOException {
            T4CAccessor t4cAcc = (T4CAccessor)((Object)acc);
            T4CMAREngine mare = t4cAcc.getMAREngine();
            acc.setOffset(acc.lastRowProcessed);
            int len = acc.statement.maxFieldSize > 0 ? ((DynamicByteArray)acc.rowData).unmarshalCLR(mare, acc.statement.maxFieldSize) : ((DynamicByteArray)acc.rowData).unmarshalCLR(mare);
            t4cAcc.processIndicator(len);
            acc.setLength(acc.lastRowProcessed, len);
            acc.setNull(acc.lastRowProcessed, len == 0);
            return false;
        }

        @Override
        int readStreamFromWire(byte[] buffer, int offset, int length, int[] escapeSequenceArr, boolean[] readHeaderArr, boolean[] readAsNonStreamArr, T4CMAREngine mare, T4CTTIoer11 oer) throws SQLException, IOException {
            return -1;
        }
    }
}

