/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.web.FailedEngineInfo;
import org.jumpmind.symmetric.web.SymmetricEngineHolder;

public class SymmetricEngineStarter
implements Runnable {
    private SymmetricEngineHolder holder;
    private String propertiesFile;
    private ISymmetricEngine engine;

    public SymmetricEngineStarter(String propertiesFile, SymmetricEngineHolder holder) {
        this.propertiesFile = propertiesFile;
        this.holder = holder;
    }

    @Override
    public void run() {
        this.engine = this.holder.create(this.propertiesFile);
        if (this.engine != null) {
            String name = this.engine.getEngineName();
            if (this.holder.isAutoStart() && this.engine.getParameterService().is("auto.start.engine") && !this.engine.start()) {
                this.holder.getEnginesFailed().put(name, new FailedEngineInfo(name, this.propertiesFile, this.engine.getLastException()));
            }
            this.holder.getEnginesStartingNames().remove(name);
        }
        this.holder.getEnginesStarting().remove(this);
    }

    public SymmetricEngineHolder getHolder() {
        return this.holder;
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public ISymmetricEngine getEngine() {
        return this.engine;
    }
}

