/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.service.RegistrationRedirectException;
import org.jumpmind.symmetric.transport.http.HttpTransportManager;
import org.jumpmind.symmetric.web.AbstractUriHandler;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.ServletUtils;

public class RegistrationUriHandler
extends AbstractUriHandler {
    private IRegistrationService registrationService;

    public RegistrationUriHandler(IParameterService parameterService, IRegistrationService registrationService, IInterceptor ... interceptors) {
        super("/registration/*", parameterService, interceptors);
        this.registrationService = registrationService;
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Node node = this.transform(req);
        try {
            ServletOutputStream outputStream = res.getOutputStream();
            String pushRegistration = ServletUtils.getParameter(req, "pushRegistration");
            if (Boolean.TRUE.toString().equals(pushRegistration)) {
                node.setNodeId(ServletUtils.getParameter(req, "nodeId"));
                if (!this.parameterService.is("registration.push.config.allowed")) {
                    ServletUtils.sendError(res, 656, "Registration not allowed over push");
                    return;
                }
                if (this.registrationService.isRegisteredWithServer() && !this.registrationService.isRegistrationOpen()) {
                    ServletUtils.sendError(res, 656, "Registration not open");
                    return;
                }
                if (!Strings.CS.equals(node.getSyncUrl(), this.parameterService.getRegistrationUrl())) {
                    ServletUtils.sendError(res, 656, String.format("Not allowed to register with %s", node.getSyncUrl()));
                    return;
                }
                boolean success = false;
                if ("POST".equals(req.getMethod())) {
                    this.log.info("Received push registration request from {}", (Object)node);
                    success = this.registrationService.writeRegistrationProperties((OutputStream)outputStream);
                } else if ("PUT".equals(req.getMethod())) {
                    this.log.info("Loading push registration batch from {}", (Object)node);
                    success = this.registrationService.loadRegistrationBatch(node, this.createInputStream(req), (OutputStream)outputStream);
                }
                if (!success) {
                    ServletUtils.sendError(res, 601, "Error during registration");
                }
                return;
            }
            String userId = ServletUtils.getParameter(req, "regUserId");
            String password = ServletUtils.getParameter(req, "regPassword");
            if (!this.registerNode(node, this.getHostName(req), this.getIpAddress(req), (OutputStream)outputStream, userId, password)) {
                this.log.warn("{} was not allowed to register.", (Object)node);
                ServletUtils.sendError(res, 656, String.format("%s was not allowed to register.", node));
            }
        }
        catch (RegistrationRedirectException e) {
            Object redirectedRegistrationURL = HttpTransportManager.buildRegistrationUrl((String)e.getRedirectionUrl(), (Node)node);
            if (StringUtils.isNotEmpty((CharSequence)req.getQueryString())) {
                redirectedRegistrationURL = (String)redirectedRegistrationURL + "?" + req.getQueryString();
            }
            res.sendRedirect((String)redirectedRegistrationURL);
        }
    }

    private Node transform(HttpServletRequest req) {
        Node node = new Node();
        node.setNodeGroupId(ServletUtils.getParameter(req, "nodeGroupId"));
        node.setSymmetricVersion(ServletUtils.getParameter(req, "symmetricVersion"));
        node.setExternalId(ServletUtils.getParameter(req, "externalId"));
        String syncUrlString = ServletUtils.getParameter(req, "syncURL");
        if (StringUtils.isNotBlank((CharSequence)syncUrlString)) {
            node.setSyncUrl(syncUrlString);
        }
        node.setSchemaVersion(ServletUtils.getParameter(req, "schemaVersion"));
        node.setDatabaseType(ServletUtils.getParameter(req, "databaseType"));
        node.setDatabaseVersion(ServletUtils.getParameter(req, "databaseVersion"));
        node.setDeploymentType(ServletUtils.getParameter(req, "deploymentType"));
        node.setDatabaseName(ServletUtils.getParameter(req, "databaseName"));
        return node;
    }

    protected String getHostName(HttpServletRequest req) {
        String hostName = ServletUtils.getParameter(req, "hostName");
        if (StringUtils.isBlank((CharSequence)hostName)) {
            hostName = req.getRemoteHost();
        }
        return hostName;
    }

    protected String getIpAddress(HttpServletRequest req) {
        String ipAdddress = ServletUtils.getParameter(req, "ipAddress");
        if (StringUtils.isBlank((CharSequence)ipAdddress)) {
            ipAdddress = req.getRemoteAddr();
        }
        return ipAdddress;
    }

    protected boolean registerNode(Node node, String remoteHost, String remoteAddress, OutputStream outputStream, String userId, String password) throws IOException {
        return this.registrationService.registerNode(node, remoteHost, remoteAddress, outputStream, userId, password, true);
    }
}

