/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.transport.IConcurrentConnectionManager;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeConcurrencyInterceptor
implements IInterceptor {
    private static Logger log = LoggerFactory.getLogger(NodeConcurrencyInterceptor.class);
    private IConcurrentConnectionManager concurrentConnectionManager;
    private IConfigurationService configurationService;
    private INodeService nodeService;
    private IStatisticManager statisticManager;

    public NodeConcurrencyInterceptor(IConcurrentConnectionManager concurrentConnectionManager, IConfigurationService configurationService, INodeService nodeService, IStatisticManager statisticManager) {
        this.concurrentConnectionManager = concurrentConnectionManager;
        this.configurationService = configurationService;
        this.nodeService = nodeService;
        this.statisticManager = statisticManager;
    }

    @Override
    public boolean before(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String poolId = req.getRequestURI();
        String nodeId = this.getNodeId(req);
        String method = req.getMethod();
        String threadChannel = req.getHeader("threadChannel");
        String normalizedRequestUri = ServletUtils.normalizeRequestUri(req);
        boolean isPush = normalizedRequestUri.contains("push");
        boolean isFileSync = normalizedRequestUri.contains("filesync");
        if (method.equals("HEAD") && isPush) {
            NodeSecurity identity;
            resp.setContentLength(0);
            IConcurrentConnectionManager.ReservationStatus status = this.concurrentConnectionManager.reserveConnection(nodeId, threadChannel, poolId, IConcurrentConnectionManager.ReservationType.SOFT, false);
            if (status == IConcurrentConnectionManager.ReservationStatus.ACCEPTED) {
                try {
                    this.buildSuspendIgnoreResponseHeaders(nodeId, (ServletResponse)resp);
                }
                catch (Exception ex) {
                    this.concurrentConnectionManager.releaseConnection(nodeId, threadChannel, poolId);
                    log.error("Error building response headers", (Throwable)ex);
                    ServletUtils.sendError(resp, 601);
                }
            } else {
                this.statisticManager.incrementNodesRejected(1L);
                this.sendError(resp, status, nodeId);
                return false;
            }
            if (this.configurationService.isMasterToMaster() && this.nodeService.isDataLoadStarted() && (identity = this.nodeService.findNodeSecurity(this.nodeService.findIdentityNodeId(), true)) != null && nodeId != null && "registration".equals(identity.getInitialLoadCreateBy()) && !nodeId.equals(identity.getCreatedAtNodeId())) {
                log.debug("Not allowing push from node {} until initial load from {} is complete", (Object)nodeId, (Object)identity.getCreatedAtNodeId());
                ServletUtils.sendError(resp, 668);
                return false;
            }
            NodeSecurity nodeSecurity = this.nodeService.findNodeSecurity(nodeId, true);
            if (nodeSecurity != null) {
                String createdAtNodeId = nodeSecurity.getCreatedAtNodeId();
                if (nodeSecurity.isRegistrationEnabled() && (createdAtNodeId == null || createdAtNodeId.equals(this.nodeService.findIdentityNodeId()))) {
                    if (nodeSecurity.getRegistrationTime() != null) {
                        log.debug("Not allowing push from node {} because registration is pending", (Object)nodeId);
                        ServletUtils.sendError(resp, 667);
                    } else {
                        log.debug("Not allowing push from node {} because registration is required", (Object)nodeId);
                        ServletUtils.sendError(resp, 657);
                    }
                }
            }
            return false;
        }
        IConcurrentConnectionManager.ReservationStatus status = this.concurrentConnectionManager.reserveConnection(nodeId, threadChannel, poolId, IConcurrentConnectionManager.ReservationType.HARD, isPush && !isFileSync);
        if (status == IConcurrentConnectionManager.ReservationStatus.ACCEPTED) {
            try {
                this.buildSuspendIgnoreResponseHeaders(nodeId, (ServletResponse)resp);
                return true;
            }
            catch (Exception ex) {
                this.concurrentConnectionManager.releaseConnection(nodeId, threadChannel, poolId);
                log.error("Error building response headers", (Throwable)ex);
                ServletUtils.sendError(resp, 601);
                return false;
            }
        }
        this.statisticManager.incrementNodesRejected(1L);
        if (isPush && status == IConcurrentConnectionManager.ReservationStatus.NOT_FOUND) {
            log.warn("Missing reservation for push, so rejecting node {}", new Object[]{nodeId});
        }
        this.sendError(resp, status, nodeId);
        return false;
    }

    protected void sendError(HttpServletResponse resp, IConcurrentConnectionManager.ReservationStatus status, String nodeId) throws IOException {
        if (status == IConcurrentConnectionManager.ReservationStatus.DUPLICATE) {
            log.debug("Node {} is already connected", (Object)nodeId);
            ServletUtils.sendError(resp, 605);
        } else if (status == IConcurrentConnectionManager.ReservationStatus.NOT_FOUND) {
            log.debug("Node {} has no reservation here", (Object)nodeId);
            ServletUtils.sendError(resp, 604);
        } else {
            log.debug("Node {} rejected because service is busy", (Object)nodeId);
            ServletUtils.sendError(resp, 670);
        }
    }

    protected String getNodeId(HttpServletRequest req) {
        String nodeId = StringUtils.trimToNull((String)req.getParameter("nodeId"));
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            nodeId = StringUtils.trimToNull((String)req.getParameter("externalId"));
        }
        return nodeId;
    }

    @Override
    public void after(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String poolId = req.getRequestURI();
        String nodeId = this.getNodeId(req);
        String threadChannel = req.getHeader("threadChannel");
        this.concurrentConnectionManager.releaseConnection(nodeId, threadChannel, poolId);
    }

    protected void buildSuspendIgnoreResponseHeaders(String nodeId, ServletResponse resp) {
        HttpServletResponse httpResponse = (HttpServletResponse)resp;
        ChannelMap suspendIgnoreChannels = this.configurationService.getSuspendIgnoreChannelLists(nodeId);
        httpResponse.setHeader("Suspended-Channels", suspendIgnoreChannels.getSuspendChannelsAsString());
        httpResponse.setHeader("Ignored-Channels", suspendIgnoreChannels.getIgnoreChannelsAsString());
    }
}

