/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.web.AbstractUriHandler;
import org.jumpmind.symmetric.web.IInterceptor;

public class CopyNodeUriHandler
extends AbstractUriHandler {
    private ISymmetricEngine engine;

    public CopyNodeUriHandler(ISymmetricEngine engine, IInterceptor ... interceptors) {
        super("/copy/*", engine.getParameterService(), interceptors);
        this.engine = engine;
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        IRegistrationService registrationService = this.engine.getRegistrationService();
        IOutgoingBatchService outgoingBatchService = this.engine.getOutgoingBatchService();
        INodeService nodeService = this.engine.getNodeService();
        IConfigurationService configurationService = this.engine.getConfigurationService();
        String identityNodeId = nodeService.findIdentityNodeId();
        String copyFromNodeId = req.getParameter("nodeId");
        String newExternalId = req.getParameter("externalId");
        String newGroupId = req.getParameter("nodeGroupId");
        String newNodeId = registrationService.openRegistration(newGroupId, newExternalId);
        this.log.info("Received a copy request.  New external_id={}, new node_group_id={}, old node_id={}, new node_id={}", new Object[]{newExternalId, newGroupId, copyFromNodeId, newNodeId});
        Set channelIds = configurationService.getChannels(false).keySet();
        for (String channelId : channelIds) {
            String batchId = req.getParameter(channelId + "-" + identityNodeId);
            if (!StringUtils.isNotBlank((CharSequence)batchId)) continue;
            outgoingBatchService.copyOutgoingBatches(channelId, NumberUtils.toLong((String)batchId.trim()), copyFromNodeId, newNodeId);
        }
    }
}

