/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.integrate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.extension.IExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.INodeGroupExtensionPoint;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.integrate.IPublisher;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.jmx.export.annotation.ManagedOperationParameters;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="The management interface for an xml publisher")
public abstract class AbstractXmlPublisherExtensionPoint
implements IExtensionPoint,
INodeGroupExtensionPoint,
ISymmetricEngineAware,
BeanNameAware {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final String XML_CACHE = "XML_CACHE_" + this.hashCode();
    private String[] nodeGroups;
    protected IPublisher publisher;
    protected Set<String> tableNamesToPublishAsGroup;
    protected String xmlTagNameToUseForGroup = "batch";
    protected List<String> groupByColumnNames;
    protected Format xmlFormat;
    protected String name;
    protected ISymmetricEngine engine;
    protected long timeBetweenStatisticsPrintTime = 300000L;
    protected transient long lastStatisticsPrintTime = System.currentTimeMillis();
    protected transient long numberOfMessagesPublishedSinceLastPrintTime = 0L;
    protected transient long amountOfTimeToPublishMessagesSinceLastPrintTime = 0L;
    protected ITimeGenerator timeStringGenerator = new ITimeGenerator(){

        @Override
        public String getTime() {
            return Long.toString(System.currentTimeMillis());
        }
    };

    public AbstractXmlPublisherExtensionPoint() {
        this.xmlFormat = Format.getCompactFormat();
        this.xmlFormat.setOmitDeclaration(true);
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    @ManagedOperation(description="Looks up rows in the database and resends them to the publisher")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="args", description="A pipe deliminated list of key values to use to look up the tables to resend")})
    public boolean resend(String args) {
        try {
            String[] argArray = args != null ? args.split("\\|") : new String[]{};
            DataContext context = new DataContext();
            IDatabasePlatform platform = this.engine.getDatabasePlatform();
            for (String tableName : this.tableNamesToPublishAsGroup) {
                Table table = platform.getTableFromCache(tableName, false);
                List<String[]> dataRowsForTable = this.readData(table, argArray);
                for (String[] values : dataRowsForTable) {
                    Batch batch = new Batch();
                    batch.setBinaryEncoding(this.engine.getSymmetricDialect().getBinaryEncoding());
                    batch.setSourceNodeId("republish");
                    context.setBatch(batch);
                    CsvData data = new CsvData(DataEventType.INSERT);
                    data.putParsedData("rowData", values);
                    Element xml = this.getXmlFromCache((Context)context, context.getBatch().getBinaryEncoding(), table.getColumnNames(), data.getParsedData("rowData"), table.getPrimaryKeyColumnNames(), data.getParsedData("pkData"));
                    if (xml == null) continue;
                    this.toXmlElement(data.getDataEventType(), xml, table.getCatalog(), table.getSchema(), table.getName(), table.getColumnNames(), data.getParsedData("rowData"), table.getPrimaryKeyColumnNames(), data.getParsedData("pkData"));
                }
            }
            if (this.doesXmlExistToPublish((Context)context)) {
                this.finalizeXmlAndPublish((Context)context);
                return true;
            }
            this.log.warn("Failed to resend message for tables {}, columns {}, and args {}", new Object[]{this.tableNamesToPublishAsGroup, this.groupByColumnNames, args});
        }
        catch (RuntimeException ex) {
            this.log.error(String.format("Failed to resend message for tables %s, columns %s, and args %s", this.tableNamesToPublishAsGroup, this.groupByColumnNames, args), (Throwable)ex);
        }
        return false;
    }

    @ManagedAttribute(description="A comma separated list of columns that act as the key values for the tables that will be published")
    public String getKeyColumnNames() {
        return this.groupByColumnNames != null ? this.groupByColumnNames.toString() : "";
    }

    @ManagedAttribute(description="A comma separated list of tables that will be published")
    public String getTableNames() {
        return this.tableNamesToPublishAsGroup != null ? this.tableNamesToPublishAsGroup.toString() : "";
    }

    protected List<String[]> readData(final Table table, String[] args) {
        final IDatabasePlatform platform = this.engine.getDatabasePlatform();
        List<Object> rows = new ArrayList<String[]>();
        String[] columnNames = table.getColumnNames();
        if (columnNames != null && columnNames.length > 0) {
            String columnName;
            int i;
            StringBuilder builder = new StringBuilder("select ");
            for (i = 0; i < columnNames.length; ++i) {
                columnName = columnNames[i];
                if (i > 0) {
                    builder.append(",");
                }
                builder.append(columnName);
            }
            builder.append(" from ").append(table.getName()).append(" where ");
            for (i = 0; i < this.groupByColumnNames.size(); ++i) {
                columnName = this.groupByColumnNames.get(i);
                if (i > 0 && i < this.groupByColumnNames.size()) {
                    builder.append(" and ");
                }
                builder.append(columnName).append("=?");
            }
            ISqlTemplate template = platform.getSqlTemplate();
            Object[] argObjs = platform.getObjectValues(this.engine.getSymmetricDialect().getBinaryEncoding(), args, table.getColumnsWithName(this.groupByColumnNames.toArray(new String[this.groupByColumnNames.size()])));
            rows = template.query(builder.toString(), (ISqlRowMapper)new ISqlRowMapper<String[]>(){

                public String[] mapRow(Row row) {
                    return platform.getStringValues(AbstractXmlPublisherExtensionPoint.this.engine.getSymmetricDialect().getBinaryEncoding(), table.getColumns(), row, false, false);
                }
            }, argObjs);
        }
        return rows;
    }

    protected static final Namespace getXmlNamespace() {
        return Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    }

    protected Map<String, Element> getXmlCache(Context context) {
        HashMap xmlCache = (HashMap)context.get(this.XML_CACHE);
        if (xmlCache == null) {
            xmlCache = new HashMap();
            context.put(this.XML_CACHE, xmlCache);
        }
        return xmlCache;
    }

    protected boolean doesXmlExistToPublish(Context context) {
        Map xmlCache = (Map)context.get(this.XML_CACHE);
        return xmlCache != null && xmlCache.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalizeXmlAndPublish(Context context) {
        Map<String, Element> contextCache = this.getXmlCache(context);
        Collection<Element> buffers = contextCache.values();
        Iterator<Element> iterator = buffers.iterator();
        while (iterator.hasNext()) {
            String xml = new XMLOutputter(this.xmlFormat).outputString(new Document(iterator.next()));
            this.log.debug("Sending XML to IPublisher: {}", (Object)xml);
            iterator.remove();
            long ts = System.currentTimeMillis();
            this.publisher.publish(context, xml);
            this.amountOfTimeToPublishMessagesSinceLastPrintTime += System.currentTimeMillis() - ts;
            ++this.numberOfMessagesPublishedSinceLastPrintTime;
        }
        if (System.currentTimeMillis() - this.lastStatisticsPrintTime > this.timeBetweenStatisticsPrintTime) {
            AbstractXmlPublisherExtensionPoint abstractXmlPublisherExtensionPoint = this;
            synchronized (abstractXmlPublisherExtensionPoint) {
                if (System.currentTimeMillis() - this.lastStatisticsPrintTime > this.timeBetweenStatisticsPrintTime) {
                    this.log.info(this.name + " published " + this.numberOfMessagesPublishedSinceLastPrintTime + " messages in the last " + (System.currentTimeMillis() - this.lastStatisticsPrintTime) / 1000L + " seconds.  Spent " + this.amountOfTimeToPublishMessagesSinceLastPrintTime / this.numberOfMessagesPublishedSinceLastPrintTime + "ms of publishing time per message");
                    this.lastStatisticsPrintTime = System.currentTimeMillis();
                    this.numberOfMessagesPublishedSinceLastPrintTime = 0L;
                    this.amountOfTimeToPublishMessagesSinceLastPrintTime = 0L;
                }
            }
        }
    }

    protected void toXmlElement(DataEventType dml, Element xml, String catalogName, String schemaName, String tableName, String[] columnNames, String[] data, String[] keyNames, String[] keys) {
        Element row = new Element("row");
        xml.addContent((Content)row);
        if (StringUtils.isNotBlank((CharSequence)catalogName)) {
            row.setAttribute("catalog", catalogName);
        }
        if (StringUtils.isNotBlank((CharSequence)schemaName)) {
            row.setAttribute("schema", schemaName);
        }
        row.setAttribute("entity", tableName);
        row.setAttribute("dml", dml.getCode());
        String[] colNames = null;
        if (data == null) {
            colNames = keyNames;
            data = keys;
        } else {
            colNames = columnNames;
        }
        for (int i = 0; i < data.length; ++i) {
            String col = colNames[i];
            Element dataElement = new Element("data");
            row.addContent((Content)dataElement);
            dataElement.setAttribute("key", col);
            if (data[i] != null) {
                dataElement.setText(this.replaceInvalidChars(data[i]));
                continue;
            }
            dataElement.setAttribute("nil", "true", AbstractXmlPublisherExtensionPoint.getXmlNamespace());
        }
    }

    public String replaceInvalidChars(String in) {
        if (in == null || in.equals("")) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (current != '\t' && current != '\n' && current != '\r' && (current < ' ' || current > '\ud7ff') && (current < '\ue000' || current > '\ufffd')) continue;
            out.append(current);
        }
        return out.toString();
    }

    protected void addFormattedExtraGroupAttributes(Context context, Element xml) {
        if (context instanceof DataContext) {
            DataContext dataContext = (DataContext)context;
            xml.setAttribute("nodeid", dataContext.getBatch().getSourceNodeId());
            xml.setAttribute("batchid", Long.toString(dataContext.getBatch().getBatchId()));
        }
        if (this.timeStringGenerator != null) {
            xml.setAttribute("time", this.timeStringGenerator.getTime());
        }
    }

    protected Element getXmlFromCache(Context context, BinaryEncoding binaryEncoding, String[] columnNames, String[] data, String[] keyNames, String[] keys) {
        Map<String, Element> xmlCache = this.getXmlCache(context);
        Element xml = null;
        String txId = this.toXmlGroupId(columnNames, data, keyNames, keys);
        if (txId != null && (xml = xmlCache.get(txId)) == null) {
            xml = new Element(this.xmlTagNameToUseForGroup);
            xml.addNamespaceDeclaration(AbstractXmlPublisherExtensionPoint.getXmlNamespace());
            xml.setAttribute("id", txId);
            xml.setAttribute("binary", binaryEncoding.name());
            this.addFormattedExtraGroupAttributes(context, xml);
            xmlCache.put(txId, xml);
        }
        return xml;
    }

    protected String toXmlGroupId(String[] columnNames, String[] data, String[] keyNames, String[] keys) {
        if (this.groupByColumnNames != null) {
            int index;
            Object[] columns;
            StringBuilder id = new StringBuilder();
            if (keys != null) {
                columns = keyNames;
                for (String col : this.groupByColumnNames) {
                    index = ArrayUtils.indexOf((Object[])columns, (Object)col, (int)0);
                    if (index >= 0) {
                        id.append(keys[index]);
                        continue;
                    }
                    id = new StringBuilder();
                    break;
                }
            }
            if (id.length() == 0) {
                columns = columnNames;
                for (String col : this.groupByColumnNames) {
                    index = ArrayUtils.indexOf((Object[])columns, (Object)col, (int)0);
                    if (index >= 0) {
                        id.append(data[index]);
                        continue;
                    }
                    return null;
                }
            }
            if (id.length() > 0) {
                return id.toString();
            }
        } else {
            this.log.warn("You did not specify 'groupByColumnNames'.  We cannot find any matches in the data to publish as XML if you don't.  You might as well turn off this filter!");
        }
        return null;
    }

    public String[] getNodeGroupIdsToApplyTo() {
        return this.nodeGroups;
    }

    public void setNodeGroups(String[] nodeGroups) {
        this.nodeGroups = nodeGroups;
    }

    public void setNodeGroup(String nodeGroup) {
        this.nodeGroups = new String[]{nodeGroup};
    }

    public void setPublisher(IPublisher publisher) {
        this.publisher = publisher;
    }

    public void setTimeStringGenerator(ITimeGenerator timeStringGenerator) {
        this.timeStringGenerator = timeStringGenerator;
    }

    public void setXmlFormat(Format xmlFormat) {
        this.xmlFormat = xmlFormat;
    }

    public void setTableNamesToPublishAsGroup(Set<String> tableNamesToPublishAsGroup) {
        this.tableNamesToPublishAsGroup = tableNamesToPublishAsGroup;
    }

    public void setTableNameToPublish(String tableName) {
        this.tableNamesToPublishAsGroup = new HashSet<String>(1);
        this.tableNamesToPublishAsGroup.add(tableName);
    }

    public void setXmlTagNameToUseForGroup(String xmlTagNameToUseForGroup) {
        this.xmlTagNameToUseForGroup = xmlTagNameToUseForGroup;
    }

    public void setTimeBetweenStatisticsPrintTime(long timeBetweenStatisticsPrintTime) {
        this.timeBetweenStatisticsPrintTime = timeBetweenStatisticsPrintTime;
    }

    public void setGroupByColumnNames(List<String> groupByColumnNames) {
        this.groupByColumnNames = groupByColumnNames;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }

    public static interface ITimeGenerator {
        public String getTime();
    }
}

