/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.db.sql.ISqlTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SqlUtils {
    private static Logger log = LoggerFactory.getLogger(SqlUtils.class);
    private static final int MAX_IDENTIFIER_LENGTH = 255;
    private static final int MAX_TABLE_PREFIX_LENGTH = 32;
    private static boolean captureOwner = false;
    private static List<ISqlTransaction> sqlTransactions = Collections.synchronizedList(new ArrayList());
    private static List<ISqlReadCursor<?>> sqlReadCursors = Collections.synchronizedList(new ArrayList());
    private static Map<ISqlTransaction, Exception> sqlTransactionsOwnerMap = new ConcurrentHashMap<ISqlTransaction, Exception>();
    private static Map<ISqlReadCursor<?>, Exception> sqlReadCursorsOwnerMap = new ConcurrentHashMap();

    protected static void addSqlTransaction(ISqlTransaction transaction) {
        sqlTransactions.add(transaction);
        if (captureOwner) {
            sqlTransactionsOwnerMap.put(transaction, new Exception());
        }
    }

    protected static void addSqlReadCursor(ISqlReadCursor<?> cursor) {
        sqlReadCursors.add(cursor);
        if (captureOwner) {
            sqlReadCursorsOwnerMap.put(cursor, new Exception());
        }
    }

    protected static void removeSqlReadCursor(ISqlReadCursor<?> cursor) {
        sqlReadCursors.remove(cursor);
        if (captureOwner) {
            sqlReadCursorsOwnerMap.remove(cursor);
        }
    }

    protected static void removeSqlTransaction(ISqlTransaction transaction) {
        sqlTransactions.remove(transaction);
        if (captureOwner) {
            sqlTransactionsOwnerMap.remove(transaction);
        }
    }

    public static List<ISqlTransaction> getOpenTransactions() {
        return new ArrayList<ISqlTransaction>(sqlTransactions);
    }

    public static List<ISqlReadCursor<?>> getOpenSqlReadCursors() {
        return new ArrayList(sqlReadCursors);
    }

    public static void logOpenResources() {
        List<ISqlReadCursor<?>> cursors = SqlUtils.getOpenSqlReadCursors();
        for (ISqlReadCursor<?> cursor : cursors) {
            Exception ex = sqlReadCursorsOwnerMap.get(cursor);
            if (ex == null) continue;
            log.error("The following stack contains the owner of an open read cursor", (Throwable)ex);
        }
        List<ISqlTransaction> transactions = SqlUtils.getOpenTransactions();
        for (ISqlTransaction transaction : transactions) {
            Exception ex = sqlTransactionsOwnerMap.get(transaction);
            if (ex == null) continue;
            log.error("The following stack contains the owner of an open database transaction", (Throwable)ex);
        }
    }

    public static void setCaptureOwner(boolean captureOwner) {
        SqlUtils.captureOwner = captureOwner;
    }

    public static String sanitizeIdentifier(String name) {
        if (name != null) {
            if (name.length() > 255) {
                name = name.substring(0, 255);
            }
            name = name.replaceAll("[\\.\\\"'/;]", "");
        }
        return name;
    }

    public static String sanitizeFunction(String name) {
        if (name != null) {
            if (name.length() > 255) {
                name = name.substring(0, 255);
            }
            name = name.replaceAll("[\\.\\\"'/; ]", "");
        }
        return name;
    }

    public static String sanitizeTablePrefix(String name) {
        if (name != null) {
            if (name.length() > 32) {
                name = name.substring(0, 32);
            }
            name = name.replaceAll("[^\\w_]", "_").replaceAll("_+", "_");
        }
        return name;
    }

    public static String escapeString(String s) {
        if (s != null) {
            s = s.replaceAll("'", "''");
        }
        return s;
    }
}

