/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.derby;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.alter.AddColumnChange;
import org.jumpmind.db.alter.TableChange;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.AbstractDdlBuilder;
import org.jumpmind.db.platform.PlatformUtils;

public class DerbyDdlBuilder
extends AbstractDdlBuilder {
    public DerbyDdlBuilder() {
        super("derby");
        this.databaseInfo.setMaxIdentifierLength(128);
        this.databaseInfo.setSystemForeignKeyIndicesAlwaysNonUnique(true);
        this.databaseInfo.addNativeTypeMapping(2003, "BLOB", 2004);
        this.databaseInfo.addNativeTypeMapping(-2, "CHAR {0} FOR BIT DATA");
        this.databaseInfo.addNativeTypeMapping(-7, "SMALLINT", 5);
        this.databaseInfo.addNativeTypeMapping(2001, "BLOB", 2004);
        this.databaseInfo.addNativeTypeMapping(2000, "BLOB", 2004);
        this.databaseInfo.addNativeTypeMapping(-4, "LONG VARCHAR FOR BIT DATA");
        this.databaseInfo.addNativeTypeMapping(-1, "CLOB", 2005);
        this.databaseInfo.addNativeTypeMapping(0, "LONG VARCHAR FOR BIT DATA", -4);
        this.databaseInfo.addNativeTypeMapping(1111, "BLOB", 2004);
        this.databaseInfo.addNativeTypeMapping(2006, "LONG VARCHAR FOR BIT DATA", -4);
        this.databaseInfo.addNativeTypeMapping(2002, "BLOB", 2004);
        this.databaseInfo.addNativeTypeMapping(-6, "SMALLINT", 5);
        this.databaseInfo.addNativeTypeMapping(-3, "VARCHAR {0} FOR BIT DATA");
        this.databaseInfo.addNativeTypeMapping("BOOLEAN", "SMALLINT", "SMALLINT");
        this.databaseInfo.addNativeTypeMapping("DATALINK", "LONG VARCHAR FOR BIT DATA", "LONGVARBINARY");
        this.databaseInfo.addNativeTypeMapping(-9, "VARCHAR", 12);
        this.databaseInfo.addNativeTypeMapping(-16, "VARCHAR", 12);
        this.databaseInfo.addNativeTypeMapping(-15, "CHAR", 1);
        this.databaseInfo.setDefaultSize(-2, 254);
        this.databaseInfo.setDefaultSize(1, 254);
        this.databaseInfo.setDefaultSize(-3, 254);
        this.databaseInfo.setDefaultSize(12, 254);
        this.databaseInfo.addNativeTypeMapping(8, "DOUBLE");
        this.databaseInfo.addNativeTypeMapping(6, "DOUBLE", 8);
        this.databaseInfo.setMaxSize("TIMESTAMP", 6);
        this.databaseInfo.setNonBlankCharColumnSpacePadded(true);
        this.databaseInfo.setBlankCharColumnSpacePadded(true);
        this.databaseInfo.setCharColumnSpaceTrimmed(false);
        this.databaseInfo.setEmptyStringNulled(false);
    }

    @Override
    protected String getNativeDefaultValue(Column column) {
        if (column.getMappedTypeCode() == -7 || PlatformUtils.supportsJava14JdbcTypes() && column.getMappedTypeCode() == PlatformUtils.determineBooleanTypeCode()) {
            return this.getDefaultValueHelper().convert(column.getDefaultValue(), column.getMappedTypeCode(), 5);
        }
        return super.getNativeDefaultValue(column);
    }

    @Override
    public String getSelectLastIdentityValues(Table table) {
        return "VALUES IDENTITY_VAL_LOCAL()";
    }

    @Override
    protected void writeColumnAutoIncrementStmt(Table table, Column column, StringBuilder ddl) {
        ddl.append("GENERATED BY DEFAULT AS IDENTITY");
    }

    @Override
    protected void writeGeneratedColumn(Table table, Column column, StringBuilder ddl) {
        String definition = this.getDefinitionForGeneratedColumn(table, column);
        if (!StringUtils.isBlank((CharSequence)definition)) {
            this.printIdentifier(this.getColumnName(column), ddl);
            if (!definition.startsWith("(") || !definition.endsWith(")")) {
                ddl.append(" GENERATED ALWAYS AS ").append("(").append(definition).append(")");
            } else {
                ddl.append(" GENERATED ALWAYS AS ").append(definition);
            }
        } else {
            this.writeColumnTypeDefaultRequired(table, column, ddl);
        }
    }

    @Override
    public void writeExternalIndexDropStmt(Table table, IIndex index, StringBuilder ddl) {
        ddl.append("DROP INDEX ");
        this.printIdentifier(this.getIndexName(index), ddl);
        this.printEndOfStatement(ddl);
    }

    @Override
    protected void writeCastExpression(Column sourceColumn, Column targetColumn, StringBuilder ddl) {
        String targetNativeType;
        String sourceNativeType = this.getBareNativeType(sourceColumn);
        if (sourceNativeType.equals(targetNativeType = this.getBareNativeType(targetColumn)) || (sourceNativeType.equalsIgnoreCase("CLOB") || sourceNativeType.equalsIgnoreCase("LONG VARCHAR")) && (targetNativeType.equalsIgnoreCase("CHAR") || targetNativeType.equalsIgnoreCase("VARCHAR") || targetNativeType.equalsIgnoreCase("LONG VARCHAR"))) {
            this.printIdentifier(this.getColumnName(sourceColumn), ddl);
        } else {
            if (TypeMap.isNumericType(sourceColumn.getMappedTypeCode()) && "VARCHAR".equalsIgnoreCase(targetNativeType)) {
                targetNativeType = "CHAR";
            }
            ddl.append(targetNativeType);
            ddl.append("(");
            this.printIdentifier(this.getColumnName(sourceColumn), ddl);
            ddl.append(")");
        }
    }

    @Override
    protected void processTableStructureChanges(Database currentModel, Database desiredModel, Table sourceTable, Table targetTable, List<TableChange> changes, StringBuilder ddl) {
        Iterator<TableChange> changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            AddColumnChange addColumnChange;
            TableChange change = changeIt.next();
            if (!(change instanceof AddColumnChange) || !(addColumnChange = (AddColumnChange)change).isAtEnd() || addColumnChange.getNewColumn().isAutoIncrement()) continue;
            this.processChange(currentModel, desiredModel, addColumnChange, ddl);
            changeIt.remove();
        }
        super.processTableStructureChanges(currentModel, desiredModel, sourceTable, targetTable, changes, ddl);
    }

    protected void processChange(Database currentModel, Database desiredModel, AddColumnChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("ADD COLUMN ");
        this.writeColumn(change.getChangedTable(), change.getNewColumn(), ddl);
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    @Override
    protected void writeCascadeAttributesForForeignKeyUpdate(ForeignKey key, StringBuilder ddl) {
        if (key.getOnUpdateAction() != ForeignKey.ForeignKeyAction.SETDEFAULT) {
            super.writeCascadeAttributesForForeignKeyUpdate(key, ddl);
        }
    }

    @Override
    protected void writeCascadeAttributesForForeignKeyDelete(ForeignKey key, StringBuilder ddl) {
        if (key.getOnDeleteAction() != ForeignKey.ForeignKeyAction.SETDEFAULT) {
            super.writeCascadeAttributesForForeignKeyDelete(key, ddl);
        }
    }
}

